/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.ftp;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.FtpInterface;
import coldfusion.tagext.net.FtpTag;
import coldfusion.tagext.net.ftp.ChannelSftpWrapper;
import coldfusion.tagext.net.ftp.FtpTagTableMetaData;
import coldfusion.tagext.net.ftp.JSCHLogger;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class SftpHandler
implements FtpInterface {
    private FtpTag ftpTag = null;
    private PageContext pageContext = null;
    private ChannelSftpWrapper mConnection = null;
    private final JSch jsch = new JSch();
    private static SimpleDateFormat fmtDate = new SimpleDateFormat("{'ts '''yyyy-MM-dd HH:mm:ss''}");
    private static final int SSH_FX_OK = 0;
    private static final int SSH_FX_FAILURE = 4;
    private static final int SSH_MSG_REQUEST_SUCCESS = 81;
    private static final int SSH_MSG_REQUEST_FAILURE = 82;
    private static final int SSH_MSG_USERAUTH_SUCCESS = 52;
    private static final int SSH_MSG_USERAUTH_FAILURE = 51;
    private static final String AUTH_FAIL = "USERAUTH fail";
    private static final String AUTH_CANCELLED_INVALID_PASSPHRASE = "User Authentication cancelled. Either invalid key or invalid passphrase.";
    private static final String USER_AUTH_FAIL = "User Authentication  failed";
    private static final String SSH_MSG_DISCONNECT = "SSH_MSG_DISCONNECT: 2 Too many authentication failures for root";
    private static final boolean SSH_RSA_ENABLED = Boolean.getBoolean("coldfusion.sftp.enable-ssh-rsa");
    private static final boolean SHA1_ALGORITHMS_ENABLED = Boolean.getBoolean("coldfusion.sftp.enable-sha1-algorithms");
    private static final String fingerPrint = System.getProperty("coldfusion.sftp.fingerprint", "sha-256");
    private static final String DH_KEY_SIZE;

    public SftpHandler(FtpTag ftptagObj, PageContext pageContextObj) {
        this.ftpTag = ftptagObj;
        this.pageContext = pageContextObj;
        JSch.setLogger((Logger)new JSCHLogger());
    }

    public void createConnection() {
        this.mConnection = this.getConnection();
    }

    public void closeConnection() {
        try {
            if (this.mConnection != null) {
                this.close(this.mConnection);
            }
        }
        catch (JSchException se) {
            this.checkError((RuntimeException)((Object)new SftpOperationException("CLOSE", se)));
        }
    }

    public void setConnectionResult() {
        if (this.mConnection.isConnected()) {
            this.setSftpTagResult(true, 52, RB.getString(FtpTag.class, (String)"FtpTag.sftpuserauth"));
        }
    }

    private void setSftpTagResult(String ReturnValue) {
        Struct r = new Struct();
        r.put((Object)"Succeeded", (Object)Boolean.TRUE);
        r.put((Object)"ReturnValue", (Object)ReturnValue);
        r.put((Object)"ErrorCode", (Object)new Integer(0));
        r.put((Object)"ErrorText", (Object)RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setSftpTagResult(boolean rc) {
        Struct r = new Struct();
        r.put((Object)"Succeeded", (Object)Boolean.TRUE);
        r.put((Object)"ReturnValue", (Object)(rc ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ErrorCode", (Object)new Integer(0));
        r.put((Object)"ErrorText", (Object)RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setSftpTagResult(boolean success, Throwable e) {
        Struct r = new Struct();
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ErrorCode", (Object)(success ? new Integer(0) : new Integer(-1)));
        if (e.getLocalizedMessage() != null && e.getLocalizedMessage().length() > 0) {
            r.put((Object)"ErrorText", (Object)e.getLocalizedMessage());
        } else {
            r.put((Object)"ErrorText", (Object)e.toString());
        }
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void setSftpTagResult(boolean success, int code, String str) {
        Struct r = new Struct();
        r.put((Object)"Succeeded", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        r.put((Object)"ReturnValue", (Object)(Integer.toString(code) + " " + str));
        r.put((Object)"ErrorCode", (Object)new Integer(code));
        r.put((Object)"ErrorText", (Object)str);
        this.pageContext.setAttribute(this.ftpTag.getResult(), (Object)r);
    }

    private void checkError(JSchException jex) {
        int FtpStatusCode = -1;
        String FtpStatusString = jex.getMessage();
        String msg = FtpStatusString.toUpperCase();
        FtpStatusCode = msg.indexOf("AUTHENTICATION") != -1 || msg.indexOf("PRIVATEKEY") != -1 ? 51 : 82;
        if (this.ftpTag.isStoponerror()) {
            throw new SftpConnectionException(jex);
        }
        this.setSftpTagResult(false, FtpStatusCode, FtpStatusString);
    }

    public void checkError(RuntimeException ex) {
        if (this.ftpTag.isStoponerror()) {
            throw ex;
        }
        this.setSftpTagResult(false, ex);
    }

    public void checkError(String action, IOException ex) {
        this.checkError((RuntimeException)((Object)new SftpOperationException(action, ex)));
    }

    private void checkError(int FtpStatusCode, String FtpStatusString) {
        if (this.ftpTag.isStoponerror()) {
            throw new SftpOperationException(this.ftpTag.getAction(), FtpStatusCode, FtpStatusString);
        }
        this.setSftpTagResult(false, FtpStatusCode, FtpStatusString);
    }

    private ChannelSftpWrapper getConnection() throws SftpOperationException {
        ChannelSftpWrapper connSftp = null;
        String mConnectionName = this.ftpTag.getConnection();
        if (mConnectionName != null && "".equals(mConnectionName)) {
            throw new SftpInvalidConnectionException(mConnectionName);
        }
        String fileNameEncoding = null;
        if (mConnectionName != null) {
            Object o = this.pageContext.findAttribute(mConnectionName);
            if (o instanceof ChannelSftpWrapper) {
                connSftp = (ChannelSftpWrapper)((Object)o);
            } else if (o != null && !"Open".equalsIgnoreCase(this.ftpTag.getAction())) {
                throw new SftpInvalidConnectionException(mConnectionName);
            }
            if (connSftp != null && !connSftp.isConnected()) {
                this.pageContext.removeAttribute(mConnectionName);
                fileNameEncoding = connSftp.getFileNameEncoding();
                connSftp = null;
            }
            if (connSftp == null && (this.ftpTag.getServer() == null || this.ftpTag.getUsername() == null || this.ftpTag.getPassword() == null && this.ftpTag.getKey() == null)) {
                throw new SftpInvalidConnectionException(mConnectionName);
            }
        }
        if (connSftp == null) {
            connSftp = new ChannelSftpWrapper(fileNameEncoding != null ? fileNameEncoding : this.ftpTag.getFileNameEncoding());
            JSchException lastException = null;
            try {
                String fingerPrint = null;
                Session session = this.jsch.getSession(this.ftpTag.getUsername(), this.ftpTag.getServer(), this.ftpTag.getPort());
                if (this.ftpTag.getKey() != null) {
                    this.jsch.addIdentity(this.ftpTag.getKey(), this.ftpTag.getPassphrase());
                }
                session.setPassword(this.ftpTag.getPassword());
                session.setTimeout((int)this.ftpTag.getTimeout());
                session.setConfig("StrictHostKeyChecking", "no");
                session.setConfig("dh-key-size", DH_KEY_SIZE);
                if (this.ftpTag.getProxyserver() != null) {
                    Properties prop = System.getProperties();
                    prop.put("ftpProxySet", "true");
                    prop.put("ftp.proxyHost", this.ftpTag.getProxyserver());
                    prop.put("ftp.proxyPort", Integer.toString(this.ftpTag.getPort()));
                    ProxyHTTP proxyHTTP = new ProxyHTTP(this.ftpTag.getProxyserver());
                    session.setProxy((Proxy)proxyHTTP);
                }
                session.connect();
                if (this.ftpTag.getFingerPrint() != null && this.ftpTag.getFingerPrint().length() > 0) {
                    fingerPrint = session.getHostKey().getFingerPrint(this.jsch);
                    if (!this.ftpTag.getFingerPrint().toLowerCase().equals(fingerPrint)) {
                        session.disconnect();
                        throw new SftpOperationException(this.ftpTag.getAction(), 51, RB.getString(FtpTag.class, (String)"FtpTag.FingerprintMismatch"));
                    }
                }
                connSftp.setSession(session);
                session.openChannel("sftp");
                connSftp.connect();
            }
            catch (JSchException e) {
                if (e.getMessage().equals(AUTH_FAIL)) {
                    e = new JSchException(AUTH_CANCELLED_INVALID_PASSPHRASE);
                } else if (e.getMessage().equals(USER_AUTH_FAIL)) {
                    e = new JSchException(SSH_MSG_DISCONNECT);
                }
                lastException = e;
                if (connSftp.isConnected()) {
                    connSftp.disconnect();
                }
                this.checkError(e);
            }
            if (lastException == null) {
                try {
                    int retries = this.ftpTag.getRetrycount();
                    while (retries-- > 0 && connSftp != null && !connSftp.isConnected()) {
                        connSftp.connect();
                    }
                }
                catch (Exception e2) {
                    JSchException e2;
                    if (e2.getMessage().equals(AUTH_FAIL)) {
                        e2 = new JSchException(AUTH_CANCELLED_INVALID_PASSPHRASE);
                    } else if (e2.getMessage().equals(USER_AUTH_FAIL)) {
                        e2 = new JSchException(SSH_MSG_DISCONNECT);
                    }
                    if (connSftp.isConnected()) {
                        connSftp.disconnect();
                    }
                    if (this.ftpTag.isStoponerror()) {
                        throw new SftpConnectionException(e2);
                    }
                    this.setSftpTagResult(false, e2);
                }
            }
        }
        if (mConnectionName != null && connSftp != null) {
            this.pageContext.setAttribute(mConnectionName, (Object)connSftp);
        }
        return connSftp;
    }

    private boolean close(ChannelSftp connSftp) throws JSchException {
        if (connSftp.isConnected()) {
            Session session = connSftp.getSession();
            connSftp.quit();
            connSftp.disconnect();
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.ftpTag.getConnection() != null) {
            this.pageContext.removeAttribute(this.ftpTag.getConnection());
        }
        this.setSftpTagResult(true, 81, RB.getString(FtpTag.class, (String)"FtpTag.sftpcloseconn"));
        return true;
    }

    public boolean changeDir(String Directory) throws IOException {
        boolean rc = true;
        try {
            this.mConnection.cd(Directory);
            this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        return rc;
    }

    public boolean createDir(String Directory) throws IOException {
        boolean rc = true;
        try {
            this.mConnection.mkdir(Directory);
            this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        return rc;
    }

    public boolean listDir(String Directory, String Name) throws IOException {
        boolean rc = true;
        try {
            Vector zin = this.listFiles(Directory);
            SftpTagTable results = new SftpTagTable();
            results.populate(zin, this.ftpTag.getDirectory(), this.ftpTag.getUsername(), this.ftpTag.getPassword(), this.mConnection.getSession().getHost(), this.ftpTag.getPort());
            this.pageContext.setAttribute(Name, (Object)results);
            this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        catch (JSchException se) {
            rc = false;
            this.checkError(se);
        }
        return rc;
    }

    public boolean removeDir(String directory) throws IOException {
        boolean rc = true;
        try {
            this.mConnection.rmdir(directory);
            this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFile(String remoteFile) throws IOException {
        boolean rc;
        block11: {
            rc = true;
            SftpTagProgressMonitor mon = new SftpTagProgressMonitor();
            String localFilePath = Utils.getFileFullPath((String)this.ftpTag.getLocalfile(), (PageContext)this.pageContext);
            File f = VFSFileFactory.getFileObject((String)localFilePath);
            OutputStream out = null;
            if (this.ftpTag.isFailifexists() && f.exists()) {
                this.checkError(18, RB.getString(FtpTag.class, (String)"FtpTag.LocalfileExists", (Object)this.ftpTag.getLocalfile()));
                return false;
            }
            try {
                if (this.mConnection.getSession().getTimeout() > 0) {
                    mon.setTimeOut(System.currentTimeMillis() + (long)this.mConnection.getSession().getTimeout());
                }
                out = VFSFileFactory.getOutputStream((File)f);
                this.mConnection.get(remoteFile, out, mon);
                this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
            }
            catch (SftpException se) {
                rc = false;
                this.checkError(se.id, se.getMessage());
            }
            catch (JSchException se) {
                rc = false;
                this.checkError(se);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (!rc && f.exists()) {
                    f.delete();
                }
                if (!mon.timedOut) break block11;
                throw new IOException("getFile operation exceeded TIMEOUT");
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFile(String remoteFile) throws IOException {
        boolean rc;
        block16: {
            rc = false;
            SftpTagProgressMonitor mon = new SftpTagProgressMonitor();
            File f = VFSFileFactory.getFileObject((String)this.ftpTag.getLocalfile());
            InputStream in = VFSFileFactory.getInputStream((File)f);
            try {
                if (this.mConnection.getSession().getTimeout() > 0) {
                    mon.setTimeOut(System.currentTimeMillis() + (long)this.mConnection.getSession().getTimeout());
                }
                this.mConnection.put(in, remoteFile, mon, 0);
                this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
            }
            catch (SftpException se) {
                rc = false;
                this.checkError(se.id, se.getMessage());
            }
            catch (JSchException se) {
                rc = false;
                this.checkError(se);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException se) {}
                if (!mon.timedOut) break block16;
                throw new IOException("putFile operation exceeded TIMEOUT");
            }
        }
        return rc;
    }

    public boolean rename(String ExistingName, String NewName) throws IOException {
        boolean rc = true;
        try {
            this.mConnection.rename(ExistingName, NewName);
            this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        return rc;
    }

    public boolean remove(String item) throws IOException {
        boolean rc = true;
        try {
            this.mConnection.rm(item);
            this.setSftpTagResult(true, 0, RB.getString(FtpTag.class, (String)"FtpTag.sftpsuccess"));
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
            throw new IOException(se.getMessage());
        }
        return rc;
    }

    public boolean getCurrentDir() throws IOException {
        boolean rc = true;
        try {
            this.setSftpTagResult(this.mConnection.pwd());
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        return rc;
    }

    public boolean getCurrentURL() throws IOException {
        boolean rc = true;
        String dir = null;
        StringBuffer buf = new StringBuffer("ftp://");
        try {
            buf.append(this.mConnection.getSession().getHost());
            dir = this.mConnection.pwd();
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        catch (JSchException se) {
            rc = false;
            this.checkError(se);
        }
        if (dir != null) {
            if (!dir.startsWith("/")) {
                buf.append("/");
            }
            buf.append(dir);
        }
        this.setSftpTagResult(buf.toString());
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDir(String Directory) throws IOException {
        String currentDir = null;
        boolean rc = true;
        try {
            currentDir = this.mConnection.pwd();
            this.mConnection.cd(Directory);
            this.setSftpTagResult(true);
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        finally {
            try {
                if (currentDir != null) {
                    this.mConnection.cd(currentDir);
                }
            }
            catch (SftpException sftpException) {}
        }
        return rc;
    }

    public boolean existsFile(String RemoteFile) throws IOException {
        boolean rc = true;
        boolean ReturnValue = false;
        Vector files = null;
        try {
            files = this.listFiles(RemoteFile);
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        if (files != null && files.size() == 1 && !((ChannelSftp.LsEntry)files.get(0)).getAttrs().isDir()) {
            ReturnValue = true;
        }
        this.setSftpTagResult(ReturnValue);
        return rc;
    }

    public boolean exists(String RemoteFile) throws IOException {
        boolean rc = true;
        boolean ReturnValue = false;
        Vector files = null;
        try {
            files = this.listFiles(RemoteFile);
        }
        catch (SftpException se) {
            rc = false;
            this.checkError(se.id, se.getMessage());
        }
        if (files != null && files.size() > 0) {
            ReturnValue = true;
        }
        this.setSftpTagResult(ReturnValue);
        return rc;
    }

    private Vector listFiles(String RemoteFile) throws SftpException {
        return this.mConnection.ls(RemoteFile);
    }

    public void setFtptag(FtpTag tag) {
        this.ftpTag = tag;
    }

    public boolean isPassive() {
        if (this.ftpTag != null) {
            return this.ftpTag.getPassive();
        }
        return false;
    }

    public boolean isPassiveSet() {
        if (this.ftpTag != null) {
            return this.ftpTag.isPassiveSet();
        }
        return false;
    }

    public boolean site(String param) throws IOException {
        throw new SftpNotSupportedException(this.ftpTag.getAction());
    }

    public boolean quote(String param) throws IOException {
        throw new SftpNotSupportedException(this.ftpTag.getAction());
    }

    public boolean acct(String param) throws IOException {
        throw new SftpNotSupportedException(this.ftpTag.getAction());
    }

    public boolean allo(int param) throws IOException {
        throw new SftpNotSupportedException(this.ftpTag.getAction());
    }

    public void setBufferSize(int param) throws IOException {
        throw new SftpNotSupportedException("setBufferSize");
    }

    public String getDefaultFileNameEncoding() {
        return "UTF-8";
    }

    public String getFileNameEncoding() {
        String encoding;
        String string = encoding = this.ftpTag.getFileNameEncoding() != null ? this.ftpTag.getFileNameEncoding() : this.mConnection.getFileNameEncoding();
        if (encoding == null) {
            return FtpTag.DEFAULT_CHARSET;
        }
        return encoding;
    }

    static {
        JSch.setConfig((String)"cipher.s2c", (String)"aes128-ctr,aes192-ctr,aes256-ctr,aes128-cbc,3des-cbc,aes192-cbc,aes256-cbc,blowfish-cbc,aes128-gcm@openssh.com,aes256-gcm@openssh.com");
        JSch.setConfig((String)"cipher.c2s", (String)"aes128-ctr,aes192-ctr,aes256-ctr,aes128-cbc,3des-cbc,aes192-cbc,aes256-cbc,blowfish-cbc,aes128-gcm@openssh.com,aes256-gcm@openssh.com");
        if (SSH_RSA_ENABLED) {
            String algorithms = "ssh-rsa,ssh-dss,ssh-ed25519,ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,rsa-sha2-512,rsa-sha2-256";
            JSch.setConfig((String)"server_host_key", (String)algorithms);
            JSch.setConfig((String)"PubkeyAcceptedAlgorithms", (String)algorithms);
        }
        if ("md5".equalsIgnoreCase(fingerPrint)) {
            JSch.setConfig((String)"FingerprintHash", (String)"md5");
        }
        if (SHA1_ALGORITHMS_ENABLED) {
            String kexAlgorithms = "diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha1,diffie-hellman-group1-sha1,curve25519-sha256,curve25519-sha256@libssh.org,ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group-exchange-sha256,diffie-hellman-group16-sha512,diffie-hellman-group18-sha512,diffie-hellman-group14-sha256";
            JSch.setConfig((String)"kex", (String)kexAlgorithms);
            String macAlgorithms = "hmac-sha2-256-etm@openssh.com,hmac-sha2-512-etm@openssh.com,hmac-sha1-etm@openssh.com,hmac-sha2-256,hmac-sha2-512,hmac-sha1,hmac-md5,hmac-sha1-96,hmac-md5-96";
            JSch.setConfig((String)"mac.s2c", (String)macAlgorithms);
            JSch.setConfig((String)"mac.c2s", (String)macAlgorithms);
        }
        DH_KEY_SIZE = String.valueOf(AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger("coldfusion.sftp.dh.maxkeysize", 1024);
            }
        }));
    }

    public class SftpOperationException
    extends ApplicationException {
        public String Action;
        public String Cause;
        public int ErrorCode;

        SftpOperationException(String action, int errorCode, String cause) {
            this.ErrorCode = 4;
            this.Action = action;
            switch (errorCode) {
                case 2: {
                    String fileName = "";
                    if ("Remove".equalsIgnoreCase(action)) {
                        fileName = SftpHandler.this.ftpTag.getItem();
                    }
                    if ("PutFile".equalsIgnoreCase(action)) {
                        fileName = SftpHandler.this.ftpTag.getRemotefile();
                    }
                    if ("getFile".equalsIgnoreCase(action)) {
                        fileName = SftpHandler.this.ftpTag.getRemotefile();
                    }
                    if ("ExistsFile".equalsIgnoreCase(action)) {
                        fileName = SftpHandler.this.ftpTag.getRemotefile();
                    }
                    if ("Rename".equalsIgnoreCase(action)) {
                        fileName = SftpHandler.this.ftpTag.getExisting();
                    }
                    if ("".equalsIgnoreCase(fileName)) {
                        fileName = SftpHandler.this.ftpTag.getDirectory();
                    }
                    throw new SftpOperationFNFException(action, fileName);
                }
                case 4: {
                    throw new SftpOperationBadPathException(action, cause);
                }
            }
            this.Cause = cause;
            this.ErrorCode = errorCode;
        }

        SftpOperationException(String a, Throwable ex) {
            super(ex);
            this.ErrorCode = 4;
            this.Action = a;
            this.Cause = ex.getLocalizedMessage();
        }
    }

    public class SftpConnectionException
    extends ApplicationException {
        public String Cause;

        SftpConnectionException(Throwable ex) {
            super(ex);
            this.Cause = ex.getLocalizedMessage();
        }
    }

    public class SftpInvalidConnectionException
    extends ApplicationException {
        public String ConnectionName = null;

        SftpInvalidConnectionException(String connSftp) {
            this.ConnectionName = "\"" + connSftp + "\"";
        }
    }

    class SftpTagTable
    extends QueryTable {
        SftpTagTable() {
        }

        public void populate(Vector zin, String workingDir, String username, String password, String server, int port) {
            this.meta = new FtpTagTableMetaData();
            this.col_count = this.meta.getColumnCount();
            this.col_names = this.meta.getColumnLabels();
            if (zin == null) {
                this.row_count = 0;
                return;
            }
            if (!((String)workingDir).endsWith("/")) {
                workingDir = (String)workingDir + "/";
            }
            Enumeration entries = zin.elements();
            while (entries.hasMoreElements()) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)entries.nextElement();
                SftpATTRS attrs = entry.getAttrs();
                String fn = entry.getFilename();
                try {
                    fn = new String(entry.getFilename().getBytes(SftpHandler.this.getDefaultFileNameEncoding()), SftpHandler.this.getFileNameEncoding());
                }
                catch (Exception e) {
                    fn = entry.getFilename();
                }
                if (fn.equals(".") || fn.equals("..")) continue;
                Object[] col_data = new Object[this.col_count];
                col_data[0] = fn;
                col_data[1] = (String)workingDir + fn;
                col_data[2] = server + (String)workingDir + fn;
                col_data[3] = attrs.isDir() ? new Long(0L) : new Long(attrs.getSize());
                col_data[4] = fmtDate.format(new Date((long)attrs.getMTime() * 1000L));
                col_data[5] = "";
                col_data[6] = attrs.isDir() ? "YES" : "NO";
                col_data[7] = "not currently supported";
                this.addRow(col_data);
            }
        }
    }

    class SftpTagProgressMonitor
    implements SftpProgressMonitor {
        long endTime = Long.MAX_VALUE;
        boolean timedOut = false;

        SftpTagProgressMonitor() {
        }

        public void init(int op, String src, String dest, long max) {
        }

        public void setTimeOut(long e) {
            this.endTime = e;
        }

        public boolean count(long count) {
            if (System.currentTimeMillis() > this.endTime) {
                this.timedOut = true;
                return false;
            }
            return true;
        }

        public void end() {
        }
    }

    public class SftpNotSupportedException
    extends ApplicationException {
        public String Action;

        SftpNotSupportedException(String action) {
            this.Action = action;
        }
    }

    public class SftpOperationBadPathException
    extends ApplicationException {
        public String Action;
        public String Cause;

        SftpOperationBadPathException(String action, String cause) {
            this.Action = action;
            this.Cause = cause;
        }
    }

    public class SftpOperationFNFException
    extends ApplicationException {
        public String Action;
        public String fileName;

        SftpOperationFNFException(String action, String strFileName) {
            this.Action = action;
            this.fileName = strFileName;
        }
    }
}

