/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TracingMode {
    ACTIVE("Active"),
    PASS_THROUGH("PassThrough"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TracingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TracingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TracingMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TracingMode> knownValues() {
        return Stream.of(TracingMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

