/*
 * Decompiled with CFR 0.152.
 */
package com.ddtek.portal.logging;

import com.ddtek.portal.logging.DateFormatCache;
import com.ddtek.portal.logging.ThreadNameMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLineFormatter
extends Formatter {
    private static final String LINE_SEP = System.lineSeparator();
    private static final String ST_SEP = LINE_SEP + ' ';
    private static final String TIME_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private static final int GLOBAL_CACHE_SIZE = 30;
    private static final int LOCAL_CACHE_SIZE = 5;
    private static final DateFormatCache globalDateCache = new DateFormatCache(30, "dd-MMM-yyyy HH:mm:ss", null);
    private static final ThreadLocal<DateFormatCache> localDateCache = ThreadLocal.withInitial(() -> new DateFormatCache(5, TIME_FORMAT, globalDateCache));

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTimestamp(stringBuilder, logRecord.getMillis());
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getLevel());
        stringBuilder.append(' ');
        stringBuilder.append('[');
        String string = ThreadNameMapper.get(logRecord.getThreadID());
        if (string == null) {
            string = Thread.currentThread().getName();
        }
        stringBuilder.append(string);
        stringBuilder.append(']');
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getSourceClassName());
        stringBuilder.append('.');
        stringBuilder.append(logRecord.getSourceMethodName());
        stringBuilder.append(' ');
        stringBuilder.append(this.formatMessage(logRecord));
        if (logRecord.getThrown() != null) {
            stringBuilder.append(ST_SEP);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            stringBuilder.append(stringWriter.getBuffer());
        }
        stringBuilder.append(LINE_SEP);
        return stringBuilder.toString();
    }

    protected void addTimestamp(StringBuilder stringBuilder, long l) {
        stringBuilder.append(localDateCache.get().getFormat(l));
        long l2 = l % 1000L;
        stringBuilder.append('.');
        if (l2 < 100L) {
            stringBuilder.append('0');
            if (l2 < 10L) {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(l2);
    }
}

