/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.es;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.Settings;
import coldfusion.monitor.beans.Cluster;
import coldfusion.monitor.beans.ESDetails;
import coldfusion.monitor.beans.Group;
import coldfusion.monitor.beans.NonRequestData;
import coldfusion.monitor.beans.RequestData;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.datastore.MonitoringDatastoreClient;
import coldfusion.monitor.datastore.QueryBuilder;
import coldfusion.monitor.es.RingBufferESRequestEvent;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.monitor.util.PasswordUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceFactory;
import coldfusion.util.URLEncoder;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RestHighLevelClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.XContentType;

public enum ElasticSearchClient implements MonitoringDatastoreClient
{
    INSTANCE;

    private RestClient restClient;
    private Sniffer sniffer;
    private boolean isInitialized;
    String libDir = System.getProperty("lib_dir");
    private Logger logger = CFLogs.MONITOR_LOG;
    ESDetails esDetails;
    String esHost = "";
    int esPort = 0;
    String esProtocol;
    String esUsername;
    String esPassword;
    private BulkProcessor bulkProcessor;
    private Disruptor<RingBufferESRequestEvent> disruptor;
    private static boolean dump_to_es;
    private static boolean dump_to_lmax;
    private String bulkWaitSrategy = "LITE";
    private int connectionRequestTimeOut = 120000;
    private int socketTimeOut = 120000;
    private int connectionTimeOut = 120000;
    private int retryTimeOut = 12000;
    private int es_bulk_action = 2000;
    private int es_bulk_size = 10;
    private int es_sniffInterval = 30000;
    private int es_bulk_threads = Runtime.getRuntime().availableProcessors();
    private int es_flush_interval = 10;
    private int es_numberof_retry = 3;
    private int ring_buffer_size = 2048;
    private int retryCount = 0;

    public void initializeDBParameters(ConfigMap generalSettings) {
        this.esHost = Settings.toStringValue((Map)generalSettings, (String)"elasticsearchhost", (String)"");
        this.esPort = Settings.toIntValue((Map)generalSettings, (String)"elasticsearchport", (int)0);
        this.esProtocol = Settings.toStringValue((Map)generalSettings, (String)"elasticSearchProtocol", (String)"http");
        this.esUsername = Settings.toStringValue((Map)generalSettings, (String)"elasticSearchUsername", (String)"");
        this.esPassword = PasswordUtils.decryptPassword((String)Settings.toStringValue((Map)generalSettings, (String)"elasticSearchPassword", (String)""));
        this.esDetails = new ESDetails();
        this.esDetails.setElasticSearchHost(this.esHost);
        this.esDetails.setElsaticSearchPort(this.esPort);
        this.esDetails.setElasticSearchProtocol(this.esProtocol);
        this.esDetails.setUsername(this.esUsername);
        this.esDetails.setPassword(this.esPassword);
    }

    private void initializeESConfig(ConfigMap generalSettings) {
        this.bulkWaitSrategy = Settings.toStringValue((Map)generalSettings, (String)"bulkwaitstrategy", (String)"LITE");
        this.connectionRequestTimeOut = Settings.toIntValue((Map)generalSettings, (String)"esconnectionrequesttimeout", (int)120000);
        this.socketTimeOut = Settings.toIntValue((Map)generalSettings, (String)"essockettimeout", (int)120000);
        this.connectionTimeOut = Settings.toIntValue((Map)generalSettings, (String)"esconnectiontimeout", (int)120000);
        this.retryTimeOut = Settings.toIntValue((Map)generalSettings, (String)"esretrytimeout", (int)120000);
        this.es_bulk_action = Settings.toIntValue((Map)generalSettings, (String)"esbulkaction", (int)2000);
        this.es_bulk_size = Settings.toIntValue((Map)generalSettings, (String)"esbulksize", (int)10);
        this.es_sniffInterval = Settings.toIntValue((Map)generalSettings, (String)"essniffinterval", (int)30000);
        this.es_bulk_threads = Settings.toIntValue((Map)generalSettings, (String)"esbulkthreads", (int)Runtime.getRuntime().availableProcessors());
        this.es_flush_interval = Settings.toIntValue((Map)generalSettings, (String)"esflushinterval", (int)10);
        this.es_numberof_retry = Settings.toIntValue((Map)generalSettings, (String)"esnumberofretry", (int)3);
        this.ring_buffer_size = Settings.toIntValue((Map)generalSettings, (String)"ringbuffersize", (int)2048);
    }

    public void initialize(ConfigMap generalSettings) {
        try {
            this.initializeDBParameters(generalSettings);
            this.initializeESConfig(generalSettings);
            ESDetails esDetails = new ESDetails();
            esDetails.setElasticSearchHost(this.esHost);
            esDetails.setElsaticSearchPort(this.esPort);
            esDetails.setElasticSearchProtocol(this.esProtocol);
            esDetails.setUsername(this.esUsername);
            esDetails.setPassword(this.esPassword);
            if (!this.validateUrl(esDetails)) {
                return;
            }
            this.createClients(esDetails);
            this.isInitialized = true;
        }
        catch (Exception ex) {
            this.isInitialized = false;
        }
    }

    public void setIntialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public String query(String index, String requestBody, String filterPath) {
        String responseJson = "";
        Response response = null;
        NStringEntity entity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
        try {
            if (filterPath == null) {
                Request request = new Request("POST", index + "/_search/template?ignore_unavailable=true");
                request.setEntity((HttpEntity)entity);
                response = this.restClient.performRequest(request);
            } else {
                Request request = new Request("POST", index + "/_search/template?filter_path=" + filterPath + "?ignore_unavailable=true");
                request.setEntity((HttpEntity)entity);
                response = this.restClient.performRequest(request);
            }
            responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            System.err.println("error while making query from es");
            e.printStackTrace();
        }
        return responseJson;
    }

    public String getElasticSearchHost() {
        return this.esHost;
    }

    public int getElasticSearchPort() {
        return this.esPort;
    }

    public boolean validateUrl(ESDetails esDetails) {
        if (esDetails.getElasticSearchHost().length() <= 0 || esDetails.getElsaticSearchPort() == 0) {
            if (!ServiceFactory.getRuntimeService().isCommandLineCompile()) {
                // empty if block
            }
            return false;
        }
        if (!this.isElasticSearchUp(esDetails)) {
            this.logger.warn((Object)("ElasticSearch instance host:port " + esDetails.getElasticSearchHost() + ":" + esDetails.getElsaticSearchPort() + " is not running, hence Monitoring Service is not initialized"));
            return false;
        }
        return true;
    }

    public boolean isElasticSearchUp(ESDetails esDetails) {
        boolean running = false;
        if (this.restClient == null) {
            this.createClients(esDetails);
        }
        try {
            Request request = new Request("GET", "/");
            request.addParameter("pretty", "true");
            Response response = this.restClient.performRequest(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                running = true;
            }
        }
        catch (Exception e) {
            running = false;
            this.logger.error((Object)("ElasticSearch with host: " + esDetails.getElasticSearchHost() + " and port: " + esDetails.getElsaticSearchPort() + " is not running. Exception: " + e.getMessage()));
        }
        return running;
    }

    private RestClient createRestClient(ESDetails esDetails) {
        RestClient restClient = null;
        RestClientBuilder builder = null;
        if (esDetails != null && esDetails.getUsername() != null && esDetails.getPassword() != null && esDetails.getUsername() != "" && esDetails.getPassword() != "") {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esDetails.getUsername(), esDetails.getPassword()));
            builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esDetails.getElasticSearchHost(), esDetails.getElsaticSearchPort(), esDetails.getElasticSearchProtocol())}).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    return requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(3600000);
                }
            }).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                    return httpAsyncClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 4).build());
                }
            });
        } else {
            builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esDetails.getElasticSearchHost(), esDetails.getElsaticSearchPort(), esDetails.getElasticSearchProtocol())}).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                    return requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(3600000);
                }
            }).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                    return httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 4).build());
                }
            });
        }
        restClient = builder.build();
        return restClient;
    }

    public void createClients(ESDetails esDetails) {
        if (this.restClient == null) {
            this.restClient = this.createRestClient(esDetails);
        }
        if (esDetails.getElasticSearchProtocol().equalsIgnoreCase("https")) {
            ElasticsearchNodesSniffer nodesSniffer = new ElasticsearchNodesSniffer(this.restClient, (long)this.es_sniffInterval, ElasticsearchNodesSniffer.Scheme.HTTPS);
            this.sniffer = Sniffer.builder((RestClient)this.restClient).setSniffIntervalMillis(this.es_sniffInterval).setNodesSniffer((NodesSniffer)nodesSniffer).build();
        } else {
            this.sniffer = Sniffer.builder((RestClient)this.restClient).setSniffIntervalMillis(this.es_sniffInterval).build();
        }
        try {
            RestHighLevelClient client = new RestHighLevelClientBuilder(this.restClient).setApiCompatibilityMode(Boolean.valueOf(true)).build();
            org.elasticsearch.common.settings.Settings settings = org.elasticsearch.common.settings.Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), "high-level-client").build();
            BulkProcessor.Builder builder = BulkProcessor.builder((request, bulkListener) -> client.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)this.getBulkListener(), (String)"bulk-processor-name");
            builder.setBulkActions(this.es_bulk_action);
            builder.setBulkSize(new ByteSizeValue((long)this.es_bulk_size, ByteSizeUnit.MB));
            builder.setConcurrentRequests(this.es_bulk_threads);
            builder.setFlushInterval(TimeValue.timeValueSeconds((long)this.es_flush_interval));
            builder.setBackoffPolicy(BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueSeconds((long)1L), (int)this.es_numberof_retry));
            this.bulkProcessor = builder.build();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in client creation " + e.getMessage()));
        }
        String DUMP_ES = System.getProperty("DUMP_ES", "true");
        dump_to_es = Boolean.parseBoolean(DUMP_ES);
        String DUMP_LMAX = System.getProperty("DUMP_LMAX", "true");
        dump_to_lmax = Boolean.parseBoolean(DUMP_LMAX);
        this.logger.debug((Object)("BULK_ACTION: " + this.es_bulk_action));
        this.logger.debug((Object)("BULK_SIZE: " + this.es_bulk_size));
        this.logger.debug((Object)("Bulk Wait Strategy: " + this.bulkWaitSrategy));
        this.logger.debug((Object)("BUFFER_SIZE: " + this.ring_buffer_size));
        this.logger.debug((Object)("BULK_THREADS: " + this.es_bulk_threads));
        this.logger.debug((Object)("Dump to LMAX: " + DUMP_LMAX));
        this.logger.debug((Object)("Dump to ES: " + DUMP_ES));
        if (dump_to_lmax) {
            this.disruptor = new Disruptor(RingBufferESRequestEvent::new, this.ring_buffer_size, Executors.defaultThreadFactory(), ProducerType.MULTI, this.getWaitStrategy());
            this.disruptor.handleEventsWith(new EventHandler[]{(event, sequence, endOfBatch) -> {
                if (event.getRequestData() != null) {
                    event.converReqestDataToIndexRequest();
                }
                if (event.getNonRequestData() != null) {
                    event.converNonReqestDataToIndexRequest();
                }
                if (dump_to_es) {
                    this.bulkProcessor.add(event.getRequest());
                }
            }});
            this.disruptor.start();
        }
    }

    private WorkHandlerImpl[] getWorkHandlers(int count) {
        WorkHandlerImpl[] workHandlers = new WorkHandlerImpl[count];
        for (int i = 0; i < count; ++i) {
            WorkHandlerImpl impl;
            workHandlers[i] = impl = new WorkHandlerImpl();
        }
        return workHandlers;
    }

    private WaitStrategy getWaitStrategy() {
        switch (this.bulkWaitSrategy) {
            case "BLOCK": {
                return new BlockingWaitStrategy();
            }
            case "YIELD": {
                return new YieldingWaitStrategy();
            }
            case "SLEEP": {
                return new SleepingWaitStrategy();
            }
            case "SPIN": {
                return new BusySpinWaitStrategy();
            }
            case "LITE": {
                return new LiteBlockingWaitStrategy();
            }
        }
        return new BlockingWaitStrategy();
    }

    private BulkProcessor.Listener getBulkListener() {
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                int numberOfActions = request.numberOfActions();
                ElasticSearchClient.this.logger.debug((Object)("Executing bulk" + executionId + " with " + numberOfActions + " requests"));
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    ElasticSearchClient.this.logger.error((Object)("Bulk Failed" + response.buildFailureMessage()));
                } else {
                    ElasticSearchClient.this.logger.debug((Object)("Bulk requests completed in " + response.getTook().getMillis() + " milliseconds"));
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                if (failure instanceof NoNodeAvailableException) {
                    ElasticSearchClient.this.logger.error((Object)"Datastore server is not accessible", failure);
                } else {
                    ElasticSearchClient.this.logger.error((Object)"Error sending data to datastore server", failure);
                    failure.printStackTrace();
                }
            }
        };
        return listener;
    }

    public void closeConnection() {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
            if (this.restClient != null) {
                this.restClient.close();
            }
            if (this.bulkProcessor != null) {
                this.bulkProcessor.flush();
                this.bulkProcessor.close();
            }
            if (this.disruptor != null) {
                this.disruptor.shutdown();
            }
            this.restClient = null;
            this.sniffer = null;
            this.bulkProcessor = null;
            this.isInitialized = false;
        }
        catch (IOException e) {
            this.logger.error((Object)"Error Closing the ES Client ", (Throwable)e);
        }
    }

    public Cluster findClusterId(String host, String port) {
        Map params = Collections.emptyMap();
        String query = this.getClusterQuery(host, port);
        NStringEntity entity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", "/cluster_config_data/_search/template");
            request.addParameters(params);
            request.setEntity((HttpEntity)entity);
            Response indexResponse = INSTANCE.getRestClient().performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)indexResponse.getEntity());
            Cluster clusterObj = JSONConverter.INSTANCE.toClusterObject(responseBody);
            this.logger.debug((Object)("cluster id set is  " + Configuration.INSTANCE.getClusterId()));
            return clusterObj;
        }
        catch (IOException io) {
            this.logger.debug((Object)"Current node is not a part of any cluster", (Throwable)io);
            return null;
        }
    }

    public HttpEntity call(String method, String endpoint, Map<String, String> params, HttpEntity entity) {
        try {
            Request request = new Request("GET", "/alerts/_search");
            request.addParameter("pretty", "true");
            request.setEntity(entity);
            Response response = INSTANCE.getRestClient().performRequest(request);
            if (response != null) {
                return response.getEntity();
            }
        }
        catch (IOException io) {
            this.logger.debug((Object)("Error while calling the method " + method + ", endpoint " + endpoint), (Throwable)io);
        }
        return null;
    }

    private String getClusterQuery(String host, String port) {
        String query = QueryBuilder.getQuery((String)"cluster-group-from-instance", Arrays.asList("host", "port"), Arrays.asList(host, port));
        return query;
    }

    public String findGroupId(String instanceId) {
        Map params = Collections.emptyMap();
        String query = JSONConverter.INSTANCE.getClusterQuery(instanceId);
        NStringEntity entity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", "/group_config_data/_search");
            request.setEntity((HttpEntity)entity);
            request.addParameters(params);
            Response indexResponse = INSTANCE.getRestClient().performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)indexResponse.getEntity());
            Group groupObj = JSONConverter.INSTANCE.toGroupObject(responseBody);
            if (groupObj != null) {
                this.logger.debug((Object)("Group id set is  " + groupObj.getGroupId()));
                Configuration.INSTANCE.setGroupId(groupObj.getGroupId());
                Configuration.INSTANCE.setGroupName(groupObj.getGroupName());
                return groupObj.getGroupId();
            }
            if (Configuration.INSTANCE.getGroupId() != null) {
                Configuration.INSTANCE.setGroupId(null);
                Configuration.INSTANCE.setGroupName(null);
            }
        }
        catch (IOException io) {
            this.logger.error((Object)"Current node is not part of group", (Throwable)io);
        }
        return null;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public boolean isInitialized() {
        if (this.isInitialized && Configuration.INSTANCE.isEsHealthy()) {
            return true;
        }
        if (this.isInitialized && !Configuration.INSTANCE.isEsHealthy()) {
            this.logger.debug((Object)"ES is not reachable, trying to connect");
            Configuration.INSTANCE.setEsHealthy(this.isElasticSearchUp(this.esDetails));
        }
        return false;
    }

    public void updateDocument(String index, String docId, String scriptCode, Map<String, Object> params) {
        Script script = new Script(ScriptType.INLINE, "painless", scriptCode, params);
        String requestId = docId;
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(docId);
        Script inline = new Script(ScriptType.INLINE, "painless", scriptCode, params);
        updateRequest.script(inline);
        updateRequest.retryOnConflict(3);
        this.sendMetric(updateRequest);
    }

    public void submit(String json) {
        IndexRequest indexRequest = new IndexRequest(MonitoringServiceUtils.getLatestRequestIndex());
        indexRequest.source(json, XContentType.JSON);
        this.sendMetric(indexRequest);
    }

    public void submit(Map data) {
        IndexRequest indexRequest = new IndexRequest(MonitoringServiceUtils.getLatestRequestIndex());
        indexRequest.source(data);
        this.sendMetric(indexRequest);
    }

    public void submit(RequestData data) {
        this.sendMetric(data);
    }

    public void submit(NonRequestData data) {
        this.sendMetric(data);
    }

    public void submit(String json, String index) {
        IndexRequest request = new IndexRequest(index).source(json, XContentType.JSON);
        this.sendMetric(request);
    }

    public void submit(String json, String index, String id) {
        IndexRequest request = new IndexRequest(index, id).source(json, XContentType.JSON);
        this.sendMetric(request);
    }

    private void sendMetricDirect(IndexRequest request) {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.add(request);
        }
    }

    private void sendMetric(IndexRequest request) {
        if (dump_to_lmax) {
            this.disruptor.publishEvent((event, sequence) -> event.setRequest(request));
        }
    }

    public void sendMetric(UpdateRequest request) {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.add((DocWriteRequest)request);
        }
    }

    private void sendMetric(RequestData requestData) {
        if (dump_to_lmax) {
            this.disruptor.publishEvent((event, sequence) -> event.setRequestData(requestData));
        }
    }

    private void sendMetric(NonRequestData nonrequestData) {
        if (dump_to_lmax) {
            this.disruptor.publishEvent((event, sequence) -> event.setNonRequestData(nonrequestData));
        }
    }

    public String getDocument(String index, String id) {
        index = index.replaceAll("/", "");
        return this.getDocument(index + "/_doc/" + id);
    }

    public String getDocument(String endPoint) {
        String json = null;
        try {
            Request request = new Request("GET", endPoint);
            request.addParameters(Collections.singletonMap("pretty", "true"));
            Response response = this.restClient.performRequest(request);
            HttpEntity entity = response.getEntity();
            json = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException ex) {
            this.logger.error((Object)"Error retrieving configuration object, verify PMT settings", (Throwable)ex);
        }
        return json;
    }

    public boolean indexExists(String index) {
        if (this.restClient != null) {
            try {
                Request request = new Request("GET", index);
                Response response = this.restClient.performRequest(request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return true;
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)(index + " does not exists"), (Throwable)ex);
            }
        }
        return false;
    }

    public boolean documentExists(String index, String docid) {
        index = index.replaceAll("/", "");
        return this.documentExists(index + "/_doc/" + docid);
    }

    public boolean documentExists(String url) {
        if (this.restClient != null) {
            try {
                Request request = new Request("GET", url);
                Response response = this.restClient.performRequest(request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return true;
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)(url + " does not exists"), (Throwable)ex);
            }
        }
        return false;
    }

    public int indexDocument(String str, String index, int x) {
        this.logger.debug((Object)("indexing data for index" + index));
        Response indexResponse = null;
        NStringEntity entity = new NStringEntity(str, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", index + "/_doc/");
            request.addParameters(Collections.emptyMap());
            request.setEntity((HttpEntity)entity);
            indexResponse = this.restClient.performRequest(request);
        }
        catch (IOException ex) {
            this.logger.error((Object)("Exception while calling indexDocument :" + ex.getMessage()));
            ex.printStackTrace();
        }
        return indexResponse.getStatusLine().getStatusCode();
    }

    public int indexDocument(String str, String index, String id) {
        this.logger.debug((Object)("indexing data for index" + index));
        Response indexResponse = null;
        NStringEntity entity = new NStringEntity(str, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", index + "/_doc/" + URLEncoder.encode((String)id, (String)"UTF-8", (boolean)true));
            request.setEntity((HttpEntity)entity);
            indexResponse = this.restClient.performRequest(request);
        }
        catch (IOException ex) {
            this.logger.error((Object)("Exception while calling indexDocument :" + ex.getMessage()));
            ex.printStackTrace();
        }
        return indexResponse.getStatusLine().getStatusCode();
    }

    public int indexDocument(String str, String url) {
        this.logger.debug((Object)("indexing data for url" + url));
        Response indexResponse = null;
        NStringEntity entity = new NStringEntity(str, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", url);
            request.setEntity((HttpEntity)entity);
            indexResponse = this.restClient.performRequest(request);
        }
        catch (ResponseException ex) {
            this.logger.error((Object)("Response exception occurred while calling indexDocument : for url " + url + " with document " + str), (Throwable)ex);
            return 500;
        }
        catch (IOException ex) {
            if (this.retryCount < 3) {
                this.logger.error((Object)("Exception occurred while calling indexDocument : for url " + url + " with document " + str), (Throwable)ex);
                ++this.retryCount;
            } else {
                Configuration.INSTANCE.setEsHealthy(false);
            }
            return 500;
        }
        catch (Throwable ex) {
            if (this.retryCount < 3) {
                this.logger.error((Object)("Exception occurred while calling indexDocument : for url " + url + " with document " + str), ex);
                ++this.retryCount;
            } else {
                Configuration.INSTANCE.setEsHealthy(false);
            }
            return 500;
        }
        if (!Configuration.INSTANCE.isEsHealthy()) {
            this.retryCount = 0;
            Configuration.INSTANCE.setEsHealthy(true);
            TaskScheduler.INSTANCE.updateStaticMetrics();
        }
        return indexResponse.getStatusLine().getStatusCode();
    }

    public boolean isESUrlChanged(String host, int port) {
        if (!Configuration.INSTANCE.isSettingsLoaded()) {
            return true;
        }
        String existingESHost = INSTANCE.getElasticSearchHost();
        int existingESPort = INSTANCE.getElasticSearchPort();
        if (existingESHost == null || existingESPort == 0) {
            return false;
        }
        if (existingESHost == host && existingESPort == port) {
            return false;
        }
        return false;
    }

    public void call(String json, String type, String api) {
        try {
            Request request = new Request("POST", type + "/" + api);
            NStringEntity entity = new NStringEntity(json, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)entity);
            request.addParameters(Collections.emptyMap());
            this.restClient.performRequest(request);
        }
        catch (Exception e) {
            this.logger.error((Object)("Fatal transport error: " + e.getMessage()));
            this.logger.debug((Object)("Detailed error: " + e.getStackTrace()));
        }
    }

    public void update(String json, String index, String id) {
        UpdateRequest request = new UpdateRequest(index, id);
        request.doc(json, XContentType.JSON);
        request.retryOnConflict(3);
        this.sendMetric(request);
    }

    public void update(Map<String, Object> jsonMap, String index, String id) {
        UpdateRequest request = new UpdateRequest(index, id).doc(jsonMap);
        request.retryOnConflict(3);
        this.sendMetric(request);
    }

    public void update(String index, String id, String script, Map<String, Object> param) {
        UpdateRequest request = new UpdateRequest(index, id);
        Script script1 = new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", script, param);
        request.script(script1);
        request.retryOnConflict(3);
        this.sendMetric(request);
    }

    public void upsert(String json, String index, String id) {
        UpdateRequest request = new UpdateRequest(index, id);
        request.doc(json, XContentType.JSON);
        request.docAsUpsert(true);
        request.retryOnConflict(3);
        this.sendMetric(request);
    }

    public boolean isDataSourceUp() {
        if (!this.isInitialized) {
            return false;
        }
        return this.indexExists("/");
    }

    public void deleteDocument(String index, String id) {
        this.logger.debug((Object)("deleting document" + index));
        try {
            if (this.documentExists("/" + index + "/_doc/" + id + "/")) {
                Request request = new Request("DELETE", "/" + index + "/_doc/" + id + "/");
                request.addParameters(Collections.emptyMap());
                this.getRestClient().performRequest(request);
            }
        }
        catch (IOException ex) {
            this.logger.debug((Object)"Exception while deleting heartbeat document for custom instance name in horizontal cluster :", (Throwable)ex);
        }
    }

    static {
        dump_to_es = true;
        dump_to_lmax = true;
    }

    private class WorkHandlerImpl
    implements WorkHandler<RingBufferESRequestEvent> {
        private WorkHandlerImpl() {
        }

        public void onEvent(RingBufferESRequestEvent event) throws Exception {
            if (event.getRequestData() != null) {
                event.converReqestDataToIndexRequest();
            }
            if (dump_to_es) {
                ElasticSearchClient.this.bulkProcessor.add(event.getRequest());
            }
        }
    }
}

