/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBinUpdateRequestCodec {
    private boolean readStringAsCharSeq = false;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicBoolean WARNED_ABOUT_INDEX_TIME_BOOSTS = new AtomicBoolean();

    public JavaBinUpdateRequestCodec setReadStringAsCharSeq(boolean flag) {
        this.readStringAsCharSeq = flag;
        return this;
    }

    public void marshal(UpdateRequest updateRequest, OutputStream os) throws IOException {
        NamedList<Object> nl = new NamedList<Object>();
        NamedList<Object> params = this.solrParamsToNamedList(updateRequest.getParams());
        if (updateRequest.getCommitWithin() != -1) {
            params.add("commitWithin", updateRequest.getCommitWithin());
        }
        Iterator<SolrInputDocument> docIter = null;
        if (updateRequest.getDocIterator() != null) {
            docIter = updateRequest.getDocIterator();
        }
        Map<SolrInputDocument, Map<String, Object>> docMap = updateRequest.getDocumentsMap();
        nl.add("params", params);
        if (updateRequest.getDeleteByIdMap() != null) {
            nl.add("delByIdMap", updateRequest.getDeleteByIdMap());
        }
        nl.add("delByQ", updateRequest.getDeleteQuery());
        if (docMap != null) {
            nl.add("docsMap", docMap.entrySet().iterator());
        } else {
            if (updateRequest.getDocuments() != null) {
                docIter = updateRequest.getDocuments().iterator();
            }
            nl.add("docs", docIter);
        }
        try (JavaBinCodec codec = new JavaBinCodec();){
            codec.marshal(nl, os);
        }
    }

    public UpdateRequest unmarshal(InputStream is, StreamingUpdateHandler handler) throws IOException {
        NamedList params;
        UpdateRequest updateRequest = new UpdateRequest();
        NamedList[] namedList = new NamedList[1];
        try (StreamingCodec codec = new StreamingCodec(namedList, updateRequest, handler);){
            codec.unmarshal(is);
        }
        if (updateRequest.getParams() == null && (params = (NamedList)namedList[0].get("params")) != null) {
            updateRequest.setParams(new ModifiableSolrParams(params.toSolrParams()));
        }
        List delById = (List)namedList[0].get("delById");
        Map delByIdMap = (Map)namedList[0].get("delByIdMap");
        List delByQ = (List)namedList[0].get("delByQ");
        List doclist = (List)namedList[0].get("docs");
        Object docsMapObj = namedList[0].get("docsMap");
        ArrayList docMap = docsMapObj instanceof Map ? new ArrayList(((Map)docsMapObj).entrySet()) : (ArrayList)docsMapObj;
        if (delById != null) {
            for (String string : delById) {
                updateRequest.deleteById(string);
            }
        }
        if (delByIdMap != null) {
            for (Map.Entry entry : delByIdMap.entrySet()) {
                Map params2 = (Map)entry.getValue();
                if (params2 != null) {
                    Long version = (Long)params2.get("ver");
                    if (params2.containsKey("_route_")) {
                        updateRequest.deleteById((String)entry.getKey(), (String)params2.get("_route_"), version);
                        continue;
                    }
                    updateRequest.deleteById((String)entry.getKey(), version);
                    continue;
                }
                updateRequest.deleteById((String)entry.getKey());
            }
        }
        if (delByQ != null) {
            for (String string : delByQ) {
                updateRequest.deleteByQuery(string);
            }
        }
        return updateRequest;
    }

    private NamedList<Object> solrParamsToNamedList(SolrParams params) {
        if (params == null) {
            return new NamedList<Object>();
        }
        return params.toNamedList();
    }

    class StreamingCodec
    extends JavaBinCodec {
        private final NamedList<?>[] namedList;
        private final UpdateRequest updateRequest;
        private final StreamingUpdateHandler handler;
        private boolean seenOuterMostDocIterator;

        public StreamingCodec(NamedList<?>[] namedList, UpdateRequest updateRequest, StreamingUpdateHandler handler) {
            this.namedList = namedList;
            this.updateRequest = updateRequest;
            this.handler = handler;
            this.seenOuterMostDocIterator = false;
        }

        @Override
        protected SolrInputDocument createSolrInputDocument(int sz) {
            return new MaskCharSequenceSolrInputDoc(CollectionUtil.newLinkedHashMap(sz));
        }

        @Override
        public NamedList<Object> readNamedList(DataInputInputStream dis) throws IOException {
            int sz = this.readSize(dis);
            NamedList<Object> nl = new NamedList<Object>();
            if (this.namedList[0] == null) {
                this.namedList[0] = nl;
            }
            for (int i = 0; i < sz; ++i) {
                String name = (String)this.readVal(dis);
                Object val = this.readVal(dis);
                nl.add(name, val);
            }
            return nl;
        }

        private SolrInputDocument listToSolrInputDocument(List<NamedList<?>> namedList) {
            SolrInputDocument doc = new SolrInputDocument();
            for (int i = 0; i < namedList.size(); ++i) {
                String message;
                Float boost;
                NamedList<?> nl = namedList.get(i);
                if (i == 0) {
                    boost = (Float)nl.getVal(0);
                    if (boost == null || boost.floatValue() == 1.0f) continue;
                    message = "Ignoring document boost: " + boost + " as index-time boosts are not supported anymore";
                    if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                        log.warn(message);
                        continue;
                    }
                    log.debug(message);
                    continue;
                }
                boost = (Float)nl.getVal(2);
                if (boost != null && boost.floatValue() != 1.0f) {
                    message = "Ignoring field boost: " + boost + " as index-time boosts are not supported anymore";
                    if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                        log.warn(message);
                    } else {
                        log.debug(message);
                    }
                }
                doc.addField((String)nl.getVal(0), nl.getVal(1));
            }
            return doc;
        }

        @Override
        public List<Object> readIterator(DataInputInputStream fis) throws IOException {
            if (this.seenOuterMostDocIterator) {
                return super.readIterator(fis);
            }
            this.seenOuterMostDocIterator = true;
            return this.readOuterMostDocIterator(fis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Object> readOuterMostDocIterator(DataInputInputStream fis) throws IOException {
            NamedList params;
            if (this.namedList[0] == null) {
                this.namedList[0] = new NamedList();
            }
            if ((params = (NamedList)this.namedList[0].get("params")) == null) {
                params = new NamedList();
            }
            this.updateRequest.setParams(new ModifiableSolrParams(params.toSolrParams()));
            if (this.handler == null) {
                return super.readIterator(fis);
            }
            Integer commitWithin = null;
            Boolean overwrite = null;
            Object o = null;
            this.readStringAsCharSeq = JavaBinUpdateRequestCodec.this.readStringAsCharSeq;
            try {
                while (true) {
                    if (o == null) {
                        o = this.readVal(fis);
                    }
                    if (o == END_OBJ) break;
                    SolrInputDocument sdoc = null;
                    if (o instanceof List) {
                        List list = (List)o;
                        sdoc = this.listToSolrInputDocument(list);
                    } else if (o instanceof NamedList) {
                        UpdateRequest req = new UpdateRequest();
                        req.setParams(new ModifiableSolrParams(((NamedList)o).toSolrParams()));
                        this.handler.update(null, req, null, null);
                    } else if (o instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)o;
                        sdoc = (SolrInputDocument)entry.getKey();
                        Map p = (Map)entry.getValue();
                        if (p != null) {
                            commitWithin = (Integer)p.get("cw");
                            overwrite = (Boolean)p.get("ow");
                        }
                    } else if (o instanceof SolrInputDocument) {
                        sdoc = (SolrInputDocument)o;
                    } else if (o instanceof Map) {
                        sdoc = this.convertMapToSolrInputDoc((Map)o);
                    }
                    o = this.readVal(fis);
                    if (o == END_OBJ) {
                        this.updateRequest.lastDocInBatch();
                    }
                    this.handler.update(sdoc, this.updateRequest, commitWithin, overwrite);
                }
                List<Object> list = Collections.emptyList();
                return list;
            }
            finally {
                this.readStringAsCharSeq = false;
            }
        }

        private SolrInputDocument convertMapToSolrInputDoc(Map<?, ?> m) {
            SolrInputDocument result = this.createSolrInputDocument(m.size());
            m.forEach((k, v) -> {
                if ("_childDocuments_".equals(k.toString())) {
                    if (v instanceof List) {
                        List list = (List)v;
                        for (Object o : list) {
                            if (!(o instanceof Map)) continue;
                            result.addChildDocument(this.convertMapToSolrInputDoc((Map)o));
                        }
                    } else if (v instanceof Map) {
                        result.addChildDocument(this.convertMapToSolrInputDoc((Map)v));
                    }
                } else {
                    result.addField(k.toString(), v);
                }
            });
            return result;
        }
    }

    public static interface StreamingUpdateHandler {
        public void update(SolrInputDocument var1, UpdateRequest var2, Integer var3, Boolean var4);
    }

    static class MaskCharSequenceSolrInputDoc
    extends SolrInputDocument {
        public MaskCharSequenceSolrInputDoc(Map<String, SolrInputField> fields) {
            super(fields);
        }

        @Override
        public Object getFieldValue(String name) {
            return ByteArrayUtf8CharSequence.convertCharSeq(super.getFieldValue(name));
        }
    }
}

