/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.search.exceptions;

import coldfusion.pdf.core.PDFDocException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.SearchEngineException;

public class SearchExceptions {

    public static class UnableToCreateCollectionException
    extends SearchEngineException {
        public String collection;
        public String error;

        public UnableToCreateCollectionException(String collection, Throwable ex) {
            this.collection = collection;
            this.error = ex.toString();
        }
    }

    public static class UnableToCreateSolrCollectionException
    extends SearchEngineException {
        public String collection;
        public String error;

        public UnableToCreateSolrCollectionException(String collection, Throwable ex) {
            this.collection = collection;
            this.error = ex.toString().split(":")[0];
        }
    }

    public static class SolrCollectionExistsException
    extends SearchEngineException {
        public String collection;

        public SolrCollectionExistsException(String collection) {
            this.collection = collection;
        }
    }

    public static class CollectionExistsException
    extends SearchEngineException {
        public String collection;

        public CollectionExistsException(String collection) {
            this.collection = collection;
        }
    }

    public static class IndexingFailedException
    extends SearchEngineException {
        public String file;
        public Exception e;

        public IndexingFailedException(String file, Exception e) {
            this.file = file;
            this.e = e;
        }
    }

    public static class InvalidFieldBoostException
    extends SearchEngineException {
        public String boost;

        public InvalidFieldBoostException(String boost) {
            this.boost = boost;
        }
    }

    public static class UnableToCreateAliasException
    extends SearchEngineException {
        public String corename;
        public String newname;
        public String error;

        public UnableToCreateAliasException(String corename, String newname, Throwable ex) {
            this.corename = corename;
            this.newname = newname;
            this.error = ex.toString();
        }
    }

    public static class UnableToRenameCoreException
    extends SearchEngineException {
        public String corename;
        public String newname;
        public String error;

        public UnableToRenameCoreException(String corename, String newname, Throwable ex) {
            this.corename = corename;
            this.newname = newname;
            this.error = ex.toString();
        }
    }

    public static class UnableToMergeCollectionsException
    extends SearchEngineException {
        public String corename;
        public String error;

        public UnableToMergeCollectionsException(String corename, Throwable ex) {
            this.corename = corename;
            this.error = ex.toString();
        }
    }

    public static class UnableToReloadCoreException
    extends SearchEngineException {
        public String corename;
        public String error;

        public UnableToReloadCoreException(String corename, Throwable ex) {
            this.corename = corename;
            this.error = ex.toString();
        }
    }

    public static class UnableToDeleteCoreException
    extends SearchEngineException {
        public String corename;
        public String error;

        public UnableToDeleteCoreException(String corename, Throwable ex) {
            this.corename = corename;
            this.error = ex.toString();
        }
    }

    public static class UnableToUnloadCoreException
    extends SearchEngineException {
        public String corename;
        public String error;

        public UnableToUnloadCoreException(String core, Throwable ex) {
            this.corename = core;
            this.error = ex.toString();
        }
    }

    public static class InvalidFileException
    extends SearchEngineException {
        public String file;

        public InvalidFileException(String file) {
            this.file = file;
        }
    }

    public static class InvalidSortFieldException
    extends SearchEngineException {
        public String fieldname;

        public InvalidSortFieldException(String fieldname) {
            this.fieldname = fieldname;
        }
    }

    public static class UnableToConnectToSolrException
    extends SearchEngineException {
    }

    public static class InvalidParserException
    extends SearchEngineException {
        public String type;

        public InvalidParserException(String type) {
            this.type = type;
        }
    }

    public static class BadQueryStringException
    extends SearchEngineException {
        public String criteria;

        public BadQueryStringException(String query) {
            this.criteria = query;
        }
    }

    public static class BadSuggestionException
    extends SearchEngineException {
        public String arg;

        public BadSuggestionException(String arg) {
            this.arg = arg;
        }
    }

    public static class CharsetMismatchException
    extends SearchEngineException {
        public String collectionName;
        public String collectionCharmap;
        public String searchCharmap;

        public CharsetMismatchException(String collectionName, String collectionCharmap, String searchCharmap) {
            this.collectionName = collectionName;
            this.collectionCharmap = collectionCharmap;
            this.searchCharmap = searchCharmap;
        }
    }

    public static class SearchAuthenticationException
    extends SearchEngineException {
        public String mesg;

        public SearchAuthenticationException(String msg) {
            this.mesg = msg;
        }
    }

    public static class SearchProblemException
    extends SearchEngineException {
        public String mesg;

        public SearchProblemException(String m) {
            this.mesg = m;
        }
    }

    public static class InvalidCustomFieldException
    extends SearchEngineException {
        public String name;

        public InvalidCustomFieldException(String name) {
            this.name = name;
        }
    }

    public static class LanguageMismatchException
    extends SearchEngineException {
        public String collectionName;
        public String language;
        public String engine;

        public LanguageMismatchException(String collectionName, String language, String engine) {
            this.collectionName = collectionName;
            this.language = language;
            this.engine = engine;
        }
    }

    public static class VariableIsNotQueryException
    extends SearchEngineException {
        public String name;

        public VariableIsNotQueryException(String name) {
            this.name = name;
        }
    }

    public static class SolrNotRunningException
    extends SearchEngineException {
        public String url;

        public SolrNotRunningException(String url) {
            this.url = url;
        }
    }

    public static class IndexDataMissingException
    extends SearchEngineException {
        public String name;

        public IndexDataMissingException(String name) {
            this.name = name;
        }
    }

    public static class StatusNotAllowedException
    extends SearchEngineException {
    }

    public static class DIHIndexingException
    extends SearchEngineException {
        public DIHIndexingException(Exception e) {
            super((Throwable)e);
        }
    }

    public static class RemoteSolrPathNotAllowedException
    extends SearchEngineException {
    }

    public static class MissingCustomAttributeException
    extends SearchEngineException {
        public String attr;

        public MissingCustomAttributeException(String s) {
            this.attr = s;
        }
    }

    public static class IndexErrorException
    extends SearchEngineException {
        public String errors;

        public IndexErrorException(String errors) {
            this.errors = errors;
        }
    }

    public static class KeyIsNotDirectoryException
    extends SearchEngineException {
        public String path;

        public KeyIsNotDirectoryException(String path) {
            this.path = path;
        }
    }

    public static class CannotFindSomethingException
    extends SearchEngineException {
        public String label;
        public String value;
        public String engine;

        public CannotFindSomethingException(String engine, String label, String value) {
            this.engine = engine;
            this.label = label;
            this.value = value;
        }
    }

    public static class IndexInvalidAttributevalueException
    extends SearchEngineException {
        public IndexInvalidAttributevalueException(Throwable e) {
        }
    }

    public static class IndexInvalidAttributeException
    extends SearchEngineException {
        public IndexInvalidAttributeException(Throwable e) {
        }
    }

    public static class DIHStatusException
    extends SearchEngineException {
    }

    public static class IndexProblemException
    extends SearchEngineException {
        public IndexProblemException(Throwable e) {
            super(e);
        }
    }

    public static class CategoriesNotEnabledException
    extends SearchEngineException {
        public String name;
        public String error;

        public CategoriesNotEnabledException(String name, String error) {
            this.name = name;
            this.error = error;
        }
    }

    public static class BadCollectionDirectoryException
    extends SearchEngineException {
        public String directory;

        public BadCollectionDirectoryException(String directory) {
            this.directory = directory;
        }
    }

    public static class InvalidCollectionException
    extends SearchEngineException {
        public String collection;

        public InvalidCollectionException(String collection) {
            this.collection = collection;
        }
    }

    public static class AttributeRequiredException
    extends SearchEngineException {
        public String attribute;
        public String action;

        public AttributeRequiredException(String attribute, String action) {
            this.attribute = attribute;
            this.action = action;
        }
    }

    public static class SolrMigrationException
    extends ApplicationException {
    }

    public static class InvalidJettyPathException
    extends ApplicationException {
        public String file;

        public InvalidJettyPathException(String file) {
            this.file = file;
        }
    }

    public static class InvalidOldMulticorePathException
    extends ApplicationException {
        public String file;

        public InvalidOldMulticorePathException(String file) {
            this.file = file;
        }
    }

    public static class SolrSearchServiceUnavailableException
    extends SearchEngineException {
        public String errormsg;

        public SolrSearchServiceUnavailableException(Exception e) {
            this.errormsg = e.getMessage();
        }

        public SolrSearchServiceUnavailableException(String msg) {
            this.errormsg = msg;
        }
    }

    public static class SearchServiceUnavailableException
    extends SearchEngineException {
        public String errormsg;

        public SearchServiceUnavailableException(Exception e) {
            this.errormsg = e.getMessage();
        }

        public SearchServiceUnavailableException(String msg) {
            this.errormsg = msg;
        }
    }

    public static class SearchEngineLibraryException
    extends SearchEngineException {
        public String exception;

        public SearchEngineLibraryException(Exception exception) {
            this.exception = exception.toString();
        }

        public SearchEngineLibraryException(String msg, Exception exception) {
            this.exception = msg + ": " + exception.toString();
        }
    }

    public static class CollectionDoesNotExistException
    extends SearchEngineException {
        public String name;

        public CollectionDoesNotExistException(String name) {
            this.name = name;
        }
    }

    public static class SolrNotRunning
    extends PDFDocException {
        public String url = null;

        public SolrNotRunning(String url) {
            this.url = url;
        }
    }
}

