/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.log.CFLogs;
import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import coldfusion.util.RB;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.InetSocketAddress;

public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (!(frame instanceof TextWebSocketFrame)) {
            String msg = RB.getString(WebSocketFrameHandler.class, (String)"UNSUPPORTED_FRAMETYPE", (Object)frame.getClass().getName());
            CFLogs.WEBSOCKET_LOG.info((Object)msg);
            throw new UnsupportedOperationException(msg);
        }
        CFLogs.WEBSOCKET_LOG.info((Object)RB.getString(WebSocketFrameHandler.class, (String)"WEBSOCKET_FRAME_RECEIVED"));
        WSTaskProcessor.getTaskProcessor().processWebSocketRequest(ClientConnectionManager.getClientConnection(this.getClientConnectionId(ctx)), ((TextWebSocketFrame)frame).text());
    }

    private String getClientConnectionId(ChannelHandlerContext ctx) {
        InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
        Object connectionId = address.getHostName() + address.getPort();
        if (((String)(connectionId = "" + ((String)connectionId).hashCode())).charAt(0) == '-') {
            connectionId = ((String)connectionId).substring(1);
        }
        return connectionId;
    }
}

