/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.BlobInfoConsumer;
import coldfusion.gcp.storage.consumer.StorageBlobSourceOptionConsumer;
import coldfusion.gcp.storage.request.DownloadObjectBuilder;
import coldfusion.gcp.storage.request.StorageBlobSourceOptionBuilder;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DownloadObjectConsumer
extends ConsumerMap<DownloadObjectBuilder> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static DownloadObjectConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadObjectConsumer getInstance() {
        if (instance != null) return instance;
        Class<DownloadObjectConsumer> clazz = DownloadObjectConsumer.class;
        synchronized (DownloadObjectConsumer.class) {
            if (instance != null) return instance;
            instance = new DownloadObjectConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DownloadObjectConsumer() {
        this.put("blobInfo", new ConsumerValidator((downloadObjectBuilder, value) -> {
            Map blobInfoReq = this.cast.getMapProperty(value);
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)"", (String)"");
            ValidatorFiller.INSTANCE.fillObject((Object)builder, blobInfoReq, (ConsumerMap)BlobInfoConsumer.getInstance());
            BlobInfo blobInfo = builder.build();
            downloadObjectBuilder.setBlobInfo(blobInfo);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blobSourceOption", new ConsumerValidator((downloadObjectBuilder, value) -> {
            List obj = this.cast.getListProperty(value);
            ArrayList<Storage.BlobSourceOption> list = new ArrayList<Storage.BlobSourceOption>();
            for (int i = 0; i < obj.size(); ++i) {
                Map storageBlobsourceOpt = this.cast.getStringObjectMapProperty(obj.get(i));
                StorageBlobSourceOptionBuilder blobSourceOptionBuilder = new StorageBlobSourceOptionBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)blobSourceOptionBuilder, storageBlobsourceOpt, (ConsumerMap)StorageBlobSourceOptionConsumer.getInstance());
                list.addAll(blobSourceOptionBuilder.getBlobSourceOptions());
            }
            downloadObjectBuilder.setBlobSourceOptionList(list);
        }, Collections.singletonList(new EmptyListValidator("blobSourceOption"))));
    }
}

