/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.request.BlobSourceOptionBuilder;
import coldfusion.gcp.storage.util.Validator;
import java.util.Collections;

public class BlobSourceOptionConsumer
extends ConsumerMap<BlobSourceOptionBuilder> {
    private static final long serialVersionUID = 1L;
    private static BlobSourceOptionConsumer instance;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlobSourceOptionConsumer getInstance() {
        if (instance != null) return instance;
        Class<BlobSourceOptionConsumer> clazz = BlobSourceOptionConsumer.class;
        synchronized (BlobSourceOptionConsumer.class) {
            instance = new BlobSourceOptionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BlobSourceOptionConsumer() {
        this.put("key", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            String blobName = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonEmptyString((String)blobName, (String)"key");
            blobSourceOptionBuilder.setBlobName(blobName);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("destinationFilePath", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            String destFilePath = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonEmptyString((String)destFilePath, (String)"destinationFilePath");
            blobSourceOptionBuilder.setDestinationFilePath(destFilePath);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("decryptionKey", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            String decryptionKey = this.cast.getStringProperty(value).trim();
            blobSourceOptionBuilder.setDecryptionKey(decryptionKey);
        }, Collections.emptyList()));
        this.put("shouldReturnRawInputStream", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            boolean shouldReturnRawInputStream = Validator.getBooleanProperty(value, "shouldReturnRawInputStream");
            blobSourceOptionBuilder.setShouldReturnRawInputStream(shouldReturnRawInputStream);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            String userProject = this.cast.getStringProperty(value).trim();
            blobSourceOptionBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
    }
}

