/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.cfnotification;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.storage.consumer.NotificationInfoConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.pmt.util.GCPStorageApis;
import coldfusion.gcp.storage.pmt.util.PMTUtilForGCPStorage;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Struct;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageNotification {
    private static TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.STORAGE.name());

    public static Struct createNotification(Storage storageClient, String bucketName, Map NotificationAttr) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.createNotification, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            NotificationInfo.Builder builder = NotificationInfo.newBuilder((String)"projects/projectName/topics/topicName");
            ValidatorFiller.INSTANCE.fillObject((Object)builder, NotificationAttr, (ConsumerMap)NotificationInfoConsumer.getInstance());
            NotificationInfo val = builder.build();
            Notification notification = storageClient.createNotification(bucketName, val);
            response.put((Object)"notification", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)notification));
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilForGCPStorage.getMonitoringResponseMap("post", status);
                rmdMap.put("bucket", bucketName);
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.createNotification, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    public static Struct getNotification(Storage storageClient, String bucketName, String notificationId) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getNotification, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            Notification notification = storageClient.getNotification(bucketName, notificationId);
            response.put((Object)"notification", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)notification));
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilForGCPStorage.getMonitoringResponseMap("get", status);
                rmdMap.put("bucket", bucketName);
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getNotification, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    public static Struct listNotifications(Storage storageClient, String bucketName) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.listNotifications, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            List notifications = storageClient.listNotifications(bucketName);
            ArrayList<Struct> notification = new ArrayList<Struct>();
            for (int i = 0; i < notifications.size(); ++i) {
                notification.add(CloudDeserializationUtil.INSTANCE.beanToStructUsingGson(notifications.get(i)));
            }
            response.put((Object)"notification", notification);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilForGCPStorage.getMonitoringResponseMap("get", status);
                rmdMap.put("bucket", bucketName);
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.listNotifications, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    public static Struct deleteNotification(Storage storageClient, String bucketName, String notificationId) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.deleteNotification, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            boolean success = storageClient.deleteNotification(bucketName, notificationId);
            if (success) {
                response.put((Object)"status", (Object)"Success");
                response.put((Object)"message", (Object)"Successfully deleted notification");
            } else {
                response.put((Object)"status", (Object)"Failure");
                response.put((Object)"message", (Object)"Failed to find notification");
            }
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status);
                rmdMap.put("bucket", bucketName);
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.deleteNotification, tempAttributeList, rmdMap);
            }
        }
        return response;
    }
}

