/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus;

import coldfusion.cloud.azure.servicebus.ServiceBusAPIException;
import coldfusion.cloud.azure.servicebus.ServiceBusClient;
import coldfusion.cloud.azure.servicebus.ServiceBusClientImpl;
import coldfusion.cloud.azure.servicebus.ServiceBusSubscription;
import coldfusion.cloud.azure.servicebus.ServiceBusTopic;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.log.Logger;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import com.microsoft.azure.servicebus.management.TopicDescription;
import jakarta.servlet.jsp.PageContext;
import java.util.List;
import java.util.Map;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class ServiceBusTopicImpl
implements ServiceBusTopic,
NamedInvokable {
    private TopicDescription topicDescription;
    private ServiceBusClient serviceBusClient;
    private String path;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.servicebus");
    private static InvokeNamedMethodInvocationMap<ServiceBusTopicImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public ServiceBusTopicImpl(ServiceBusClientImpl client, TopicDescription description) {
        this.topicDescription = description;
        this.serviceBusClient = client;
        this.path = description.getPath();
    }

    @Override
    public Struct sendMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.sendMessage(this.path, message, "topic");
    }

    @Override
    public Struct scheduleMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.scheduleMessage(this.path, message, "topic");
    }

    @Override
    public Struct sendMessageBatch(List<Map> messages) throws ServiceBusAPIException {
        return this.serviceBusClient.sendMessageBatch(this.path, messages, "topic");
    }

    @Override
    public Struct cancelScheduledMessage(long sequenceNumber) throws ServiceBusAPIException {
        return this.serviceBusClient.cancelScheduledMessage(this.path, sequenceNumber, "topic");
    }

    @Override
    public Struct getRuntimeInfo() throws ServiceBusAPIException {
        return this.serviceBusClient.getTopicRuntimeInfo(this.path);
    }

    public ServiceBusClient getServiceBusClient() {
        return this.serviceBusClient;
    }

    public void setServiceBusClient(ServiceBusClient serviceBusClient) {
        this.serviceBusClient = serviceBusClient;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Struct unsubscribe(String subscriptionName) throws ServiceBusAPIException {
        return this.serviceBusClient.unsubscribe(this.path, subscriptionName);
    }

    @Override
    public Struct listSubscriptions() throws ServiceBusAPIException {
        return this.serviceBusClient.listSubscriptions(this.path);
    }

    @Override
    public ServiceBusSubscription subscribe(Object subscription) throws ServiceBusAPIException {
        if (subscription instanceof String) {
            return this.subscribe(Cast._String((Object)subscription), null, null);
        }
        if (subscription instanceof Map) {
            return this.subscribe(Cast._Map((Object)subscription), null);
        }
        throw new IllegalArgumentException(RB.getString(ServiceBusTopicImpl.class, (String)"SubscribeTopicIllegalArgError"));
    }

    @Override
    public ServiceBusSubscription getSubscription(String subscriptionName) {
        return this.serviceBusClient.getSubscription(this.path, subscriptionName);
    }

    @Override
    public Struct getDescription() {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)this.topicDescription);
    }

    @Override
    public String generateSasToken(Map sasRule) throws ServiceBusAPIException {
        return this.serviceBusClient.generateSasToken(this.path, "topic", sasRule);
    }

    public ServiceBusSubscription subscribe(String subscriptionName, Object dummyParam, Object dummyParam2) throws ServiceBusAPIException {
        return this.serviceBusClient.subscribe(this.path, subscriptionName);
    }

    public ServiceBusSubscription subscribe(Map metadata, Object dummyParam) {
        return this.serviceBusClient.subscribe(this.path, metadata);
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("servicebus service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("servicebus service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.sendMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"scheduleMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.scheduleMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("scheduleMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messages"}, args);
                    return obj.sendMessageBatch(Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cancelScheduledMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sequenceNumber"}, args);
                    return obj.cancelScheduledMessage(Cast._long((Object)argColl.get((Object)"sequenceNumber"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cancelScheduledMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRuntimeInfo", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRuntimeInfo();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRuntimeInfo", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getServiceBusClient", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getServiceBusClient();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getServiceBusClient", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setServiceBusClient", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"serviceBusClient"}, args);
                    obj.setServiceBusClient((ServiceBusClient)Cast._castForInvokeGen((Object)argColl.get((Object)"serviceBusClient"), ServiceBusClient.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setServiceBusClient", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPath", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPath();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPath", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"unsubscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscriptionName"}, args);
                    return obj.unsubscribe(Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("unsubscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listSubscriptions", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listSubscriptions();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listSubscriptions", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"subscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscription"}, args);
                    return obj.subscribe(argColl.get((Object)"subscription"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscriptionName", "dummyParam", "dummyParam2"}, args);
                    return obj.subscribe(Cast._String((Object)argColl.get((Object)"subscriptionName")), argColl.get((Object)"dummyParam"), argColl.get((Object)"dummyParam2"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"metadata", "dummyParam"}, args);
                    return obj.subscribe(Cast._Map((Object)argColl.get((Object)"metadata")), argColl.get((Object)"dummyParam"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("subscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscription", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"subscriptionName"}, args);
                    return obj.getSubscription(Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDescription", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDescription();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDescription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generateSasToken", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sasRule"}, args);
                    return obj.generateSasToken(Cast._Map((Object)argColl.get((Object)"sasRule")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generateSasToken", obj);
        });
    }
}

