/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import jakarta.xml.bind.annotation.XmlEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlEnumUtils {
    private static final Log log = LogFactory.getLog(XmlEnumUtils.class);

    private XmlEnumUtils() {
    }

    public static Class getConversionType(final Class e) {
        Class cls = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getConversionType for " + e));
        }
        try {
            cls = (Class)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    XmlEnum xmlEnum;
                    Method m = XmlEnumUtils.fromValueMethod(e, String.class);
                    if (m != null) {
                        return String.class;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"try looking for @XmlEnum ");
                    }
                    if ((xmlEnum = e.getAnnotation(XmlEnum.class)) != null) {
                        Class argClass = xmlEnum.value();
                        m = XmlEnumUtils.fromValueMethod(e, argClass);
                        if (m != null) {
                            return argClass;
                        }
                        Class primitiveClass = XmlEnumUtils.getPrimitiveClass(argClass);
                        if (primitiveClass != null && (m = XmlEnumUtils.fromValueMethod(e, primitiveClass)) != null) {
                            return argClass;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"try looking for valueOf method ");
                    }
                    if ((m = XmlEnumUtils.valueOfMethod(e)) != null) {
                        return String.class;
                    }
                    throw ExceptionFactory.makeWebServiceException((Throwable)new IllegalArgumentException());
                }
            });
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getConversionType is" + cls));
            }
        }
        return cls;
    }

    public static Object fromValue(final Class e, final Object convObject) {
        Object enumValue = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("fromValue for " + JavaUtils.getObjectIdentity((Object)convObject)));
        }
        try {
            enumValue = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws InvocationTargetException, IllegalAccessException {
                    Method m = XmlEnumUtils.getConversionMethod(e);
                    return m.invoke(null, convObject);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw ExceptionFactory.makeWebServiceException((Throwable)pae.getException());
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getEnumValue is" + JavaUtils.getObjectIdentity((Object)enumValue)));
            }
        }
        return enumValue;
    }

    private static Method getConversionMethod(Class cls) {
        XmlEnum xmlEnum;
        Method m = XmlEnumUtils.fromValueMethod(cls, String.class);
        if (m != null) {
            return m;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"try looking for @XmlEnum ");
        }
        if ((xmlEnum = cls.getAnnotation(XmlEnum.class)) != null) {
            Class argClass = xmlEnum.value();
            m = XmlEnumUtils.fromValueMethod(cls, argClass);
            if (m != null) {
                return m;
            }
            Class primitiveClass = XmlEnumUtils.getPrimitiveClass(argClass);
            if (primitiveClass != null && (m = XmlEnumUtils.fromValueMethod(cls, primitiveClass)) != null) {
                return m;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"try looking for valueOf method ");
        }
        if ((m = XmlEnumUtils.valueOfMethod(cls)) != null) {
            return m;
        }
        throw new IllegalArgumentException();
    }

    private static Method fromValueMethod(Class cls, Class argClass) {
        try {
            return cls.getMethod("fromValue", argClass);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method valueOfMethod(Class cls) {
        try {
            return cls.getMethod("valueOf", String.class);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Class getPrimitiveClass(Class cls) {
        if (Integer.class.equals((Object)cls)) {
            return Integer.TYPE;
        }
        if (Short.class.equals((Object)cls)) {
            return Short.TYPE;
        }
        if (Boolean.class.equals((Object)cls)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals((Object)cls)) {
            return Byte.TYPE;
        }
        if (Long.class.equals((Object)cls)) {
            return Long.TYPE;
        }
        if (Double.class.equals((Object)cls)) {
            return Double.TYPE;
        }
        if (Float.class.equals((Object)cls)) {
            return Float.TYPE;
        }
        if (Character.class.equals((Object)cls)) {
            return Character.TYPE;
        }
        return null;
    }
}

