/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core.controller.impl;

import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.InvocationController;
import org.apache.axis2.jaxws.core.controller.InvocationPattern;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InvocationControllerImpl
implements InvocationController {
    private static final Log log = LogFactory.getLog(InvocationControllerImpl.class);

    @Override
    public InvocationContext invoke(InvocationContext ic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: synchronous");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        MessageContext request = ic.getRequestMessageContext();
        MessageContext response = null;
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.SYNC);
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.registerUnderstoodHeaders(request, ic.getHandlers());
            this.prepareRequest(request);
            response = this.doInvoke(request);
            this.prepareResponse(response);
            response.setMEPContext(request.getMEPContext());
            response.setEndpointDescription(request.getEndpointDescription());
            TransportHeadersAdapter.install(response);
            AttachmentsAdapter.install(response);
            SOAPHeadersAdapter.install(response);
            HandlerInvokerUtils.invokeInboundHandlers(response.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
        } else {
            response = MessageContextUtils.createMinimalResponseMessageContext(request);
            response.setMEPContext(request.getMEPContext());
            response.setMessage(request.getMessage());
        }
        ic.setResponseMessageContext(response);
        return ic;
    }

    protected abstract MessageContext doInvoke(MessageContext var1);

    @Override
    public void invokeOneWay(InvocationContext ic) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: one-way");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        MessageContext request = ic.getRequestMessageContext();
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ONEWAY);
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, true);
        if (success) {
            this.prepareRequest(request);
            this.doInvokeOneWay(request);
        } else {
            AxisFault e = request.getCausedByException();
            if (e != null) {
                throw (Exception)e.getCause();
            }
        }
    }

    protected abstract void doInvokeOneWay(MessageContext var1);

    @Override
    public Response invokeAsync(InvocationContext ic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: asynchronous(polling)");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        MessageContext request = ic.getRequestMessageContext();
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ASYNC_POLLING);
        Response resp = null;
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, false);
        if (success) {
            this.registerUnderstoodHeaders(request, ic.getHandlers());
            this.prepareRequest(request);
            resp = this.doInvokeAsync(request);
        }
        return resp;
    }

    public abstract Response doInvokeAsync(MessageContext var1);

    @Override
    public Future<?> invokeAsync(InvocationContext ic, AsyncHandler asyncHandler) {
        ExecutorService es;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invocation pattern: asynchronous(callback)");
        }
        if (ic == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr1"));
        }
        if (ic.getRequestMessageContext() == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr2"));
        }
        if (ic.getExecutor() != null && ic.getExecutor() instanceof ExecutorService && (es = (ExecutorService)ic.getExecutor()).isShutdown()) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ExecutorShutdown"));
        }
        MessageContext request = ic.getRequestMessageContext();
        request.setProperty("org.apache.axis2.jaxws.invocation.pattern", (Object)InvocationPattern.ASYNC_CALLBACK);
        Future<?> future = null;
        boolean success = HandlerInvokerUtils.invokeOutboundHandlers(request.getMEPContext(), ic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, false);
        if (!success) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invokeAsyncErr"));
        }
        this.registerUnderstoodHeaders(request, ic.getHandlers());
        this.prepareRequest(request);
        future = this.doInvokeAsync(request, asyncHandler);
        return future;
    }

    public abstract Future<?> doInvokeAsync(MessageContext var1, AsyncHandler var2);

    protected abstract void prepareRequest(MessageContext var1);

    protected abstract void prepareResponse(MessageContext var1);

    private void registerUnderstoodHeaders(MessageContext request, List<Handler> handlerList) {
        if (handlerList != null && handlerList.size() > 0) {
            HashSet understoodHeaders = new HashSet();
            for (Handler handler : handlerList) {
                SOAPHandler soapHandler;
                Set headers;
                if (!(handler instanceof SOAPHandler) || (headers = (soapHandler = (SOAPHandler)handler).getHeaders()) == null || headers.size() <= 0) continue;
                understoodHeaders.addAll(headers);
            }
            if (understoodHeaders != null && understoodHeaders.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding understood header QName collection to message context " + understoodHeaders));
                }
                request.setProperty("client.UnderstoodHeaders", understoodHeaders);
            }
        }
    }
}

