/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import jakarta.xml.bind.JAXBException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.datasource.jaxb.JAXBCustomBuilderMonitor;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;
import org.apache.axis2.jaxws.handler.HandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBCustomBuilder
implements CustomBuilder,
CustomBuilder.Selector {
    private static final Log log = LogFactory.getLog(JAXBCustomBuilder.class);
    JAXBDSContext jdsContext;

    public JAXBCustomBuilder(JAXBDSContext context) {
        this.jdsContext = context;
        JAXBCustomBuilderMonitor.updateTotalBuilders();
    }

    public OMDataSource create(OMElement element) throws OMException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("create namespace = " + element.getNamespaceURI()));
                log.debug((Object)("  localPart = " + element.getLocalName()));
            }
            Object jaxb = this.jdsContext.unmarshal(element);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully unmarshalled jaxb object " + jaxb));
            }
            JAXBDataSource ds = new JAXBDataSource(jaxb, this.jdsContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The JAXBDataSource is " + (Object)((Object)ds)));
            }
            JAXBCustomBuilderMonitor.updateTotalCreates();
            return ds;
        }
        catch (JAXBException e) {
            JAXBCustomBuilderMonitor.updateTotalFailedCreates();
            throw new OMException((Throwable)e);
        }
    }

    public boolean accepts(OMContainer parent, int depth, String namespaceURI, String localName) {
        if (parent instanceof OMDocument || parent instanceof SOAPBody) {
            boolean shouldUnmarshal;
            if (HandlerUtils.isHighFidelity(this.jdsContext.getMessageContext())) {
                log.debug((Object)"JAXB payload streaming disabled because high fidelity messages are requested.");
                shouldUnmarshal = false;
            } else {
                boolean bl = shouldUnmarshal = !localName.equals("EncryptedData");
            }
            if (!shouldUnmarshal) {
                JAXBCustomBuilderMonitor.updateTotalFailedCreates();
            }
            return shouldUnmarshal;
        }
        return false;
    }
}

