/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.places.Activity;
import com.lotus.sametime.places.IncomingMessage;
import com.lotus.sametime.places.MyselfInPlace;
import com.lotus.sametime.places.PlaceEvent;
import com.lotus.sametime.places.PlaceListener;
import com.lotus.sametime.places.PlaceMember;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlaceMemberImpl;
import com.lotus.sametime.places.PlaceMemberListener;
import com.lotus.sametime.places.PlacesComp;
import com.lotus.sametime.places.PlacesConstants;
import com.lotus.sametime.places.PlacesEvent;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.UserInPlace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Place
extends PlaceMemberImpl {
    private String m_placeName;
    private String m_displayName;
    private EncLevel m_requestedEncLevel;
    private EncLevel m_encLevel;
    private int m_placeType;
    private String m_password;
    private short m_publishMode;
    private short m_creationMode;
    private int m_activitiesNum;
    private STServer m_server;
    private Section m_mySection;
    private MyselfInPlace m_myself;
    private Channel m_channel;
    private Vector m_placeListeners = new Vector();
    private Hashtable m_placeMembers = new Hashtable();
    private Hashtable m_subscribedMembers = new Hashtable();
    private Hashtable m_waitingSubscriptions = new Hashtable();
    private Hashtable m_msgTable = new Hashtable();
    private CommunityService m_commService;
    boolean m_inPlace;
    boolean m_toStage;
    boolean m_closed;

    protected Place(STSession sTSession, String string, String string2, EncLevel encLevel, int n, short s) {
        super(sTSession, STCompPart.getUniqueId(), new Integer(0));
        this.m_placeName = string;
        this.m_displayName = string2;
        this.m_requestedEncLevel = encLevel;
        this.m_encLevel = encLevel;
        this.m_placeType = n;
        this.m_publishMode = s;
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlaceListener(PlaceListener placeListener) {
        Place place = this;
        synchronized (place) {
            Vector vector = (Vector)this.m_placeListeners.clone();
            vector.addElement(placeListener);
            this.m_placeListeners = vector;
        }
        if (this.m_inPlace) {
            this.addPlaceMemberListener(placeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlaceListener(PlaceListener placeListener) {
        Place place = this;
        synchronized (place) {
            Vector vector = (Vector)this.m_placeListeners.clone();
            vector.removeElement(placeListener);
            this.m_placeListeners = vector;
        }
        this.removePlaceMemberListener(placeListener);
    }

    public void enter() {
        this.enter("", (short)2, true);
    }

    public void enter(String string, short s, boolean bl) {
        if (this.m_closed || this.m_inPlace) {
            return;
        }
        this.m_creationMode = s;
        this.m_toStage = bl;
        this.m_password = string;
        PlaceEvent placeEvent = new PlaceEvent(this, 1);
        this.sendEvent(placeEvent);
    }

    public void leave(int n) {
        if (!this.m_inPlace) {
            return;
        }
        PlaceEvent placeEvent = new PlaceEvent((Object)this, 2, this.m_placeId, n);
        this.sendEvent(placeEvent);
    }

    public void addActivity(int n, byte[] byArray) {
        PlaceEvent placeEvent = new PlaceEvent((Object)this, 4, this.m_placeId, n, byArray);
        this.sendEvent(placeEvent);
    }

    public void addAllowedUsers(STUser[] sTUserArray) {
        PlaceEvent placeEvent = new PlaceEvent((Object)this, 6, this.m_placeId, sTUserArray);
        this.sendEvent(placeEvent);
    }

    public void removeAllowedUsers(STUser[] sTUserArray) {
        PlaceEvent placeEvent = new PlaceEvent((Object)this, 7, this.m_placeId, sTUserArray);
        this.sendEvent(placeEvent);
    }

    public void invite15User(STUser sTUser, String string, boolean bl) {
        PlaceEvent placeEvent = new PlaceEvent(this, 5, this.m_placeId, sTUser, string, bl);
        this.sendEvent(placeEvent);
    }

    public void close() {
        PlacesComp placesComp;
        if (this.m_inPlace) {
            this.leave(0);
        }
        if ((placesComp = (PlacesComp)this.m_session.getCompApi("com.lotus.sametime.places.PlacesComp")) != null) {
            placesComp.destroyPlace(this);
        }
        this.m_closed = true;
    }

    public Enumeration getMembers() {
        Hashtable hashtable = (Hashtable)this.m_placeMembers.clone();
        return hashtable.elements();
    }

    public String getName() {
        return this.m_placeName;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public Section getMySection() {
        return this.m_mySection;
    }

    public int getPlaceType() {
        return this.m_placeType;
    }

    public MyselfInPlace getMyselfInPlace() {
        return this.m_myself;
    }

    public STServer getServer() {
        return this.m_server;
    }

    public String getPassword() {
        return this.m_password;
    }

    public EncLevel getEncLevel() {
        return this.m_encLevel;
    }

    public boolean isPersistent() {
        return PlacesConstants.isPersistent(this.m_creationMode);
    }

    public short getPublishMode() {
        return this.m_publishMode;
    }

    public short getCreationMode() {
        return this.m_creationMode;
    }

    public boolean isInPlace() {
        return this.m_inPlace;
    }

    public int getActivitiesNum() {
        return this.m_activitiesNum;
    }

    public Place getPlace() {
        return this;
    }

    void addSubscriber(Integer n, int n2) {
        this.m_subscribedMembers.put(n, new Integer(n2));
    }

    int removeSubscriber(Integer n) {
        Object v = this.m_subscribedMembers.remove(n);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    boolean isSubscribed(Integer n) {
        return this.m_subscribedMembers.containsKey(n);
    }

    void addWaitingSubscriber(Integer n, int n2) {
        this.m_waitingSubscriptions.put(n, new Integer(n2));
    }

    int getWaitingSubscriber(Integer n) {
        Object v = this.m_waitingSubscriptions.get(n);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    int removeWaitingSubscriber(Integer n) {
        Object v = this.m_waitingSubscriptions.remove(n);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    boolean isWaitingSubscriber(Integer n) {
        return this.m_waitingSubscriptions.containsKey(n);
    }

    boolean addMessage(IncomingMessage incomingMessage) {
        boolean bl;
        Vector<IncomingMessage> vector;
        Integer n = incomingMessage.getSenderId();
        Object v = this.m_msgTable.get(n);
        if (v != null) {
            vector = (Vector<IncomingMessage>)v;
            bl = true;
        } else {
            vector = new Vector<IncomingMessage>();
            bl = false;
        }
        vector.addElement(incomingMessage);
        this.m_msgTable.put(n, vector);
        return bl;
    }

    Vector getMessages(Integer n) {
        return (Vector)this.m_msgTable.remove(n);
    }

    Integer getPlaceId() {
        return this.m_placeId;
    }

    void setChannel(Channel channel) {
        this.m_channel = channel;
    }

    Channel getChannel() {
        return this.m_channel;
    }

    void setEncLevel(EncLevel encLevel) {
        this.m_encLevel = encLevel;
    }

    EncLevel getRequestedEncLevel() {
        return this.m_requestedEncLevel;
    }

    void setMySection(Integer n) {
        Section section = (Section)this.getMember(n);
        if (section == null) {
            section = new Section(this.m_session, this, n);
            this.addMember(section);
        }
        this.m_mySection = section;
    }

    void setMyself(Integer n) {
        STUserInstance sTUserInstance = this.m_commService.getLogin().getMyUserInstance();
        this.m_myself = new MyselfInPlace(this.m_session, n, this, this.m_mySection, sTUserInstance.getId(), sTUserInstance.getName(), sTUserInstance.getLoginId(), sTUserInstance.getLoginType());
        this.m_placeMembers.put(n, this.m_myself);
    }

    boolean getToStage() {
        return this.m_toStage;
    }

    void addMember(PlaceMember placeMember) {
        Integer n = placeMember.getMemberId();
        if (this.m_myself != null && n.equals(this.m_myself.getMemberId())) {
            return;
        }
        this.m_placeMembers.put(n, placeMember);
    }

    PlaceMember getMember(Integer n) {
        if (n == 0) {
            return this;
        }
        return (PlaceMember)this.m_placeMembers.get(n);
    }

    PlaceMember removeMember(Integer n) {
        if (this.m_myself != null && n.equals(this.m_myself.getMemberId())) {
            return this.m_myself;
        }
        PlaceMember placeMember = (PlaceMember)this.m_placeMembers.remove(n);
        if (placeMember != null && placeMember instanceof Section) {
            this.removeAllSectionUsers((Section)placeMember);
        }
        return placeMember;
    }

    private void removeAllSectionUsers(Section section) {
        Enumeration enumeration = section.getUsers();
        while (enumeration.hasMoreElements()) {
            UserInPlace userInPlace = (UserInPlace)enumeration.nextElement();
            this.removeMember(userInPlace.getMemberId());
        }
    }

    protected void sendSnapshot(PlaceMemberListener placeMemberListener) {
        super.sendSnapshot(placeMemberListener);
        PlaceListener placeListener = (PlaceListener)placeMemberListener;
        Hashtable hashtable = (Hashtable)this.m_placeMembers.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            PlaceEvent placeEvent;
            PlaceMember placeMember = (PlaceMember)enumeration.nextElement();
            if (placeMember instanceof Section) {
                placeEvent = new PlaceEvent((Object)this, -2147483639, (Section)placeMember);
                placeListener.sectionAdded(placeEvent);
                continue;
            }
            if (!(placeMember instanceof Activity)) continue;
            placeEvent = new PlaceEvent((Object)this, -2147483642, (Activity)placeMember);
            placeListener.activityAdded(placeEvent);
        }
    }

    private STServer getServer(STUserInstance sTUserInstance, String string) {
        STServer sTServer = sTUserInstance.getServerId();
        return new STServer(sTServer.getId(), string, null);
    }

    public void processPlacesEvent(PlacesEvent placesEvent) {
        if (placesEvent instanceof PlaceMemberEvent) {
            this.processPlaceMemberEvent((PlaceMemberEvent)placesEvent);
        } else if (placesEvent instanceof PlaceEvent) {
            this.processPlaceEvent((PlaceEvent)placesEvent);
        }
    }

    protected void processPlaceEvent(PlaceEvent placeEvent) {
        placeEvent.setSource(this);
        switch (placeEvent.getId()) {
            case -2147483647: {
                this.handleEntered(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.handleEnterFailed(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483645: {
                this.handleLeft(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483639: {
                this.handleSectionAdded(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483638: {
                this.handleSectionRemoved(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483642: {
                this.handleActivityAdded(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483640: {
                this.handleActivityRemoved(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483641: {
                this.handleAddActivityFailed(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483637: {
                this.handleInvite15UserFailed(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483636: {
                this.handleAddAllowedUsersFailed(placeEvent);
                placeEvent.setConsumed(true);
                break;
            }
            case -2147483635: {
                this.handleRemoveAllowedUsersFailed(placeEvent);
                placeEvent.setConsumed(true);
            }
        }
    }

    protected void handleEntered(PlaceEvent placeEvent) {
        this.m_inPlace = true;
        this.m_publishMode = placeEvent.getPublishMode();
        this.m_creationMode = placeEvent.getCreationMode();
        this.m_activitiesNum = placeEvent.getActivitiesNum();
        this.m_displayName = placeEvent.getDisplayName();
        this.m_server = this.getServer(this.m_channel.getRemoteInfo(), placeEvent.getServerName());
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            this.addPlaceMemberListener(placeListener);
            placeListener.entered(placeEvent);
        }
    }

    protected void handleEnterFailed(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.enterFailed(placeEvent);
        }
    }

    protected void handleLeft(PlaceEvent placeEvent) {
        this.m_inPlace = false;
        this.m_subscribedMembers.clear();
        this.m_waitingSubscriptions.clear();
        this.m_placeMembers.clear();
        this.m_msgTable.clear();
        this.m_mySection = null;
        this.m_myself = null;
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            this.removePlaceMemberListener(placeListener);
            placeListener.left(placeEvent);
        }
    }

    protected void handleSectionAdded(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.sectionAdded(placeEvent);
        }
    }

    protected void handleSectionRemoved(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.sectionRemoved(placeEvent);
        }
    }

    protected void handleActivityAdded(PlaceEvent placeEvent) {
        ++this.m_activitiesNum;
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.activityAdded(placeEvent);
        }
    }

    protected void handleActivityRemoved(PlaceEvent placeEvent) {
        --this.m_activitiesNum;
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.activityRemoved(placeEvent);
        }
    }

    protected void handleAddActivityFailed(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.addActivityFailed(placeEvent);
        }
    }

    protected void handleAddAllowedUsersFailed(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.addAllowedUsersFailed(placeEvent);
        }
    }

    protected void handleRemoveAllowedUsersFailed(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.removeAllowedUsersFailed(placeEvent);
        }
    }

    protected void handleInvite15UserFailed(PlaceEvent placeEvent) {
        Vector vector = this.m_placeListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceListener placeListener = (PlaceListener)enumeration.nextElement();
            placeListener.invite15UserFailed(placeEvent);
        }
    }
}

