/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.lookup;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.ComponentListener;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.STError;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.lookup.LookupImpl;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

class GroupGetterImpl
implements ChannelListener,
LoginListener,
ComponentListener {
    private static final short GET_CONTENT_MSG_TYPE = 4;
    private static final short DIR_RESPONSE_ENTRY_TYPE_USER = 0;
    private static final short DIR_RESPONSE_ENTRY_TYPE_GROUP = 1;
    private Channel m_channel;
    private boolean m_channelOpenRequested = false;
    private Hashtable m_pendingRequests = new Hashtable();
    private Hashtable m_unansweredRequests = new Hashtable();
    private int m_unansweredRequestsCount = 0;
    private ChannelService m_channelService;
    private STSession m_stSession;
    private LookupImpl m_listener;
    private CommunityService m_comm;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.lookup");

    public GroupGetterImpl(STSession sTSession, LookupImpl lookupImpl) {
        this.m_stSession = sTSession;
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        Debug.stAssert(this.m_channelService != null);
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_comm) {
            this.m_comm.addLoginListener(this);
        } else {
            sTSession.addComponentListener(this);
        }
        this.m_listener = lookupImpl;
    }

    private void createChannel() {
        int n;
        int n2;
        int n3;
        int n4 = this.m_comm.getLogin().getServerVersion();
        short s = (short)(n4 >> 16);
        short s2 = (short)(n4 & 0xFFFF);
        if (s > 30 || s == 30 && s2 >= 25) {
            n3 = 39;
            n2 = 0;
            n = 0;
        } else {
            n3 = 26;
            n2 = 28;
            n = 5;
        }
        this.m_channel = this.m_channelService.createChannel(n3, n2, n, EncLevel.ENC_LEVEL_NONE, null, null);
        this.m_channel.addChannelListener(this);
    }

    public void getGroupContent(Integer n, STGroup sTGroup) {
        ++this.m_unansweredRequestsCount;
        if (this.m_channel.isOpen()) {
            this.requestGroupContent(n, sTGroup);
        } else {
            this.m_pendingRequests.put(n, sTGroup);
            if (!this.m_channelOpenRequested) {
                this.m_channelOpenRequested = true;
                this.m_channel.open();
            }
        }
    }

    public void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        this.m_channelOpenRequested = false;
        Enumeration enumeration = this.m_pendingRequests.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            STGroup sTGroup = (STGroup)this.m_pendingRequests.get(n);
            this.requestGroupContent(n, sTGroup);
        }
        this.m_pendingRequests.clear();
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        block10: {
            Channel channel = channelEvent.getChannel();
            Debug.stAssert(channel == this.m_channel);
            String string = this.m_channel.getRemoteInfo().getCommunityName();
            if (channelEvent.getMessageType() != 4) {
                return;
            }
            if (--this.m_unansweredRequestsCount == 0) {
                this.m_channel.close(0, null);
            }
            Integer n = null;
            int n2 = 0;
            try {
                NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
                n = new Integer(ndrInputStream.readInt());
                n2 = ndrInputStream.readInt();
                if (STError.VpkFailed(n2)) {
                    if (this.m_listener != null) {
                        this.m_listener.groupContentFailed(n, n2);
                    }
                    return;
                }
                ndrInputStream.readUTF();
                int n3 = ndrInputStream.readInt();
                STObject[] sTObjectArray = new STObject[n3];
                for (int i = 0; i < n3; ++i) {
                    short s = ndrInputStream.readShort();
                    STId sTId = new STId(ndrInputStream.readUTF(), string);
                    String string2 = ndrInputStream.readUTF();
                    if (s == 0) {
                        sTObjectArray[i] = new STUser(sTId, string2, "");
                        ndrInputStream.readUTF();
                        ndrInputStream.readUTF();
                        continue;
                    }
                    String string3 = ndrInputStream.readUTF();
                    sTObjectArray[i] = new STGroup(sTId, string2, string3);
                }
                if (this.m_listener != null) {
                    STGroup sTGroup = (STGroup)this.m_unansweredRequests.remove(n);
                    this.m_listener.gotGroupContent(n, sTGroup, sTObjectArray);
                }
            }
            catch (IOException iOException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelMsgReceived", iOException.toString(), iOException);
                }
                if (this.m_listener == null || n == null) break block10;
                this.m_listener.groupContentFailed(n, n2);
            }
        }
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        this.channelClosed(channelEvent);
    }

    public void channelClosed(ChannelEvent channelEvent) {
        Integer n;
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(channel == this.m_channel);
        Enumeration enumeration = this.m_pendingRequests.keys();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            this.m_listener.groupContentFailed(n, 0);
        }
        this.m_pendingRequests.clear();
        enumeration = this.m_unansweredRequests.keys();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            this.m_listener.groupContentFailed(n, 0);
        }
        this.m_unansweredRequests.clear();
        this.m_unansweredRequestsCount = 0;
    }

    protected void requestGroupContent(Integer n, STGroup sTGroup) {
        this.m_unansweredRequests.put(n, sTGroup);
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            STId sTId = sTGroup.getId();
            String string = sTGroup.getName();
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeUTF(sTId.getId());
            ndrOutputStream.writeUTF(string);
            this.m_channel.sendMsg((short)4, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.createChannel();
    }

    public void loggedOut(LoginEvent loginEvent) {
        if (this.m_channel != null) {
            this.m_channel.removeChannelListener(this);
        }
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (this.m_comm == null && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
            this.m_comm.addLoginListener(this);
            this.m_stSession.removeComponentListener(this);
        }
    }
}

