/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.filetransfer;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.InvalidOperation;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.filetransfer.FileTransferEvent;
import com.lotus.sametime.filetransfer.FileTransferListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class FileTransfer {
    static final String ST_TRANSFER_TYPE_UNKNOWN = "binary/unknown";
    static final Integer ST_TRANSFER_ID_UNKNOWN = new Integer(0);
    private String m_transferType = "binary/unknown";
    private Integer m_transferID = ST_TRANSFER_ID_UNKNOWN;
    private Vector m_listeners = new Vector();
    private String m_fileName;
    private String m_fileDesc;
    private int m_fileSize;
    private Channel m_channel;
    private ChannelListener m_channelListener;
    private boolean m_isReceiving;
    private boolean m_isStarted = false;
    private OutputStream m_outStream;
    private InputStream m_inStream;
    private long m_bytesTransfered = 0L;
    private int m_networkChunkSize;
    private int m_fileChunkSize = this.m_networkChunkSize = 2000;
    private int m_initalChunksBlock = 8;
    private short m_compressionMethod = (short)2;
    private Deflater m_deflater;
    private Inflater m_inflater;
    private byte[] m_tempBuffer;
    private float m_updateInterval = 0.05f;
    private float m_nextBytesTransferredEvent;
    private STUser m_partner;
    private static final short TRANSFER_FILE_CHUNK = 1;
    private static final short FILE_CHUNK_ACK = 2;
    private static final short COMPRESSION_NONE = 0;
    private static final short COMPRESSION_ZLIB = 2;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.filetransfer");

    protected FileTransfer(STSession sTSession, STUser sTUser, FileInputStream fileInputStream, String string, String string2, String string3, Integer n) throws IOException {
        this.m_isReceiving = false;
        this.m_inStream = fileInputStream;
        this.m_fileName = string;
        this.m_fileDesc = string2;
        this.m_partner = sTUser;
        this.m_transferType = string3;
        this.m_transferID = n;
        this.m_fileSize = this.m_inStream.available();
        this.m_nextBytesTransferredEvent = (float)this.m_fileSize * this.m_updateInterval;
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        ndrOutputStream.startMark();
        ndrOutputStream.writeUTF(this.m_fileName);
        ndrOutputStream.writeUTF(this.m_fileDesc);
        ndrOutputStream.writeInt(this.m_fileSize);
        ndrOutputStream.writeShort(this.m_compressionMethod);
        ndrOutputStream.dumpMarks();
        ndrOutputStream.writeUTF(this.m_transferType);
        ndrOutputStream.writeInt(this.m_transferID);
        ChannelService channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_channel = channelService.createChannel(56, 0, 0, EncLevel.ENC_LEVEL_ALL, ndrOutputStream.toByteArray(), sTUser.getId(), (byte)15);
        this.createChannelListener();
        this.m_channel.addChannelListener(this.m_channelListener);
    }

    protected FileTransfer(STSession sTSession, STUser sTUser, FileInputStream fileInputStream, String string, String string2) throws IOException {
        this(sTSession, sTUser, fileInputStream, string, string2, ST_TRANSFER_TYPE_UNKNOWN, ST_TRANSFER_ID_UNKNOWN);
    }

    protected FileTransfer(Channel channel) throws IOException {
        this.m_channel = channel;
        this.m_isReceiving = true;
        this.m_partner = channel.getRemoteInfo();
        this.createChannelListener();
        channel.addChannelListener(this.m_channelListener);
        NdrInputStream ndrInputStream = new NdrInputStream(channel.getCreateData());
        ndrInputStream.loadMark();
        this.m_fileName = ndrInputStream.readUTF();
        this.m_fileDesc = ndrInputStream.readUTF();
        this.m_fileSize = ndrInputStream.readInt();
        this.m_compressionMethod = (short)(this.m_compressionMethod & ndrInputStream.readShort());
        ndrInputStream.skipMarks();
        try {
            this.m_transferType = ndrInputStream.readUTF();
            this.m_transferID = new Integer(ndrInputStream.readInt());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_nextBytesTransferredEvent = (float)this.m_fileSize * this.m_updateInterval;
    }

    public synchronized void addFileTransferListener(FileTransferListener fileTransferListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(fileTransferListener);
        this.m_listeners = vector;
    }

    public synchronized void removeFileTransferListener(FileTransferListener fileTransferListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(fileTransferListener);
        this.m_listeners = vector;
    }

    public synchronized void start() {
        if (this.m_isReceiving || this.m_isStarted) {
            throw new InvalidOperation("Invalid operation: start");
        }
        this.m_isStarted = true;
        this.m_channel.open();
    }

    public void accept(OutputStream outputStream) {
        if (!this.m_isReceiving) {
            throw new InvalidOperation("Invalid operation: accept");
        }
        try {
            this.m_outStream = outputStream;
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.startMark();
            ndrOutputStream.writeShort(this.m_compressionMethod);
            ndrOutputStream.dumpMarks();
            if (this.m_compressionMethod == 2) {
                this.m_inflater = new Inflater(true);
                this.m_tempBuffer = new byte[this.m_fileChunkSize * 8];
            }
            this.m_channel.accept(EncLevel.ENC_LEVEL_ALL, ndrOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.m_channel.close(Integer.MIN_VALUE, null);
        }
    }

    public void decline() {
        this.decline(0x8000606);
    }

    public void decline(int n) {
        if (!this.m_isReceiving) {
            throw new InvalidOperation("Invalid operation: decline");
        }
        if (null != this.m_channel) {
            this.m_channel.close(n, null);
        }
    }

    public void stop() {
        if (null != this.m_channel) {
            this.m_channel.close(-2147483644, null);
        }
    }

    public int getFileSize() {
        return this.m_fileSize;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getFileDesc() {
        return this.m_fileDesc;
    }

    public STUser getPartner() {
        return this.m_partner;
    }

    public long getNumOfByteTransferred() {
        return this.m_bytesTransfered;
    }

    public void setUpdateInterval(int n) {
        if (n > 1 && n < 100) {
            this.m_updateInterval = (float)n / 100.0f;
            if (this.m_nextBytesTransferredEvent < this.m_updateInterval * (float)this.m_fileSize) {
                this.m_nextBytesTransferredEvent = this.m_updateInterval * (float)this.m_fileSize;
            }
        } else if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "setUpdateInterval", "Ignoring invalid interval value: " + n);
        }
    }

    private void channelOpened(ChannelEvent channelEvent) {
        FileTransferEvent fileTransferEvent = new FileTransferEvent(this, 2);
        this.dispatchEvent(fileTransferEvent);
        if (this.m_fileSize == 0) {
            fileTransferEvent = new FileTransferEvent(this, 3);
            this.dispatchEvent(fileTransferEvent);
            this.m_channel.close(0, null);
        } else if (!this.m_isReceiving) {
            try {
                NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
                ndrInputStream.loadMark();
                this.m_compressionMethod = ndrInputStream.readShort();
            }
            catch (IOException iOException) {
                this.m_compressionMethod = (short)-1;
                iOException.printStackTrace();
            }
            if (this.m_compressionMethod != 0 && this.m_compressionMethod != 2) {
                this.m_channel.close(Integer.MIN_VALUE, null);
            } else {
                if (this.m_compressionMethod == 2) {
                    this.m_deflater = new Deflater(9, true);
                    this.m_tempBuffer = new byte[this.m_fileChunkSize * 8];
                }
                for (int i = 0; i < this.m_initalChunksBlock; ++i) {
                    this.sendChunk();
                }
            }
        }
        this.m_partner = this.m_channel.getRemoteInfo();
    }

    private void channelOpenFailed(ChannelEvent channelEvent) {
        this.m_channel.removeChannelListener(this.m_channelListener);
        this.m_channel = null;
        this.closeStreams();
        int n = 5;
        FileTransferEvent fileTransferEvent = new FileTransferEvent(this, n, channelEvent.getReason());
        this.dispatchEvent(fileTransferEvent);
    }

    private void channelClosed(ChannelEvent channelEvent) {
        int n;
        this.m_channel.removeChannelListener(this.m_channelListener);
        this.m_channel = null;
        this.closeStreams();
        switch (channelEvent.getReason()) {
            case 0: {
                if (this.m_bytesTransfered == (long)this.m_fileSize) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            default: {
                n = 4;
            }
        }
        FileTransferEvent fileTransferEvent = new FileTransferEvent(this, n, channelEvent.getReason());
        this.dispatchEvent(fileTransferEvent);
    }

    private void onMsgReceived(ChannelEvent channelEvent) {
        switch (channelEvent.getMessageType()) {
            case 1: {
                this.handleFileChunkReceived(channelEvent);
                break;
            }
            case 2: {
                this.handleFileChunkAck();
                break;
            }
            default: {
                if (!this.m_logger.isLoggable(Level.FINER)) break;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "onMsgReceived", this + " Unknown message type (" + channelEvent.getMessageType() + ") received on channel: ");
            }
        }
    }

    private void handleFileChunkReceived(ChannelEvent channelEvent) {
        if (!this.m_isReceiving) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "handleFileChunkReceived", this + " Invalid message send file chunk");
            }
            this.m_channel.close(Integer.MIN_VALUE, null);
            return;
        }
        try {
            byte[] byArray = this.decompress(channelEvent.getData());
            this.m_outStream.write(byArray);
            this.m_outStream.flush();
            this.m_bytesTransfered += (long)byArray.length;
            this.m_channel.sendMsg((short)2, null, false);
            this.sendBytesTransferredUpdate();
            if (this.m_bytesTransfered > (long)this.m_fileSize) {
                this.m_channel.close(Integer.MIN_VALUE, null);
            } else if (this.m_bytesTransfered == (long)this.m_fileSize) {
                this.m_channel.close(0, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_channel.close(Integer.MIN_VALUE, null);
        }
    }

    private void sendChunk() {
        if (this.m_isReceiving) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendChunk", this + " Invalid operation send chunk");
            }
            this.m_channel.close(Integer.MIN_VALUE, null);
            return;
        }
        try {
            int n = this.m_inStream.available();
            if (n > 0) {
                byte[] byArray = new byte[n >= this.m_fileChunkSize ? this.m_fileChunkSize : n];
                this.m_inStream.read(byArray);
                byte[] byArray2 = this.compress(byArray);
                float f = (float)this.m_networkChunkSize / (float)byArray2.length;
                this.m_fileChunkSize = Math.min(3 * this.m_networkChunkSize, (int)(f * (float)this.m_fileChunkSize));
                this.m_channel.sendMsg((short)1, byArray2, true);
                this.m_bytesTransfered += (long)byArray.length;
                this.sendBytesTransferredUpdate();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.m_channel.close(Integer.MIN_VALUE, null);
        }
    }

    private void sendBytesTransferredUpdate() {
        if ((float)this.m_bytesTransfered > this.m_nextBytesTransferredEvent) {
            FileTransferEvent fileTransferEvent = new FileTransferEvent(this, 6);
            this.dispatchEvent(fileTransferEvent);
            while (this.m_nextBytesTransferredEvent < (float)this.m_bytesTransfered && this.m_nextBytesTransferredEvent < (float)this.m_fileSize) {
                this.m_nextBytesTransferredEvent += this.m_updateInterval * (float)this.m_fileSize;
            }
        }
    }

    private byte[] compress(byte[] byArray) {
        byte[] byArray2 = null;
        switch (this.m_compressionMethod) {
            case 0: {
                byArray2 = byArray;
                break;
            }
            case 2: {
                this.m_deflater.setInput(byArray, 0, byArray.length);
                this.m_deflater.finish();
                int n = this.m_deflater.deflate(this.m_tempBuffer);
                byArray2 = new byte[n];
                System.arraycopy(this.m_tempBuffer, 0, byArray2, 0, n);
                this.m_deflater.reset();
                break;
            }
            default: {
                if (!this.m_logger.isLoggable(Level.FINER)) break;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "compress", "Unknown compression method " + this);
            }
        }
        return byArray2;
    }

    private byte[] decompress(byte[] byArray) throws Exception {
        byte[] byArray2 = null;
        switch (this.m_compressionMethod) {
            case 0: {
                byArray2 = byArray;
                break;
            }
            case 2: {
                NdrOutputStream ndrOutputStream = new NdrOutputStream();
                int n = -1;
                this.m_inflater.setInput(byArray);
                while (!this.m_inflater.finished() && n != 0) {
                    n = this.m_inflater.inflate(this.m_tempBuffer);
                    ndrOutputStream.write(this.m_tempBuffer, 0, n);
                }
                byArray2 = ndrOutputStream.toByteArray();
                this.m_inflater.reset();
                break;
            }
            default: {
                if (!this.m_logger.isLoggable(Level.FINER)) break;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "decompress", "Unknown compression method " + this);
            }
        }
        return byArray2;
    }

    private void handleFileChunkAck() {
        this.sendChunk();
    }

    private void closeStreams() {
        try {
            if (null != this.m_outStream) {
                this.m_outStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            if (null != this.m_inStream) {
                this.m_inStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void dispatchEvent(FileTransferEvent fileTransferEvent) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            FileTransferListener fileTransferListener = (FileTransferListener)enumeration.nextElement();
            switch (fileTransferEvent.getId()) {
                case 2: {
                    fileTransferListener.fileTransferStarted(fileTransferEvent);
                    break;
                }
                case 4: {
                    fileTransferListener.fileTransferStopped(fileTransferEvent);
                    break;
                }
                case 5: {
                    fileTransferListener.fileTransferDeclined(fileTransferEvent);
                    break;
                }
                case 3: {
                    fileTransferListener.fileTransferCompleted(fileTransferEvent);
                    break;
                }
                case 6: {
                    fileTransferListener.bytesTransferredUpdate(fileTransferEvent);
                }
            }
        }
    }

    private void createChannelListener() {
        this.m_channelListener = new ChannelListener(){

            public void channelOpened(ChannelEvent channelEvent) {
                FileTransfer.this.channelOpened(channelEvent);
            }

            public void channelOpenFailed(ChannelEvent channelEvent) {
                FileTransfer.this.channelOpenFailed(channelEvent);
            }

            public void channelClosed(ChannelEvent channelEvent) {
                FileTransfer.this.channelClosed(channelEvent);
            }

            public void channelMsgReceived(ChannelEvent channelEvent) {
                FileTransfer.this.onMsgReceived(channelEvent);
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FileTransfer: ");
        stringBuffer.append(this.hashCode());
        stringBuffer.append(" File Name: ");
        stringBuffer.append(this.m_fileName);
        stringBuffer.append(" File Size: ");
        stringBuffer.append(this.m_fileSize);
        return stringBuffer.toString();
    }

    public String getTransferType() {
        return this.m_transferType;
    }

    public Integer getTransferID() {
        return this.m_transferID;
    }
}

