/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.directory;

import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.directory.DirectoryComp;
import com.lotus.sametime.directory.DirectoryEvent;
import com.lotus.sametime.directory.DirectoryListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Directory {
    private String m_port;
    private String m_server;
    private String m_file;
    private String m_title;
    private Vector m_listeners = new Vector();
    private DirectoryComp m_directoryComp;
    private short m_chunkSize = 0;

    Directory(NdrInputStream ndrInputStream) throws IOException {
        this.m_port = ndrInputStream.readUTF();
        this.m_server = ndrInputStream.readUTF();
        this.m_file = ndrInputStream.readUTF();
        this.m_title = ndrInputStream.readUTF();
    }

    void dump(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeUTF(this.m_port);
        ndrOutputStream.writeUTF(this.m_server);
        ndrOutputStream.writeUTF(this.m_file);
        ndrOutputStream.writeUTF(this.m_title);
    }

    String getPort() {
        return this.m_port;
    }

    String getServer() {
        return this.m_server;
    }

    String getFile() {
        return this.m_file;
    }

    public String getTitle() {
        return this.m_title;
    }

    public synchronized void addDirectoryListener(DirectoryListener directoryListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(directoryListener);
        this.m_listeners = vector;
    }

    public synchronized void removeDirectoryListener(DirectoryListener directoryListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(directoryListener);
        this.m_listeners = vector;
    }

    public Integer queryEntries(boolean bl) {
        Integer n = this.m_directoryComp.queryEntries(this, bl, this.m_chunkSize);
        return n;
    }

    public Integer queryEntries(String string) {
        Integer n = this.m_directoryComp.queryEntries(this, string, this.m_chunkSize);
        return n;
    }

    public void open() {
        this.m_directoryComp.openDirectory(this);
    }

    public void close() {
        this.m_directoryComp.closeDirectory(this);
    }

    void dispatchEvent(DirectoryEvent directoryEvent) {
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        directoryEvent.setSource(this);
        while (enumeration.hasMoreElements()) {
            DirectoryListener directoryListener = (DirectoryListener)enumeration.nextElement();
            switch (directoryEvent.getId()) {
                case 10: {
                    directoryListener.directoryOpened(directoryEvent);
                    break;
                }
                case 9: {
                    directoryListener.directoryOpenFailed(directoryEvent);
                    break;
                }
                case 12: {
                    directoryListener.entriesQueried(directoryEvent);
                    break;
                }
                case 11: {
                    directoryListener.entriesQueryFailed(directoryEvent);
                }
            }
        }
    }

    void setDirectoryComp(DirectoryComp directoryComp) {
        this.m_directoryComp = directoryComp;
    }

    public void setMaxEntries(short s) {
        this.m_chunkSize = s;
    }

    public short getMaxEntries() {
        return this.m_chunkSize;
    }
}

