/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.connection.Sender;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

class HttpSender
extends Sender {
    private String m_host = null;
    private int m_port = 0;
    private URL m_hostUrl = null;
    private DataOutputStream m_outStream = null;
    private DataInputStream m_inStream = null;
    private byte[] m_masterId = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected HttpSender(String string, int n, URL uRL, byte[] byArray) {
        this.m_host = string;
        this.m_port = n;
        this.m_hostUrl = uRL;
        this.m_masterId = byArray;
    }

    protected void initialize() {
    }

    protected void cleanup() {
    }

    protected synchronized void send(byte[] byArray) throws IOException {
        URL uRL = this.m_hostUrl == null ? new URL("http", this.m_host, this.m_port, "/communityCBR/") : new URL(this.m_hostUrl.toString() + "/communityCBR/");
        URLConnection uRLConnection = this.openUrlConnection(uRL);
        this.m_outStream = new DataOutputStream(uRLConnection.getOutputStream());
        this.m_outStream.writeByte(255);
        this.m_outStream.writeShort(this.m_masterId.length);
        this.m_outStream.write(this.m_masterId, 0, this.m_masterId.length);
        this.m_outStream.write(byArray);
        this.m_outStream.flush();
        this.m_outStream.close();
        this.m_outStream = null;
        this.m_inStream = new DataInputStream(this.safeGetInputStream(uRLConnection));
        this.m_inStream.readByte();
        short s = this.m_inStream.readShort();
        this.m_masterId = new byte[s];
        this.m_inStream.readFully(this.m_masterId);
        this.m_inStream.close();
    }

    protected URLConnection openUrlConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Pragma", "No-Cache");
        uRLConnection.setRequestProperty("Content-Type", "Application/Octet-Stream");
        return uRLConnection;
    }

    protected InputStream safeGetInputStream(URLConnection uRLConnection) throws IOException {
        try {
            return uRLConnection.getInputStream();
        }
        catch (SecurityException securityException) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "safeGetInputStream", "Requesting privilage fo HTTP connection.");
            }
            return uRLConnection.getInputStream();
        }
    }

    protected void setMasterId(byte[] byArray) {
        this.m_masterId = byArray;
    }

    protected boolean sendKeepAlive() {
        return true;
    }

    public byte[] buildCompoundMessage() throws IOException {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        while (!this.m_queue.isEmpty()) {
            ndrOutputStream.write((byte[])this.m_queue.getNext());
        }
        return ndrOutputStream.toByteArray();
    }
}

