/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import java.net.URL;

public class ConnectionInfo {
    public static final int CONNECTION_TYPE_SOCKET = 0;
    public static final int CONNECTION_TYPE_DIRECT_SOCKET = 1;
    public static final int CONNECTION_TYPE_HTTP = 2;
    public static final int CONNECTION_TYPE_HTTPS = 3;
    public static final int CONNECTION_TYPE_SOCKS4 = 4;
    public static final int CONNECTION_TYPE_SOCKS5 = 5;
    public static final int CONNECTION_TYPE_HTTP_POLLING = 6;
    public static final int CONNECTION_TYPE_AGENT = 7;
    public static final int CONNECTION_TYPE_HYBRID_POLLING = 8;
    private static final String[] CONNECTION_NAMES = new String[]{"SOCKET", "DIRECT_SOCKET", "HTTP", "HTTPS", "SOCKS4", "SOCKS5", "HTTP_POLLING", "AGENT", "HYBRID POLLING"};
    static final String TCP_CONNECTION = "TCP";
    static final String HTTP_CONNECTION = "HTTP";
    private int m_connectionType;
    private int m_serverPort;
    private String m_hostName;
    private String m_serverProtocol = "TCP";
    private URL m_hostUrl = null;
    private String m_proxyServer;
    private int m_proxyPort;
    private String m_proxyLogin;
    private String m_proxyPassword;
    private boolean m_useOurOwnConnection;

    ConnectionInfo(int n, int n2, String string, int n3, String string2, String string3) {
        this.m_connectionType = n;
        this.m_serverPort = n2;
        this.m_proxyServer = string;
        this.m_proxyPort = n3;
        this.m_proxyLogin = string2;
        this.m_proxyPassword = string3;
        this.m_useOurOwnConnection = false;
    }

    ConnectionInfo(int n, int n2, String string, int n3, String string2, String string3, boolean bl) {
        this.m_connectionType = n;
        this.m_serverPort = n2;
        this.m_proxyServer = string;
        this.m_proxyPort = n3;
        this.m_proxyLogin = string2;
        this.m_proxyPassword = string3;
        this.m_useOurOwnConnection = bl;
    }

    ConnectionInfo(int n, int n2, String string, int n3, String string2, String string3, boolean bl, String string4, URL uRL, String string5) {
        this.m_connectionType = n;
        this.m_serverPort = n2;
        this.m_proxyServer = string;
        this.m_proxyPort = n3;
        this.m_proxyLogin = string2;
        this.m_proxyPassword = string3;
        this.m_useOurOwnConnection = bl;
        this.m_hostName = string4;
        this.m_serverProtocol = string5;
        this.m_hostUrl = uRL;
    }

    ConnectionInfo(int n, int n2, String string, int n3, String string2, String string3, boolean bl, String string4, URL uRL) {
        this(n, n2, string, n3, string2, string3, bl, string4, uRL, TCP_CONNECTION);
    }

    public int getConnectionType() {
        return this.m_connectionType;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public int getServerPort() {
        return this.m_serverPort;
    }

    public String getServerProtocol() {
        return this.m_hostUrl == null ? this.m_serverProtocol : this.m_hostUrl.getProtocol();
    }

    public URL getHostUrl() {
        return this.m_hostUrl;
    }

    public String getProxyServer() {
        return this.m_proxyServer;
    }

    public int getProxyPort() {
        return this.m_proxyPort;
    }

    public String getProxyLogin() {
        return this.m_proxyLogin;
    }

    public String getProxyPassword() {
        return this.m_proxyPassword;
    }

    public boolean isOurOwnConnection() {
        return this.m_useOurOwnConnection;
    }

    public String toString() {
        String string = "===================== Connection =======================";
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("\ntype = ");
        stringBuffer.append(CONNECTION_NAMES[this.m_connectionType]);
        stringBuffer.append("\nhostName = ");
        stringBuffer.append(this.m_hostName);
        stringBuffer.append("\nhostUrl = ");
        stringBuffer.append(this.m_hostUrl);
        stringBuffer.append("\nserverPort = ");
        stringBuffer.append(this.m_serverPort);
        stringBuffer.append("\nproxyServer = ");
        stringBuffer.append(this.m_proxyServer);
        stringBuffer.append("\nproxyPort = ");
        stringBuffer.append(this.m_proxyPort);
        stringBuffer.append("\nproxyLogin = ");
        stringBuffer.append(this.m_proxyLogin);
        stringBuffer.append("\nproxyPassword = ");
        stringBuffer.append(this.m_proxyPassword);
        stringBuffer.append("\nserverProtocol = ");
        stringBuffer.append(this.m_serverProtocol);
        if (this.m_connectionType == 2) {
            stringBuffer.append("\nuseOurOwnConnection = ");
            stringBuffer.append(this.m_useOurOwnConnection);
        }
        stringBuffer.append("\n" + string);
        return stringBuffer.toString();
    }
}

