/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.awareness.AttributeAdapter;
import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeListener;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.awarenessui.AwarenessViewAdapter;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.awarenessui.AwarenessViewListener;
import com.lotus.sametime.awarenessui.list.AwarenessList;
import com.lotus.sametime.commui.DirectoryDialog;
import com.lotus.sametime.commui.ResolveListController;
import com.lotus.sametime.commui.ResolveListListener;
import com.lotus.sametime.commui.ResolveViewEvent;
import com.lotus.sametime.commui.ResolveViewListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.directory.DirectoryService;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.guiutils.statusbar.Statusbar;
import com.lotus.sametime.lookup.GroupContentAdapter;
import com.lotus.sametime.lookup.GroupContentEvent;
import com.lotus.sametime.lookup.GroupContentGetter;
import com.lotus.sametime.lookup.GroupContentListener;
import com.lotus.sametime.lookup.LookupService;
import com.lotus.sametime.lookup.ResolveEvent;
import com.lotus.sametime.lookup.ResolveListener;
import com.lotus.sametime.lookup.Resolver;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class AddDialog
extends Dialog
implements ItemListener,
TextListener,
ActionListener {
    private STSession m_session;
    private Resolver m_resolver;
    private LookupService m_lookupService;
    private AwarenessList m_list;
    private Vector m_listeners = new Vector();
    private Panel m_listPanel;
    private Panel m_communityPanel;
    private Label m_addToPrivacyLabel;
    private Label m_commLabel;
    private Label m_userNameLbl;
    private Choice m_communityChoice;
    private Label m_addToPrivacyExLabel;
    private Panel m_southPanel;
    private Button m_btnAdd;
    private String m_addBtnLabel;
    private Button m_btnClose;
    private String m_closeBtnLabel;
    private Button m_btnDir;
    private String m_dirBtnLabel;
    private String m_dirTitle;
    private STTextField m_tfName;
    private Statusbar m_statusBar;
    private STBundle m_resourceFile;
    private boolean m_listShown = false;
    private String m_originalName;
    private Frame m_parentFrame;
    private boolean m_browsingEnabled;
    private ButtonsPanel m_fullBtnPnl;
    private ButtonsPanel m_btnPnl;
    private ActionListener m_actionListener;
    private KeyListener m_keyListener;
    private ResolveListener m_resolveListener;
    private ResolveListListener m_resolveListListener;
    private AwarenessViewListener m_awarenessViewListener;
    private AttributeListener m_attributeListener;
    private GroupContentListener m_groupContentListener;
    private LoginListener m_loginListener;
    private WatchList m_watchList;
    boolean m_addAlsoExternal = false;
    private static final short SAMETIME_USER_PANEL = 1;
    private static final short EXTERNAL_USER_PANEL = 2;
    private boolean m_sipGatewayEnabled = false;

    public AddDialog(Frame frame, STSession sTSession, String string) {
        super(frame, string, false);
        this.m_session = sTSession;
        this.m_parentFrame = frame;
        this.construct();
    }

    public AddDialog(Frame frame, STSession sTSession, String string, String string2, boolean bl) {
        super(frame, string, false);
        this.m_session = sTSession;
        this.m_parentFrame = frame;
        this.m_dirTitle = string2;
        this.m_addAlsoExternal = bl;
        this.construct();
    }

    private void construct() {
        this.m_lookupService = (LookupService)this.m_session.getCompApi("com.lotus.sametime.lookup.LookupComp");
        AwarenessService awarenessService = (AwarenessService)this.m_session.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        DirectoryService directoryService = (DirectoryService)this.m_session.getCompApi("com.lotus.sametime.directory.DirectoryComp");
        this.m_browsingEnabled = directoryService != null;
        this.m_resourceFile = ((ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/commui");
        Debug.stAssert(this.m_lookupService != null);
        Debug.stAssert(awarenessService != null);
        this.createListeners();
        this.initUI();
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.m_resolver = this.m_lookupService.createResolver(false, true, true, false);
        this.m_resolver.addResolveListener(this.m_resolveListener);
        this.m_watchList = awarenessService.createWatchList();
        this.m_watchList.addAttrListener(this.m_attributeListener);
        int[] nArray = new int[]{9004};
        awarenessService.addToAttrFilter(nArray);
        CommunityService communityService = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        communityService.addLoginListener(this.m_loginListener);
        if (communityService.isLoggedIn()) {
            this.setEnabled(true);
            STServer sTServer = communityService.getLogin().getServer();
            this.m_watchList.addItem(sTServer);
        }
        if (!this.isWatsonServer(this.m_session)) {
            this.enableDirButton();
        }
        this.m_tfName.addTextListener(this);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_tfName.getText().equals("")) {
            this.m_btnAdd.setEnabled(true);
        }
    }

    private void initUI() {
        this.m_tfName = new STTextField(25);
        this.m_list = new AwarenessList(this.m_session, true);
        String string = "";
        Font font = this.m_resourceFile.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE");
        int n = this.m_resourceFile.getInt("STATUS_BAR_HEIGHT");
        this.m_statusBar = new Statusbar(string, font, n);
        this.m_list.setController(new ResolveListController(this.m_list, this.m_resolveListListener));
        this.m_list.addAwarenessViewListener(this.m_awarenessViewListener);
        this.m_tfName.addKeyListener(this.m_keyListener);
        this.setLayout(new BorderLayout(3, 3));
        this.setBackground(SystemColor.control);
        this.setResizable(false);
        this.m_listPanel = new Panel(new BorderLayout());
        this.m_listPanel.add("North", new Label(this.m_resourceFile.getString("LBL_SELECT_USER")));
        this.m_listPanel.add("Center", this.m_list);
        this.m_communityPanel = new Panel(new GridLayout(1, 2));
        Panel panel = new Panel();
        this.m_commLabel = new Label(this.m_resourceFile.getString("LBL_COMMUNITY"));
        this.m_addToPrivacyLabel = new Label(this.m_resourceFile.getString("LBL_ADD_TO_PRIVACY_LIST"));
        this.m_communityChoice = new Choice();
        this.m_communityChoice.addItem(this.m_resourceFile.getString("CHOICE_SAMETIME"));
        this.m_communityChoice.addItem(this.m_resourceFile.getString("CHOICE_EXTERNAL"));
        this.m_communityChoice.addItemListener(this);
        this.m_communityPanel.add(this.m_commLabel);
        this.m_communityPanel.add(this.m_communityChoice);
        Panel panel2 = new Panel(new FlowLayout(0, 3, 3));
        this.m_userNameLbl = new Label(this.m_resourceFile.getString("LBL_NAME"));
        this.m_addBtnLabel = this.m_resourceFile.getString("BTN_LBL_ADD");
        this.m_closeBtnLabel = this.m_resourceFile.getString("BTN_LBL_CLOSE");
        this.m_dirBtnLabel = this.m_resourceFile.getString("BTN_LBL_DIRECTORY");
        String[] stringArray = new String[]{this.m_addBtnLabel, this.m_closeBtnLabel};
        this.m_btnPnl = new ButtonsPanel(stringArray, this.m_actionListener, 2);
        String[] stringArray2 = new String[]{this.m_addBtnLabel, this.m_dirBtnLabel, this.m_closeBtnLabel};
        this.m_fullBtnPnl = new ButtonsPanel(stringArray2, this.m_actionListener, 2);
        this.m_southPanel = new Panel(new GridLayout(0, 1, 3, 6));
        this.m_southPanel.add(this.m_btnPnl);
        this.m_southPanel.add(this.m_statusBar);
        this.m_btnAdd = this.m_btnPnl.getButton(this.m_addBtnLabel);
        this.m_btnDir = this.m_btnPnl.getButton(this.m_dirBtnLabel);
        this.m_btnClose = this.m_btnPnl.getButton(this.m_closeBtnLabel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        if (this.m_sipGatewayEnabled) {
            gridBagConstraints.gridwidth = 17;
            gridBagLayout.setConstraints(this.m_commLabel, gridBagConstraints);
            panel.add(this.m_commLabel);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.m_communityChoice, gridBagConstraints);
            panel.add(this.m_communityChoice);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.m_addToPrivacyLabel, gridBagConstraints);
            panel.add(this.m_addToPrivacyLabel);
        } else {
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.m_addToPrivacyLabel, gridBagConstraints);
            panel.add(this.m_addToPrivacyLabel);
        }
        gridBagConstraints.gridwidth = 17;
        gridBagLayout.setConstraints(this.m_userNameLbl, gridBagConstraints);
        panel.add(this.m_userNameLbl);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tfName, gridBagConstraints);
        panel.add(this.m_tfName);
        this.m_listPanel.setVisible(false);
        this.add("North", panel);
        this.add("Center", this.m_listPanel);
        this.add("South", this.m_southPanel);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddDialog.this.dispose();
            }
        });
        Rectangle rectangle = this.getParent().getBounds();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (rectangle.x + rectangle.width + dimension.width < dimension2.width && rectangle.y < dimension2.height) {
            this.setLocation(rectangle.x + rectangle.width, rectangle.y);
        } else {
            this.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        }
        this.m_btnAdd.setEnabled(false);
        this.m_tfName.addActionListener(this);
        this.m_tfName.requestFocus();
    }

    public void requestFocus() {
        super.requestFocus();
        this.m_tfName.requestFocus();
    }

    public Insets getInsets() {
        Insets insets = (Insets)super.getInsets().clone();
        insets.top += 5;
        insets.left += 8;
        insets.right += 8;
        return insets;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_tfName.setBackground(SystemColor.window);
    }

    public void dispose() {
        this.m_list.dispose();
        this.cleanUp();
        super.dispose();
    }

    protected void resolved(ResolveEvent resolveEvent) {
        this.stObjectSelected(resolveEvent.getName(), resolveEvent.getResolved());
    }

    protected void resolveConflict(ResolveEvent resolveEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.m_statusBar.setStatus(this.m_resourceFile.getString("STATUS_MSG_AMBIGUITY"));
        this.m_originalName = resolveEvent.getName();
        this.m_listShown = true;
        this.m_listPanel.setVisible(true);
        this.pack();
        STObject[] sTObjectArray = resolveEvent.getResolvedList();
        STUser[] sTUserArray = new STUser[sTObjectArray.length];
        for (int i = 0; i < sTUserArray.length; ++i) {
            sTUserArray[i] = (STUser)sTObjectArray[i];
        }
        this.m_list.addUsers(sTUserArray);
    }

    protected void resolveFailed(ResolveEvent resolveEvent) {
        this.resetNameField();
        String[] stringArray = resolveEvent.getFailedNames();
        Debug.stAssert(stringArray.length == 1);
        String string = stringArray[0];
        String string2 = resolveEvent.getReason() == -2147483645 ? this.m_resourceFile.getString("NOT_AUTHORIZED") : this.m_resourceFile.formatString("STATUS_MSG_NOT_ADDED", string);
        this.m_statusBar.setStatus(string2);
        ResolveViewEvent resolveViewEvent = new ResolveViewEvent((Object)this, string, resolveEvent.getReason());
        this.sendEvent(resolveViewEvent);
    }

    protected void stObjectSelected(String string, STObject sTObject) {
        if (string == null) {
            string = this.m_originalName;
        }
        if (sTObject instanceof STUser) {
            this.m_statusBar.setStatus(this.m_resourceFile.formatString("STATUS_MSG_ADDED", sTObject.getName()));
            this.m_list.reset();
            this.resetNameField();
            ResolveViewEvent resolveViewEvent = new ResolveViewEvent((Object)this, string, (STUser)sTObject);
            this.sendEvent(resolveViewEvent);
        } else if (sTObject instanceof STGroup) {
            GroupContentGetter groupContentGetter = this.m_lookupService.createGroupContentGetter();
            groupContentGetter.addGroupContentListener(this.m_groupContentListener);
            groupContentGetter.queryGroupContent((STGroup)sTObject);
        }
        if (this.isVisible()) {
            this.m_tfName.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.m_addBtnLabel)) {
            this.addClicked();
        } else if (string.equals(this.m_closeBtnLabel)) {
            this.dispose();
        } else if (string.equals(this.m_dirBtnLabel)) {
            this.openDirectoryDialog();
        }
    }

    protected void keyPressed(KeyEvent keyEvent) {
        this.m_btnAdd.setEnabled(!this.m_tfName.getText().equals(""));
    }

    protected void keyReleased(KeyEvent keyEvent) {
        this.m_btnAdd.setEnabled(!this.m_tfName.getText().equals(""));
    }

    protected void groupContentQueried(GroupContentEvent groupContentEvent) {
        STObject[] sTObjectArray = groupContentEvent.getGroupContent();
        for (int i = 0; i < sTObjectArray.length; ++i) {
            if (!(sTObjectArray[i] instanceof STUser)) continue;
            this.stObjectSelected(null, sTObjectArray[i]);
        }
        ((GroupContentGetter)groupContentEvent.getSource()).removeGroupContentListener(this.m_groupContentListener);
    }

    protected void addClicked() {
        if (this.m_communityChoice.getSelectedItem() == this.m_resourceFile.getString("CHOICE_EXTERNAL")) {
            STId sTId = new STId(this.m_tfName.getText(), "");
            STUser sTUser = new STUser(sTId, this.m_tfName.getText(), "");
            sTUser.setExternalUser();
            this.stObjectSelected(this.m_tfName.getText(), sTUser);
            return;
        }
        if (!this.m_listShown) {
            this.resolve();
        } else {
            STWatchedUser[] sTWatchedUserArray = this.m_list.getSelectedItems();
            if (sTWatchedUserArray == null || sTWatchedUserArray.length != 1) {
                return;
            }
            this.stObjectSelected(this.m_originalName, sTWatchedUserArray[0]);
        }
    }

    protected void openDirectoryDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.m_parentFrame, this.m_session, this);
        if (this.m_dirTitle != null) {
            directoryDialog.setTitle(this.m_dirTitle);
        }
        directoryDialog.setVisible(true);
        this.setVisible(false);
    }

    protected void resolve() {
        String string = this.m_tfName.getText();
        if (string == null || string.equals("")) {
            return;
        }
        this.m_list.reset();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_resolver.resolve(string);
    }

    protected void resetNameField() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.m_tfName.setText("");
        this.m_btnAdd.setEnabled(false);
        if (this.isVisible()) {
            this.m_tfName.requestFocus();
        }
    }

    protected void enableDirButton() {
        boolean bl = this.m_btnAdd.isEnabled();
        this.m_southPanel.removeAll();
        this.m_southPanel.add(this.m_fullBtnPnl);
        this.m_southPanel.add(this.m_statusBar);
        this.setSize(this.getPreferredSize());
        this.validate();
        this.m_statusBar.repaint();
        this.m_btnAdd = this.m_fullBtnPnl.getButton(this.m_addBtnLabel);
        this.m_btnClose = this.m_fullBtnPnl.getButton(this.m_closeBtnLabel);
        this.m_btnDir = this.m_fullBtnPnl.getButton(this.m_dirBtnLabel);
        this.m_btnAdd.setEnabled(bl);
    }

    protected void disableDirButton() {
        boolean bl = this.m_btnAdd.isEnabled();
        this.m_southPanel.removeAll();
        this.m_southPanel.add(this.m_btnPnl);
        this.m_southPanel.add(this.m_statusBar);
        this.validate();
        this.m_btnAdd = this.m_btnPnl.getButton(this.m_addBtnLabel);
        this.m_btnClose = this.m_btnPnl.getButton(this.m_closeBtnLabel);
        this.m_btnAdd.setEnabled(bl);
    }

    protected void attrChanged(AttributeEvent attributeEvent) {
        if (this.m_browsingEnabled) {
            STExtendedAttribute[] sTExtendedAttributeArray = attributeEvent.getAttributeList();
            for (int i = 0; i < sTExtendedAttributeArray.length; ++i) {
                if (sTExtendedAttributeArray[i].getKey() == 9004) {
                    this.enableDirButton();
                }
                if (!this.m_addAlsoExternal || sTExtendedAttributeArray[i].getKey() != 9015) continue;
                this.m_sipGatewayEnabled = true;
                String string = this.m_tfName.getText();
                this.removeAll();
                this.hide();
                this.initUI();
                this.m_tfName.setText(string);
                this.show();
            }
        }
    }

    protected void attrRemoved(AttributeEvent attributeEvent) {
        if (attributeEvent.getAttributeKey() == 9004 || this.m_browsingEnabled) {
            this.disableDirButton();
        }
    }

    protected void selectionChanged(AwarenessViewEvent awarenessViewEvent) {
        this.m_btnAdd.setEnabled(awarenessViewEvent.getUsers().length != 0);
    }

    protected void cleanUp() {
        this.m_tfName.removeKeyListener(this.m_keyListener);
        this.m_fullBtnPnl.removeAll();
        this.m_btnPnl.removeAll();
        this.m_list.removeAwarenessViewListener(this.m_awarenessViewListener);
        this.m_resolver.removeResolveListener(this.m_resolveListener);
        this.m_watchList.removeAttrListener(this.m_attributeListener);
        this.m_watchList.close();
        this.m_listeners.removeAllElements();
    }

    public void addResolveViewListener(ResolveViewListener resolveViewListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(resolveViewListener);
        this.m_listeners = vector;
    }

    public void removeResolveViewListener(ResolveViewListener resolveViewListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(resolveViewListener);
        this.m_listeners = vector;
    }

    protected void sendEvent(ResolveViewEvent resolveViewEvent) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ResolveViewListener resolveViewListener = (ResolveViewListener)enumeration.nextElement();
            switch (resolveViewEvent.getId()) {
                case 2: {
                    resolveViewListener.resolveFailed(resolveViewEvent);
                    break;
                }
                case 1: {
                    resolveViewListener.resolved(resolveViewEvent);
                }
            }
        }
    }

    protected void loggedIn(LoginEvent loginEvent) {
        STServer sTServer = loginEvent.getLogin().getServer();
        this.m_watchList.reset();
        this.m_watchList.addItem(sTServer);
        this.setEnabled(true);
    }

    protected void loggedOut(LoginEvent loginEvent) {
        this.setEnabled(false);
    }

    protected void createListeners() {
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDialog.this.actionPerformed(actionEvent);
            }
        };
        this.m_keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                AddDialog.this.keyReleased(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                AddDialog.this.keyPressed(keyEvent);
            }
        };
        this.m_resolveListener = new ResolveListener(){

            public void resolved(ResolveEvent resolveEvent) {
                AddDialog.this.resolved(resolveEvent);
            }

            public void resolveConflict(ResolveEvent resolveEvent) {
                AddDialog.this.resolveConflict(resolveEvent);
            }

            public void resolveFailed(ResolveEvent resolveEvent) {
                AddDialog.this.resolveFailed(resolveEvent);
            }
        };
        this.m_resolveListListener = new ResolveListListener(){

            public void stObjectSelected(String string, STObject sTObject) {
                AddDialog.this.stObjectSelected(string, sTObject);
            }
        };
        this.m_awarenessViewListener = new AwarenessViewAdapter(){

            public void selectionChanged(AwarenessViewEvent awarenessViewEvent) {
                AddDialog.this.selectionChanged(awarenessViewEvent);
            }
        };
        this.m_attributeListener = new AttributeAdapter(){

            public void attrChanged(AttributeEvent attributeEvent) {
                AddDialog.this.attrChanged(attributeEvent);
            }

            public void attrRemoved(AttributeEvent attributeEvent) {
                AddDialog.this.attrRemoved(attributeEvent);
            }
        };
        this.m_groupContentListener = new GroupContentAdapter(){

            public void groupContentQueried(GroupContentEvent groupContentEvent) {
                AddDialog.this.groupContentQueried(groupContentEvent);
            }
        };
        this.m_loginListener = new LoginListener(){

            public void loggedIn(LoginEvent loginEvent) {
                AddDialog.this.loggedIn(loginEvent);
            }

            public void loggedOut(LoginEvent loginEvent) {
                AddDialog.this.loggedOut(loginEvent);
            }
        };
    }

    public void setEnabled(boolean bl) {
        this.m_tfName.setEnabled(bl);
        this.m_btnAdd.setEnabled(bl && this.m_tfName.getText().length() > 0);
        if (null != this.m_btnDir) {
            this.m_btnDir.setEnabled(bl);
        }
        this.m_listPanel.setEnabled(bl);
    }

    protected boolean isWatsonServer(STSession sTSession) {
        CommunityService communityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        int n = communityService.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        return s > 30 || s == 30 && s2 >= 25;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_communityChoice) {
            if (this.m_communityChoice.getSelectedItem() == this.m_resourceFile.getString("CHOICE_EXTERNAL")) {
                this.m_addToPrivacyLabel.setText(this.m_resourceFile.getString("LBL_ADD_TO_PRIVACY_LIST_EXTERNAL_USER"));
                this.m_userNameLbl.setText("Email");
                this.m_btnDir.setEnabled(false);
                this.m_tfName.requestFocus();
            } else if (this.m_communityChoice.getSelectedItem() == this.m_resourceFile.getString("CHOICE_SAMETIME")) {
                this.m_addToPrivacyLabel.setText(this.m_resourceFile.getString("LBL_ADD_TO_PRIVACY_LIST"));
                this.m_userNameLbl.setText(this.m_resourceFile.getString("LBL_NAME"));
                this.m_btnDir.setEnabled(true);
                this.m_tfName.requestFocus();
            }
        }
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                AddDialog.this.addClicked();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                AddDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_ADD"))){

            public void executeKeyMethod() {
                AddDialog.this.addClicked();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_DIRECTORY"))){

            public void executeKeyMethod() {
                AddDialog.this.openDirectoryDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
                AddDialog.this.dispose();
            }
        });
        return new KeyHandler(vector);
    }
}

