/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.invitation;

import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.invitation.Invitation;
import com.lotus.sametime.chatui.invitation.InvitationListener;
import com.lotus.sametime.chatui.invitation.Inviter;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.conf.ConfAdapter;
import com.lotus.sametime.conf.ConfInfo;
import com.lotus.sametime.conf.ConfService;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STEventListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImAdapter;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImServiceListener;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.post.Post;
import com.lotus.sametime.post.PostEvent;
import com.lotus.sametime.post.PostService;
import com.lotus.sametime.post.PostServiceListener;
import java.io.IOException;
import java.util.StringTokenizer;

public class InvitationManager
implements PostServiceListener,
ImServiceListener,
LoginListener,
STEventListener {
    static final int POST_TYPE = 25;
    static final int POST_DATA_TYPE = 0;
    static final int SHARE_DATA_TYPE = 2;
    static final int SHARE_DATA_SUBTYPE = 0;
    private PostService m_postService;
    private ConfService m_confService;
    private CommunityService m_community;
    InstantMessagingService m_imService;
    private STUser m_loggedInUser;
    private InvitationListener m_listener;

    public InvitationManager(STSession sTSession) {
        sTSession.getDispatcher().addSTEventListener(this);
        this.m_postService = (PostService)sTSession.getCompApi("com.lotus.sametime.post.PostComp");
        this.m_confService = (ConfService)sTSession.getCompApi("com.lotus.sametime.conf.ConfComp");
        if (this.m_postService != null) {
            this.m_postService.registerPostType(25);
            this.m_postService.addPostServiceListener(this);
        }
        if (this.m_confService != null) {
            this.addConfListener();
        }
        this.m_community = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_community) {
            this.addCommunityListener();
        }
        this.m_imService = (InstantMessagingService)sTSession.getCompApi("com.lotus.sametime.im.ImComp");
        if (null != this.m_imService) {
            this.m_imService.addImServiceListener(this);
            this.m_imService.registerImType(3);
        }
    }

    public void setListener(InvitationListener invitationListener) {
        this.m_listener = invitationListener;
    }

    public Inviter createInviter() {
        return new Inviter(this.m_postService);
    }

    public void posted(PostEvent postEvent) {
        Object object;
        String string;
        String string2;
        String string3;
        boolean bl;
        boolean bl2;
        MeetingInfo meetingInfo;
        Post post = postEvent.getPost();
        if (post.getDetailsType() != 0) {
            return;
        }
        STUser sTUser = post.getSenderDetails();
        if (sTUser.equals(this.m_loggedInUser)) {
            return;
        }
        NdrInputStream ndrInputStream = new NdrInputStream(post.getDetails());
        int n = 0;
        String string4 = "";
        try {
            ndrInputStream.loadMark();
            meetingInfo = new MeetingInfo(ndrInputStream);
            bl2 = ndrInputStream.readBoolean();
            bl = ndrInputStream.readBoolean();
            string3 = ndrInputStream.readUTF();
            string2 = ndrInputStream.readUTF();
            string = ndrInputStream.readUTF();
            if (ndrInputStream.available() != 0) {
                n = ndrInputStream.readInt();
            }
            if (ndrInputStream.available() != 0) {
                string4 = ndrInputStream.readUTF();
            }
            ndrInputStream.skipMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (bl) {
            object = new STId(string2, string);
            STUser sTUser2 = new STUser((STId)object, string3, "");
            sTUser = sTUser2;
        }
        meetingInfo.setDisplayName(post.getTitle());
        meetingInfo.setSSLPort(n);
        meetingInfo.setURL(string4);
        object = new Invitation(post, 2, sTUser, meetingInfo, post.getMessage());
        this.m_listener.invitedToMeeting((Invitation)object, bl2);
    }

    public void invitedToConference(Integer n, ConfInfo confInfo, STUserInstance sTUserInstance, EncLevel encLevel, boolean bl, String string) {
        if (sTUserInstance.equals(this.m_loggedInUser)) {
            return;
        }
        MeetingInfo meetingInfo = new MeetingInfo(MeetingTypes.ST_CHAT_MEETING, confInfo.getName(), confInfo.getDisplayName(), encLevel, sTUserInstance.getId().getCommunityName(), n);
        Invitation invitation = new Invitation(null, 1, sTUserInstance, meetingInfo, string);
        this.m_listener.invitedToMeeting(invitation, bl);
    }

    private void dataReceived(ImEvent imEvent) {
        boolean bl;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        if (imEvent.getDataType() != 2 || imEvent.getDataSubType() != 0) {
            return;
        }
        NdrInputStream ndrInputStream = new NdrInputStream(imEvent.getData());
        try {
            string5 = ndrInputStream.readUTF();
            string4 = ndrInputStream.readUTF();
            ndrInputStream.readInt();
            string3 = ndrInputStream.readUTF();
            string2 = ndrInputStream.readUTF();
            string = ndrInputStream.readUTF();
            bl = ndrInputStream.readBoolean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        EncLevel encLevel = bl ? EncLevel.ENC_LEVEL_RC2_40 : EncLevel.ENC_LEVEL_NONE;
        String string6 = this.getServerNameFromHandle(string4);
        int n = this.getMeetingIdFromHandle(string4);
        STUser sTUser = new STUser(new STId(string2, ""), string3, "");
        MeetingInfo meetingInfo = new MeetingInfo(MeetingTypes.ST_SHARE_MEETING, string5, string5, encLevel, string6, new Integer(n));
        Invitation invitation = new Invitation(null, 3, sTUser, meetingInfo, string);
        this.m_listener.invitedToMeeting(invitation, false);
    }

    public void loggedIn(LoginEvent loginEvent) {
        STUserInstance sTUserInstance = this.m_community.getLogin().getMyUserInstance();
        this.m_loggedInUser = sTUserInstance;
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_loggedInUser = null;
    }

    public void imReceived(ImEvent imEvent) {
        Im im = imEvent.getIm();
        if (im.getType() != 3) {
            return;
        }
        im.addImListener(new ImAdapter(){

            public void dataReceived(ImEvent imEvent) {
                InvitationManager.this.dataReceived(imEvent);
            }
        });
    }

    protected void addConfListener() {
        this.m_confService.addConfListener(new ConfAdapter(){

            public void invitedToConference(Integer n, ConfInfo confInfo, STUserInstance sTUserInstance, EncLevel encLevel, boolean bl, String string) {
                InvitationManager.this.invitedToConference(n, confInfo, sTUserInstance, encLevel, bl, string);
            }
        });
    }

    private void addCommunityListener() {
        this.m_community.addLoginListener(this);
        Login login = this.m_community.getLogin();
        if (null != login) {
            this.m_loggedInUser = login.getMyUserInstance();
        }
    }

    private String getServerNameFromHandle(String string) {
        int n = string.indexOf(",") + 1;
        int n2 = string.indexOf(",", n);
        return string.substring(n, n2);
    }

    private int getMeetingIdFromHandle(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 4) {
            return -1;
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_confService && sTCompApi instanceof ConfService) {
            this.m_confService = (ConfService)sTCompApi;
            this.addConfListener();
        }
        if (null == this.m_community && sTCompApi instanceof CommunityService) {
            this.m_community = (CommunityService)sTCompApi;
            this.addCommunityListener();
        }
        if (null == this.m_imService && sTCompApi instanceof InstantMessagingService) {
            this.m_imService = (InstantMessagingService)sTCompApi;
            this.m_imService.addImServiceListener(this);
        }
    }

    public void processSTEvent(STEvent sTEvent) {
    }
}

