/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.ChatFrame;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.TextPanel;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class EscWarningOnCloseChat
extends Dialog {
    private static final short DIALOG_WIDTH = 375;
    private static final short DIALOG_HEIGHT = 80;
    private static final short VERT_GAP = 10;
    private static final short INSETS = 15;
    private ButtonsPanel m_btnPannel;
    private STBundle m_resourceFile;
    private ChatFrame m_chatFrame;

    public EscWarningOnCloseChat(boolean bl, ChatFrame chatFrame) {
        super(new Frame(), bl);
        this.m_chatFrame = chatFrame;
        this.m_resourceFile = this.m_chatFrame.getResourceFile();
        this.intializeLayout();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EscWarningOnCloseChat.this.setVisible(false);
            }
        });
    }

    private void intializeLayout() {
        try {
            this.setLayout(new BorderLayout(0, 10));
            this.setTitle(this.m_resourceFile.getString("ESC_WARNING_TITLE"));
            this.setResizable(false);
            TextPanel textPanel = new TextPanel(new String[]{this.m_resourceFile.getString("ESC_WARNING_TEXT")});
            this.add("Center", textPanel);
            this.m_btnPannel = new ButtonsPanel(new String[]{this.m_resourceFile.getString("BTN_LBL_YES"), this.m_resourceFile.getString("BTN_LBL_NO")}, new CloseChatWarningEventHandler(), 1);
            this.add("South", this.m_btnPannel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            int n;
            int n2;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle = this.m_chatFrame.getBounds();
            Point point = this.m_chatFrame.getLocationOnScreen();
            Rectangle rectangle2 = this.getBounds();
            if (point.x < dimension.width / 2) {
                n2 = point.x + rectangle.width;
                n = point.y;
                if (n2 + rectangle2.width > dimension.width) {
                    n2 = dimension.width - rectangle2.width;
                }
                if (n + rectangle2.height > dimension.height) {
                    n = dimension.height - rectangle2.height;
                }
            } else {
                n2 = point.x - rectangle2.width;
                n = point.y;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n + rectangle2.height > dimension.height) {
                    n = dimension.height - rectangle2.height;
                }
            }
            this.setLocation(n2, n);
        }
        super.setVisible(bl);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(7 + insets.top, 15, insets.bottom + 7, 15);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(dimension.width, 375), Math.max(dimension.height, 80));
    }

    private class CloseChatWarningEventHandler
    implements ActionListener {
        private CloseChatWarningEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EscWarningOnCloseChat.this.m_btnPannel.getButton(EscWarningOnCloseChat.this.m_resourceFile.getString("BTN_LBL_YES"))) {
                EscWarningOnCloseChat.this.m_chatFrame.closeChat();
            }
            EscWarningOnCloseChat.this.setVisible(false);
        }
    }
}

