/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.av;

import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awarenessui.av.AVController;
import com.lotus.sametime.awarenessui.list.AwarenessList;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.ContentProvider;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Image;
import java.util.Hashtable;

public class CapabilitiesList
extends AwarenessList
implements ContentProvider {
    private ResourceLoaderService m_loader;
    private STBundle m_res;
    private ColumnAttributes m_micColumn;
    private ColumnAttributes m_speakerColumn;
    private ColumnAttributes m_cameraColumn;

    public CapabilitiesList(STSession sTSession, boolean bl) {
        super(sTSession, bl, null);
        this.m_loader = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_res = this.m_loader.getBundle("properties/awarenessui");
        this.addColumns();
        AwarenessService awarenessService = (AwarenessService)sTSession.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        int[] nArray = new int[]{1, 2, 3, 4};
        awarenessService.addToAttrFilter(nArray);
        this.setController(new AVController(this.m_model));
    }

    private void addColumns() {
        int[] nArray = new int[]{1, 2};
        this.m_micColumn = new ColumnAttributes(nArray, 1, this);
        this.m_micColumn.setTooltipText(this.m_res.getString("TOOLTIP_MIC_COL"));
        this.addColumn(this.m_micColumn);
        int[] nArray2 = new int[]{1, 3};
        this.m_speakerColumn = new ColumnAttributes(nArray2, 2, this);
        this.m_speakerColumn.setTooltipText(this.m_res.getString("TOOLTIP_SPEAKER_COL"));
        this.addColumn(this.m_speakerColumn);
        int[] nArray3 = new int[]{1, 4};
        this.m_cameraColumn = new ColumnAttributes(nArray3, 3, this);
        this.m_cameraColumn.setTooltipText(this.m_res.getString("TOOLTIP_CAMERA_COL"));
        this.addColumn(this.m_cameraColumn);
        this.setTooltipForNameColumn(this.m_res.getString("TOOLTIP_NAME_COL"));
        CellData cellData = new CellData(this.m_res.getString("TITLE_NAME_COL"));
        this.setNameColData(cellData);
    }

    public CellData getColumnHeader(ColumnAttributes columnAttributes) {
        CellData cellData = null;
        if (columnAttributes == this.m_micColumn) {
            Image image = this.m_loader.getImage("images/mike.gif");
            cellData = new CellData(image);
        } else if (columnAttributes == this.m_speakerColumn) {
            Image image = this.m_loader.getImage("images/speaker.gif");
            cellData = new CellData(image);
        } else if (columnAttributes == this.m_cameraColumn) {
            Image image = this.m_loader.getImage("images/video.gif");
            cellData = new CellData(image);
        }
        return cellData;
    }

    public CellData getContent(ColumnAttributes columnAttributes, Hashtable hashtable) {
        CellData cellData = null;
        Object v = hashtable.get(new Integer(1));
        boolean bl = false;
        boolean bl2 = false;
        if (null != v) {
            bl = true;
            if (columnAttributes == this.m_micColumn) {
                bl2 = null != hashtable.get(new Integer(2));
            } else if (columnAttributes == this.m_speakerColumn) {
                bl2 = null != hashtable.get(new Integer(3));
            } else if (columnAttributes == this.m_cameraColumn) {
                bl2 = null != hashtable.get(new Integer(4));
            }
            Image image = bl2 ? this.m_loader.getImage("images/check.gif") : this.m_loader.getImage("images/x.gif");
            cellData = new CellData(image);
        } else {
            cellData = this.getEmptyContent(columnAttributes);
        }
        return cellData;
    }

    public CellData getEmptyContent(ColumnAttributes columnAttributes) {
        return new CellData(this.m_loader.getImage("images/question.gif"), 1);
    }
}

