/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.UnitSpan;

public final class CoordPair {
    public static final CoordPair ZERO_ZERO = new CoordPair();
    private final UnitSpan mX;
    private final UnitSpan mY;

    public CoordPair() {
        this.mX = UnitSpan.ZERO;
        this.mY = UnitSpan.ZERO;
    }

    public CoordPair(CoordPair source) {
        this.mX = source.x();
        this.mY = source.y();
    }

    public CoordPair(UnitSpan x, UnitSpan y) {
        this.mX = x;
        this.mY = y;
    }

    public CoordPair grid(CoordPair grid) {
        return new CoordPair(this.mX.grid(grid.x()), this.mY.grid(grid.y()));
    }

    public CoordPair round(CoordPair round) {
        return new CoordPair(this.mX.round(round.x()), this.mY.round(round.y()));
    }

    public UnitSpan x() {
        return this.mX;
    }

    public UnitSpan y() {
        return this.mY;
    }

    public CoordPair rotatePoint(CoordPair oRPoint, Angle oAngle) {
        int degrees = oAngle.degrees();
        if (degrees == 0) {
            return this;
        }
        UnitSpan oTX = new UnitSpan(3, this.mX.units(), this.mX.value());
        UnitSpan oTY = new UnitSpan(3, this.mY.units(), this.mY.value());
        UnitSpan oRPX = new UnitSpan(3, oRPoint.x().units(), oRPoint.x().value());
        UnitSpan oRPY = new UnitSpan(3, oRPoint.y().units(), oRPoint.y().value());
        int lX = oTX.value();
        int lY = -oTY.value();
        int lXR = oRPX.value();
        int lYR = -oRPY.value();
        switch (degrees) {
            case 90: {
                oTX = new UnitSpan(3, lXR - (lY - lYR));
                oTY = new UnitSpan(3, -(lYR + (lX - lXR)));
                break;
            }
            case 180: {
                oTX = new UnitSpan(3, lXR - (lX - lXR));
                oTY = new UnitSpan(3, -(lYR - (lY - lYR)));
                break;
            }
            case 270: {
                oTX = new UnitSpan(3, lXR + (lY - lYR));
                oTY = new UnitSpan(3, -(lYR - (lX - lXR)));
                break;
            }
            default: {
                double dRadians = (double)oAngle.degrees() * (Math.PI / 180);
                double dCosAngle = Math.cos(dRadians);
                double dSinAngle = Math.sin(dRadians);
                oTX = new UnitSpan(3, (int)Math.round((double)lXR + (double)(lX - lXR) * dCosAngle - (double)(lY - lYR) * dSinAngle));
                oTY = new UnitSpan(3, (int)(-Math.round((double)lYR + (double)(lY - lYR) * dCosAngle + (double)(lX - lXR) * dSinAngle)));
            }
        }
        return new CoordPair(oTX, oTY);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        CoordPair cmp = (CoordPair)object;
        return this.mX.equals(cmp.mX) && this.mY.equals(cmp.mY);
    }

    public int hashCode() {
        int hash = 11;
        hash = hash * 31 ^ this.mX.hashCode();
        hash = hash * 31 ^ this.mY.hashCode();
        return hash;
    }

    public boolean notEquals(Object compare) {
        return !this.equals(compare);
    }

    public CoordPair add(CoordPair add) {
        return new CoordPair(this.mX.add(add.mX), this.mY.add(add.mY));
    }

    public CoordPair subtract(CoordPair subtract) {
        return new CoordPair(this.mX.subtract(subtract.mX), this.mY.subtract(subtract.mY));
    }

    public CoordPair scale(double dXScale, double dYScale) {
        return new CoordPair(this.mX.multiply(dXScale), this.mY.multiply(dYScale));
    }

    public boolean gt(CoordPair compare) {
        if (this.mY.gt(compare.mY)) {
            return true;
        }
        if (this.mY.lt(compare.mY)) {
            return false;
        }
        return this.mX.gt(compare.mX);
    }

    public boolean lt(CoordPair compare) {
        if (this.mY.lt(compare.mY)) {
            return true;
        }
        if (this.mY.gt(compare.mY)) {
            return false;
        }
        return this.mX.lt(compare.mX);
    }

    public static CoordPair zeroZero() {
        return ZERO_ZERO;
    }
}

