/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import java.util.HashMap;
import java.util.Map;

public abstract class MarkupAttr {
    public static final int MARKUP_UNKNOWN = 0;
    public static final int MARKUP_NOT_SUPPORTED = 1;
    public static final int MARKUP_ALL = 2;
    public static final int MARKUP_AUTO = 3;
    public static final int MARKUP_NONE = 4;
    public static final int MARKUP_NORMAL = 5;
    public static final int MARKUP_SOLID = 6;
    public static final int MARKUP_STYLESHEET = 7;
    public static final int MARKUP_INFO = 8;
    public static final int MARKUP_HEADER = 9;
    public static final int MARKUP_HEADER_LEFT = 10;
    public static final int MARKUP_HEADER_RIGHT = 11;
    public static final int MARKUP_HEADER_FIRST = 12;
    public static final int MARKUP_FOOTER = 13;
    public static final int MARKUP_FOOTER_LEFT = 14;
    public static final int MARKUP_FOOTER_RIGHT = 15;
    public static final int MARKUP_FOOTER_FIRST = 16;
    public static final int MARKUP_CODE_PAGE = 17;
    public static final int MARKUP_PARAGRAPH_START = 18;
    public static final int MARKUP_PARAGRAPH_END = 19;
    public static final int MARKUP_PARAGRAPH_DEFAULT = 20;
    public static final int MARKUP_PARAGRAPH_PLAIN = 21;
    public static final int MARKUP_BREAK = 22;
    public static final int MARKUP_PICTURE = 23;
    public static final int MARKUP_HEX_CHARACTER = 24;
    public static final int MARKUP_UNICODE_CHARACTER = 25;
    public static final int MARKUP_UC_COUNT = 26;
    public static final int MARKUP_DESTINATION_GROUP = 27;
    public static final int MARKUP_ENDASH = 28;
    public static final int MARKUP_EMDASH = 29;
    public static final int MARKUP_ENSPACE = 30;
    public static final int MARKUP_EMSPACE = 31;
    public static final int MARKUP_BULLET = 32;
    public static final int MARKUP_LQUOTE = 33;
    public static final int MARKUP_RQUOTE = 34;
    public static final int MARKUP_LDBLQUOTE = 35;
    public static final int MARKUP_RDBLQUOTE = 36;
    public static final int MARKUP_LINE = 37;
    public static final int MARKUP_SPAN = 38;
    public static final int MARKUP_SPAN_END = 39;
    public static final int MARKUP_ANCHOR = 40;
    public static final int MARKUP_STYLE = 41;
    public static final int MARKUP_EMBED = 42;
    public static final int MARKUP_EMBEDMODE = 43;
    public static final int MARKUP_EMBEDTYPE = 44;
    public static final int MARKUP_ROOT = 45;
    public static final int MARKUP_BODY = 46;
    public static final int MARKUP_HTML = 47;
    public static final int MARKUP_BODY_END = 48;
    public static final int MARKUP_HTML_END = 49;
    public static final int MARKUP_SPACE_RUN = 50;
    public static final int MARKUP_SPACE_RUN_YES = 51;
    public static final int MARKUP_SPACE_RUN_NO = 52;
    public static final int MARKUP_LINE_HEIGHT = 53;
    public static final int MARKUP_CHAR_SPACING = 54;
    public static final int MARKUP_WORD_SPACING = 55;
    public static final int MARKUP_LEADING = 56;
    public static final int MARKUP_INDENT_FIRST_LINE = 57;
    public static final int MARKUP_INDENT_LEFT = 58;
    public static final int MARKUP_INDENT_RIGHT = 59;
    public static final int MARKUP_OUTDENT = 60;
    public static final int MARKUP_SPACE_BEFORE = 61;
    public static final int MARKUP_SPACE_AFTER = 62;
    public static final int MARKUP_LINE_SPACE = 63;
    public static final int MARKUP_MARGIN = 64;
    public static final int MARKUP_FONT_NAME = 65;
    public static final int MARKUP_FONT_SIZE = 66;
    public static final int MARKUP_FONT_WEIGHT = 67;
    public static final int MARKUP_FONT_STYLE = 68;
    public static final int MARKUP_FONT = 69;
    public static final int MARKUP_FONT_BOLD = 70;
    public static final int MARKUP_FONT_ITALIC = 71;
    public static final int MARKUP_FONT_HORIZONTAL_SCALE = 72;
    public static final int MARKUP_FONT_VERTICAL_SCALE = 73;
    public static final int MARKUP_DEFAULT_FONT = 74;
    public static final int MARKUP_COLOUR = 75;
    public static final int MARKUP_CHARSET = 76;
    public static final int MARKUP_BOLD = 77;
    public static final int MARKUP_BOLD_END = 78;
    public static final int MARKUP_ITALIC = 79;
    public static final int MARKUP_ITALIC_END = 80;
    public static final int MARKUP_STRIKEOUT = 81;
    public static final int MARKUP_STRIKEOUT_DOUBLE = 82;
    public static final int MARKUP_STRIKEOUT_END = 83;
    public static final int MARKUP_COLOUR_TABLE = 84;
    public static final int MARKUP_UNDERLINE = 85;
    public static final int MARKUP_UNDERLINE_DOUBLE = 86;
    public static final int MARKUP_UNDERLINE_WORD = 87;
    public static final int MARKUP_UNDERLINE_WORD_DOUBLE = 88;
    public static final int MARKUP_UNDERLINE_ALL = 89;
    public static final int MARKUP_UNDERLINE_END = 90;
    public static final int MARKUP_UNDERLINE_END2 = 91;
    public static final int MARKUP_UNDERLINE_TAG = 92;
    public static final int MARKUP_TEXT_UNDERLINE = 93;
    public static final int MARKUP_TEXT_UNDERLINE_STYLE = 94;
    public static final int MARKUP_TEXT_UNDERLINE_MODE = 95;
    public static final int MARKUP_UNDERLINE_DOTTED = 96;
    public static final int MARKUP_UNDERLINE_DASH = 97;
    public static final int MARKUP_UNDERLINE_DASH_DOT = 98;
    public static final int MARKUP_UNDERLINE_DASH_DOT_DOT = 99;
    public static final int MARKUP_UNDERLINE_HEAVY_WAVE = 100;
    public static final int MARKUP_UNDERLINE_LONG_DASH = 101;
    public static final int MARKUP_UNDERLINE_THICK = 102;
    public static final int MARKUP_UNDERLINE_THICK_DOT = 103;
    public static final int MARKUP_UNDERLINE_THICK_DASH = 104;
    public static final int MARKUP_UNDERLINE_THICK_DASH_DOT = 105;
    public static final int MARKUP_UNDERLINE_THICK_DASH_DOT_DOT = 106;
    public static final int MARKUP_UNDERLINE_THICK_LONG_DASH = 107;
    public static final int MARKUP_UNDERLINE_DOUBLE_WAVE = 108;
    public static final int MARKUP_UNDERLINE_WAVE = 109;
    public static final int MARKUP_TEXT_DECORATION = 110;
    public static final int MARKUP_BASELINE_SHIFT = 111;
    public static final int MARKUP_BASELINE = 112;
    public static final int MARKUP_SUPER = 113;
    public static final int MARKUP_SUPER_END = 114;
    public static final int MARKUP_SUB = 115;
    public static final int MARKUP_SUB_END = 116;
    public static final int MARKUP_DOWN = 117;
    public static final int MARKUP_UP = 118;
    public static final int MARKUP_JUSTIFY = 119;
    public static final int MARKUP_JUSTIFY_SPREAD = 120;
    public static final int MARKUP_JUSTIFY_SPREAD_ALL = 121;
    public static final int MARKUP_JUSTIFY_HORZ_LEFT = 122;
    public static final int MARKUP_JUSTIFY_HORZ_CENTER = 123;
    public static final int MARKUP_JUSTIFY_HORZ_RIGHT = 124;
    public static final int MARKUP_JUSTIFY_COMB_LEFT = 125;
    public static final int MARKUP_JUSTIFY_COMB_CENTER = 126;
    public static final int MARKUP_JUSTIFY_COMB_RIGHT = 127;
    public static final int MARKUP_TEXT_VALIGN = 128;
    public static final int MARKUP_TEXT_VALIGN_TOP = 129;
    public static final int MARKUP_TEXT_VALIGN_MIDDLE = 130;
    public static final int MARKUP_TEXT_VALIGN_BOTTOM = 131;
    public static final int MARKUP_JUSTIFY_VERT = 132;
    public static final int MARKUP_JUSTIFY_VERT_TOP = 133;
    public static final int MARKUP_JUSTIFY_VERT_CENTER = 134;
    public static final int MARKUP_JUSTIFY_VERT_BOTTOM = 135;
    public static final int MARKUP_TAB = 136;
    public static final int MARKUP_TAB_DEFAULT = 137;
    public static final int MARKUP_TAB_POSITION = 138;
    public static final int MARKUP_TAB_ALIGN_LEFT = 139;
    public static final int MARKUP_TAB_ALIGN_CENTER = 140;
    public static final int MARKUP_TAB_ALIGN_RIGHT = 141;
    public static final int MARKUP_TAB_ALIGN_DECIMAL = 142;
    public static final int MARKUP_TAB_COUNT = 143;
    public static final int MARKUP_CM = 144;
    public static final int MARKUP_PT = 145;
    public static final int MARKUP_INCHES = 146;
    public static final int MARKUP_MM = 147;
    public static final int MARKUP_STYLE_REF = 148;
    public static final int MARKUP_CHARACTER_STYLE = 149;
    public static final int MARKUP_STYLE_ADDITIVE = 150;
    public static final int MARKUP_STYLE_BASED_ON = 151;
    public static final int MARKUP_TABLE_ROW = 152;
    public static final int MARKUP_TABLE_CELL = 153;
    public static final int MARKUP_DIV = 154;
    public static final int MARKUP_DIV_END = 155;
    public static final int MARKUP_XHTML_LEFT = 156;
    public static final int MARKUP_XHTML_CENTER = 157;
    public static final int MARKUP_XHTML_RIGHT = 158;
    public static final int MARKUP_DIGITS = 159;
    public static final int MARKUP_DIGITS_DEFAULT = 160;
    public static final int MARKUP_DIGITS_ARABIC = 161;
    public static final int MARKUP_DIGITS_INDIC = 162;
    public static final int MARKUP_DIRECTION = 163;
    public static final int MARKUP_DIRECTION_NEUTRAL = 164;
    public static final int MARKUP_DIRECTION_LTR = 165;
    public static final int MARKUP_DIRECTION_RTL = 166;
    public static final int MARKUP_LIGATURE = 167;
    public static final int MARKUP_LIGATURE_MINIMUM = 168;
    public static final int MARKUP_LIGATURE_COMMON = 169;
    public static final int MARKUP_KERNING_MODE = 169;
    public static final int MARKUP_KERN_PAIR = 170;
    public static final int MARKUP_HYPHENATION = 171;
    public static final int MARKUP_HYPHENATION_LEVEL = 172;
    public static final int MARKUP_HYPHENATION_PREFERRED = 173;
    public static final int MARKUP_HYPHENATION_LENGTH = 174;
    public static final int MARKUP_HYPHENATION_ACRONYMS = 175;
    public static final int MARKUP_HYPHENATION_NAMES = 176;
    public static final int MARKUP_LEADER_ALIGN = 177;
    public static final int MARKUP_LEADER_ALIGN_PAGE = 178;
    public static final int MARKUP_LEADER_PATTERN = 179;
    public static final int MARKUP_LEADER_PATTERN_SPACE = 180;
    public static final int MARKUP_LEADER_PATTERN_RULE = 181;
    public static final int MARKUP_LEADER_PATTERN_DOTS = 182;
    public static final int MARKUP_LEADER_PATTERN_USE_CONTENT = 183;
    public static final int MARKUP_LEADER_PATTERN_USE_CONTENT2 = 184;
    public static final int MARKUP_LEADER_PATTERN_WIDTH = 185;
    public static final int MARKUP_RULE_STYLE = 186;
    public static final int MARKUP_RULE_STYLE_DOTTED = 187;
    public static final int MARKUP_RULE_STYLE_DASHED = 188;
    public static final int MARKUP_RULE_THICKNESS = 189;
    public static final int MARKUP_ENUM_MAX = 189;
    protected final Map<Integer, String> moMarkupMap = new HashMap<Integer, String>();
    protected final Map<String, Integer> moTagMap = new HashMap<String, Integer>();

    public String lookup(int eTag) {
        String value = this.moMarkupMap.get(eTag);
        return value == null ? "" : value;
    }

    public int lookup(String oMarkup) {
        Integer value = this.moTagMap.get(oMarkup);
        return value == null ? 0 : value;
    }

    public int extractTag(StringBuilder oStrSource) {
        StringBuilder oStrTemp = new StringBuilder(oStrSource.toString());
        if (oStrTemp.charAt(0) == '\'') {
            oStrTemp.append('\'');
        } else {
            int last;
            char c;
            while (oStrTemp.length() > 0 && ((c = oStrTemp.charAt(last = oStrTemp.length() - 1)) < '0' || c > '9') && c != '-') {
                oStrTemp.deleteCharAt(last);
            }
        }
        int eTag = this.lookup(oStrTemp.toString());
        if (eTag != 0) {
            oStrSource.delete(0, oStrTemp.length());
        }
        return eTag;
    }

    public boolean hasBlockScoping() {
        return true;
    }

    public boolean hasParagraphAttr() {
        return true;
    }

    public abstract char blockPrefix();

    public abstract char blockSuffix();

    public abstract char commandPrefix();

    public abstract char delimiter();

    public abstract boolean isDelimiter(char var1);

    public char disablingChar() {
        return ' ';
    }

    public char enablingChar() {
        return ' ';
    }

    public int pointSizeFactor() {
        return 1;
    }

    public abstract boolean isValidMarkup(String var1);

    public String whiteSpace() {
        return " \t\r\n";
    }

    protected void setEntry(int eTag, String oStrMarkup, boolean bHasParameter) {
        this.setMarkupEntry(eTag, oStrMarkup);
        this.setTagEntry(oStrMarkup, eTag, bHasParameter);
    }

    protected void setEntry(int eTag, String oStrMarkup) {
        this.setEntry(eTag, oStrMarkup, false);
    }

    protected void setMarkupEntry(int eTag, String oStrMarkup) {
        this.moTagMap.remove(oStrMarkup);
        this.moTagMap.put(oStrMarkup, eTag);
    }

    protected void setTagEntry(String oStrMarkup, int eTag, boolean bHasParameter) {
        StringBuilder oStrMarkupEntry = new StringBuilder();
        char c = this.commandPrefix();
        if (c != '\u0000') {
            oStrMarkupEntry.append(c);
        }
        oStrMarkupEntry.append(oStrMarkup);
        if (!bHasParameter && (c = this.delimiter()) != '\u0000') {
            oStrMarkupEntry.append(c);
        }
        this.setStringEntry(eTag, oStrMarkupEntry.toString());
    }

    protected void setCharEntry(int eTag, char cMarkup) {
        String sStrMarkup = "";
        sStrMarkup = sStrMarkup + cMarkup;
        this.setMarkupEntry(eTag, sStrMarkup);
        this.setStringEntry(eTag, sStrMarkup);
    }

    protected void setStringEntry(int eTag, String sStrMarkup) {
        this.setMarkupEntry(eTag, sStrMarkup);
        Integer tag = eTag;
        this.moMarkupMap.remove(tag);
        this.moMarkupMap.put(tag, sStrMarkup);
    }
}

