/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispEmbed;
import com.adobe.xfa.text.DispMap;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.Glyph;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.ut.Storage;

class DispMapSet {
    int[] mpcCharData;
    int[] mpeBreakData;
    int mnCharCount;
    int mnCharMax;
    DispMap moEmbedMap = new DispMap();
    DispMap moGlyphLocMap = new DispMap();
    DispMap moPosnMap = new DispMap();
    DispMap moRunMap = new DispMap();
    Storage<Glyph> moGlyphs;

    DispMapSet() {
    }

    void clear() {
        this.mnCharCount = 0;
        this.moEmbedMap.empty();
        this.moGlyphLocMap.empty();
        this.moPosnMap.empty();
        this.moRunMap.empty();
        this.moGlyphs.clear();
    }

    int getChar(int nIndex) {
        return this.mpcCharData[nIndex];
    }

    int[] getCharArray() {
        return this.mpcCharData;
    }

    int getBreakData(int nIndex) {
        return this.mpeBreakData[nIndex];
    }

    int[] getBreakArray() {
        return this.mpeBreakData;
    }

    void addChar(int c, int eData) {
        this.setChar(this.mnCharCount++, c, eData);
    }

    void setChar(int nIndex, int c, int eData) {
        assert (nIndex < this.mnCharMax);
        this.mpcCharData[nIndex] = c;
        this.mpeBreakData[nIndex] = eData;
    }

    void setBreakData(int nIndex, int eData) {
        this.mpeBreakData[nIndex] = eData;
    }

    void preAllocChars(int nChars, boolean bPreserve) {
        if (nChars > this.mnCharMax) {
            int[] newChar = new int[nChars];
            int[] newBreak = new int[nChars];
            if (bPreserve) {
                for (int i = 0; i < this.mnCharCount; ++i) {
                    newChar[i] = this.mpcCharData[i];
                    newBreak[i] = this.mpeBreakData[i];
                }
            }
            this.mpcCharData = newChar;
            this.mpeBreakData = newBreak;
            this.mnCharMax = nChars;
        }
        this.mnCharCount = bPreserve ? nChars : 0;
    }

    void preAllocChars(int nChars) {
        this.preAllocChars(nChars, false);
    }

    Glyph getGlyph(int index) {
        return (Glyph)this.moGlyphs.get(index);
    }

    int getEmbedCount() {
        return this.moEmbedMap.size();
    }

    DispEmbed getEmbed(int index) {
        return (DispEmbed)this.moEmbedMap.getItem(index);
    }

    int getGlyphLocCount() {
        return this.moGlyphLocMap.size();
    }

    GlyphLoc getGlyphLoc(int index) {
        return (GlyphLoc)this.moGlyphLocMap.getItem(index);
    }

    void preAllocGlyphs(int nGlyphs, boolean bAllocGlyphLocs, boolean bPreserve) {
        if (this.moGlyphs == null) {
            this.moGlyphs = new Storage();
        }
        this.moGlyphs.ensureCapacity(nGlyphs);
        if (bAllocGlyphLocs) {
            this.moGlyphLocMap.preAlloc(nGlyphs, bPreserve);
        }
    }

    void preAllocGlyphs(int nGlyphs, boolean bAllocGlyphLocs) {
        this.preAllocGlyphs(nGlyphs, bAllocGlyphLocs, false);
    }

    int getPositionCount() {
        return this.moPosnMap.size();
    }

    DispPosn getPosition(int index) {
        return (DispPosn)this.moPosnMap.getItem(index);
    }

    int getRunCount() {
        return this.moRunMap.size();
    }

    DispRun getRun(int index) {
        return (DispRun)this.moRunMap.getItem(index);
    }
}

