/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.layout;

import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.layout.BoxModelContent;
import com.adobe.xfa.layout.BoxModelRenderProxy;
import com.adobe.xfa.layout.LayoutEnv;
import com.adobe.xfa.layout.LayoutHandler;
import com.adobe.xfa.template.TemplateResolver;
import com.adobe.xfa.template.containers.AreaContainer;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ContentArea;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.PageArea;
import com.adobe.xfa.template.containers.Rotate;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.formatting.Margin;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Margins;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.UnitSpan;
import java.util.List;

public class BoxModelLayout {
    protected Rect m_oNE = Rect.ZERO;
    protected boolean m_bGrowableH = false;
    protected boolean m_bGrowableW = false;
    protected boolean m_bInfiniteMaxH = false;
    protected boolean m_bInfiniteMaxW = false;
    protected UnitSpan m_oMinW = UnitSpan.ZERO;
    protected UnitSpan m_oMaxW = UnitSpan.ZERO;
    protected UnitSpan m_oMinH = UnitSpan.ZERO;
    protected UnitSpan m_oMaxH = UnitSpan.ZERO;
    protected Margins m_oNEMargins = new Margins();
    protected Margins m_oCapMargins = new Margins();
    protected Margins m_oContMargins = new Margins();
    protected Margins m_oBorderMargins = new Margins();
    protected Margins m_oContentBorderMargins = new Margins();
    protected UnitSpan m_oMaxEdgeThickness = UnitSpan.ZERO;
    protected CoordPair m_oAnchorPoint = CoordPair.ZERO_ZERO;
    protected int m_oAnchorType = 131072;
    protected CoordPair m_oRotatedContentTopLeft = CoordPair.ZERO_ZERO;
    protected CoordPair m_oRotatedCaptionTopLeft = CoordPair.ZERO_ZERO;
    protected boolean m_bWasRotated = false;
    protected Angle m_oRotationAngle = Angle.ZERO;
    public static final int eBaseLayout = 0;
    public static final int eButtonLayout = 1;
    public static final int eCheckButtonLayout = 2;
    public static final int eTextContentLayout = 3;
    public static final int eBarcodeLayout = 4;
    public static final int ePMDBarcodeLayout = 5;
    public static final int eImageLayout = 6;
    public static final int ePageLayout = 7;
    public static final int eExclGroupLayout = 8;

    public static int getBoxModelType(Element oNode, LayoutEnv oEnv) {
        int eType = 0;
        if (oNode != null) {
            if (oNode instanceof Field) {
                UI oUI = (UI)oNode.peekElement(XFA.UITAG, true, 0);
                Element oCurrentUI = oUI.getUIElement(false);
                int oCurrentUITag = oCurrentUI.getClassTag();
                if (oCurrentUITag == XFA.CHECKBUTTONTAG) {
                    eType = 2;
                } else if (oCurrentUITag == XFA.BUTTONTAG) {
                    eType = 1;
                } else if (oCurrentUITag != XFA.BARCODETAG) {
                    if (oCurrentUITag == XFA.IMAGEEDITTAG) {
                        eType = 6;
                    } else {
                        Node oContent;
                        int oContentTag;
                        eType = 3;
                        Element oValue = oNode.peekElement(XFA.VALUETAG, false, 0);
                        if (oValue != null && (oContentTag = (oContent = oValue.getOneOfChild(true, true)).getClassTag()) == XFA.IMAGETAG) {
                            eType = 6;
                        }
                    }
                }
            } else if (oNode instanceof Draw) {
                Element oValue = oNode.peekElement(XFA.VALUETAG, true, 0);
                Node oContent = oValue.getOneOfChild(true, true);
                int oContentTag = oContent.getClassTag();
                if (oContentTag == XFA.TEXTTAG || oContentTag == XFA.DECIMALTAG || oContentTag == XFA.INTEGERTAG || oContentTag == XFA.FLOATTAG || oContentTag == XFA.DATETAG || oContentTag == XFA.DATETIMETAG || oContentTag == XFA.TIMETAG || oContentTag == XFA.EXDATATAG) {
                    eType = 3;
                } else if (oContentTag == XFA.IMAGETAG) {
                    eType = 6;
                }
            } else if (!(oNode instanceof Subform)) {
                if (oNode instanceof ExclGroup) {
                    eType = 8;
                } else if (oNode instanceof PageArea) {
                    eType = 7;
                }
            }
        }
        return eType;
    }

    public static BoxModelLayout newBoxModel(Element node, LayoutEnv env, boolean bAllowProxy) {
        BoxModelRenderProxy oBM = null;
        try {
            int eType = BoxModelLayout.getBoxModelType(node, env);
            if (eType == 3) {
                oBM = bAllowProxy && node instanceof Draw ? new BoxModelRenderProxy(env) : new BoxModelContent(env, bAllowProxy);
                ((BoxModelLayout)oBM).initialize(node);
            }
        }
        catch (ExFull e) {
            if (e.firstResId() != ResId.UNSUPPORTED_OPERATION) {
                throw e;
            }
            oBM = null;
        }
        return oBM;
    }

    BoxModelLayout() {
    }

    public void clear() {
        this.m_oAnchorType = 131072;
        this.m_oAnchorPoint = CoordPair.ZERO_ZERO;
        this.m_oBorderMargins = new Margins();
        this.m_oContentBorderMargins = new Margins();
        this.m_oNEMargins = new Margins();
        this.m_oContMargins = new Margins();
        this.m_oCapMargins = new Margins();
        this.m_oNE = Rect.ZERO;
        this.m_oRotatedContentTopLeft = CoordPair.ZERO_ZERO;
        this.m_oMaxEdgeThickness = UnitSpan.ZERO;
        this.m_oRotationAngle = Angle.ZERO;
        this.m_bGrowableH = false;
        this.m_bGrowableW = false;
        this.m_bInfiniteMaxH = false;
        this.m_bInfiniteMaxW = false;
        this.m_oMinH = this.m_oMaxH = UnitSpan.ZERO;
        this.m_oMaxW = this.m_oMaxH;
        this.m_oMinW = this.m_oMaxH;
    }

    public Rect getNominalExtent() {
        return this.m_oNE;
    }

    public UnitSpan getWidth() {
        return this.m_oNE.width();
    }

    public UnitSpan getHeight() {
        return this.m_oNE.height();
    }

    public Rect getVisualExtent() {
        Rect oNE = this.getNominalExtent();
        return new Rect(oNE.left().subtract(this.m_oMaxEdgeThickness), oNE.top().subtract(this.m_oMaxEdgeThickness), oNE.right().add(this.m_oMaxEdgeThickness), oNE.bottom().add(this.m_oMaxEdgeThickness));
    }

    public Rect getBorderExtent() {
        Rect oNE = this.getNominalExtent();
        return new Rect(oNE.left().add(this.m_oBorderMargins.marginLeft()), oNE.top().add(this.m_oBorderMargins.marginTop()), oNE.right().subtract(this.m_oBorderMargins.marginRight()), oNE.bottom().subtract(this.m_oBorderMargins.marginBottom()));
    }

    public Rect getContentBorderExtent() {
        return Rect.ZERO;
    }

    public Rect getCaptionExtent() {
        return Rect.ZERO;
    }

    public Rect getContentExtent() {
        Rect oNE = this.getNominalExtent();
        return new Rect(oNE.left().add(this.m_oNEMargins.marginLeft()).add(this.m_oContMargins.marginLeft()), oNE.top().add(this.m_oNEMargins.marginTop()).add(this.m_oContMargins.marginTop()), oNE.right().subtract(this.m_oNEMargins.marginRight()).subtract(this.m_oContMargins.marginRight()), oNE.bottom().subtract(this.m_oNEMargins.marginBottom()).subtract(this.m_oContMargins.marginBottom()));
    }

    public Margins getCaptionExtentMargins() {
        return this.m_oCapMargins;
    }

    public Margins getContentExtentMargins() {
        return this.m_oContMargins;
    }

    public Angle getAngle() {
        return this.m_oRotationAngle;
    }

    public Margins getNominalExtentMargins() {
        return this.m_oNEMargins;
    }

    public void disableTopMargin() {
        this.m_oNEMargins = new Margins(this.m_oNEMargins.marginLeft(), UnitSpan.ZERO, this.m_oNEMargins.marginRight(), this.m_oNEMargins.marginBottom());
    }

    public void disableBottomMargin() {
        this.m_oNEMargins = new Margins(this.m_oNEMargins.marginLeft(), this.m_oNEMargins.marginTop(), this.m_oNEMargins.marginRight(), UnitSpan.ZERO);
    }

    public void disableContentTopMargin() {
        this.m_oContMargins = new Margins(this.m_oContMargins.marginLeft(), UnitSpan.ZERO, this.m_oContMargins.marginRight(), this.m_oContMargins.marginBottom());
    }

    public void disableContentBottomMargin() {
        this.m_oContMargins = new Margins(this.m_oContMargins.marginLeft(), this.m_oContMargins.marginTop(), this.m_oContMargins.marginRight(), UnitSpan.ZERO);
    }

    public void disableCaptionTopMargin() {
        this.m_oCapMargins = new Margins(this.m_oCapMargins.marginLeft(), UnitSpan.ZERO, this.m_oCapMargins.marginRight(), this.m_oCapMargins.marginBottom());
    }

    public void disableCaptionBottomMargin() {
        this.m_oCapMargins = new Margins(this.m_oCapMargins.marginLeft(), this.m_oCapMargins.marginTop(), this.m_oCapMargins.marginRight(), UnitSpan.ZERO);
    }

    public boolean enumerateCaption(LayoutHandler pHandler, CoordPair oOffset, boolean bTruncate, Rect oInvalidatedRect) {
        return true;
    }

    public boolean enumerateContent(LayoutHandler pHandler, CoordPair oOffset, boolean bWrapText, boolean bTruncate, Rect oInvalidatedRect) {
        return true;
    }

    public String getCaptionByType(String sType, List<TemplateResolver.RGB> colorTable, List<String> fontTable) {
        return "";
    }

    public String getContentByType(String sType, List<TemplateResolver.RGB> colorTable, List<String> fontTable) {
        return "";
    }

    public CoordPair getRotatedContentTopLeft() {
        return this.m_oRotatedContentTopLeft;
    }

    public CoordPair getRotatedCaptionTopLeft() {
        return this.m_oRotatedCaptionTopLeft;
    }

    public boolean hasCaption() {
        return false;
    }

    public boolean hasContent() {
        return false;
    }

    public boolean hasRotation() {
        return this.m_bWasRotated;
    }

    public boolean hasCaptionExtentContained() {
        Rect oNE = this.getNominalExtent();
        Rect oCE = this.getCaptionExtent();
        return oNE.contains(oCE);
    }

    public boolean hasContentExtentContained() {
        Rect oNE = this.getNominalExtent();
        Rect oCE = this.getContentExtent();
        return oNE.contains(oCE);
    }

    public boolean hasEmbeddedContent() {
        return false;
    }

    public boolean hasSplit() {
        return false;
    }

    public void initialize(Element oNode) {
        assert (oNode != null);
        if (!this.isBoxModelCompatible(oNode)) {
            return;
        }
        this.initWidthHeight(oNode, false);
        this.initAnchorPoint(oNode);
        this.initMargins(oNode);
        this.initRotatedContentTopLeft();
        this.initBorder(oNode);
        this.respectRotation(oNode);
        this.initVisualExtent(oNode);
    }

    public boolean isFontSubstituted() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public void reinitialize(Element oNode) {
        this.clear();
        assert (oNode != null);
        this.initialize(oNode);
    }

    public void resizeToNominal(UnitSpan oW, UnitSpan oH, Element oNode) {
        assert (UnitSpan.ZERO.lte(oW));
        assert (UnitSpan.ZERO.lte(oH));
        this.m_oNE = this.m_oNE.width(oW, false);
        this.m_oNE = this.m_oNE.height(oH, false);
    }

    public void resizeToNominalWidth(UnitSpan oW, Element oNode) {
        assert (UnitSpan.ZERO.lte(oW));
        this.m_oNE.width(oW, false);
    }

    public void resizeToContent(UnitSpan oContentW, UnitSpan oContentH, Element oNode) {
        assert (UnitSpan.ZERO.lte(oContentW));
        assert (UnitSpan.ZERO.lte(oContentW));
        this.m_oNE = this.m_oNE.width(oContentW.add(this.m_oNEMargins.marginLeft()).add(this.m_oContMargins.marginLeft()).add(this.m_oContMargins.marginRight()).add(this.m_oNEMargins.marginRight()), false);
        this.m_oNE = this.m_oNE.height(oContentH.add(this.m_oNEMargins.marginTop()).add(this.m_oContMargins.marginTop()).add(this.m_oContMargins.marginBottom()).add(this.m_oNEMargins.marginBottom()), false);
    }

    public boolean split(UnitSpan oNewHeight, ObjectHolder<BoxModelLayout> oNewBM, Element oNode) {
        boolean bSplit = false;
        BoxModelLayout pImpl = null;
        bSplit = this.splitImpl(oNewHeight, pImpl, oNode);
        oNewBM.value = bSplit ? pImpl : new BoxModelLayout();
        return bSplit;
    }

    protected boolean splitImpl(UnitSpan oNewHeight, BoxModelLayout oNewBM, Element oNode) {
        return false;
    }

    private static boolean UNITS_GTE(UnitSpan a, UnitSpan b) {
        if (a.lt(b)) {
            return Math.abs(a.valueAsUnit(0) - b.valueAsUnit(0)) >= 5;
        }
        return true;
    }

    public boolean hasGrowableW() {
        return this.m_bGrowableW;
    }

    public boolean hasGrowableH() {
        return this.m_bGrowableH;
    }

    public int getAnchor() {
        return this.m_oAnchorType;
    }

    public CoordPair getAnchorPoint() {
        return this.m_oAnchorPoint;
    }

    public void setAnchor(int eVal) {
        this.m_oAnchorType = eVal;
    }

    public void setAnchorPoint(CoordPair oPt) {
        this.m_oAnchorPoint = oPt;
    }

    public void initAnchorPoint(Element oNode) {
        this.m_oAnchorPoint = CoordPair.ZERO_ZERO;
        if (131073 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oNE.width().divide(2), this.m_oAnchorPoint.y());
        } else if (131074 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oNE.width(), this.m_oAnchorPoint.x());
        } else if (131075 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oAnchorPoint.x(), this.m_oNE.height().divide(2));
        } else if (131076 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oNE.width().divide(2), this.m_oNE.height().divide(2));
        } else if (131077 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oNE.width(), this.m_oNE.height().divide(2));
        } else if (131078 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oAnchorPoint.x(), this.m_oNE.height());
        } else if (131079 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oNE.width().divide(2), this.m_oNE.height());
        } else if (131080 == this.m_oAnchorType) {
            this.m_oAnchorPoint = new CoordPair(this.m_oNE.width(), this.m_oNE.height());
        }
    }

    public void initBorder(Element oNode) {
        Element oCurrentUI;
        UI oUI;
        if (oNode.isPropertySpecified(XFA.BORDERTAG, true, 0)) {
            Element oBorder = oNode.peekElement(XFA.BORDERTAG, true, 0);
            Element oBorderMargins = oBorder.peekElement(XFA.MARGINTAG, true, 0);
            ObjectHolder<UnitSpan> oLHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oTHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oRHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oBHolder = new ObjectHolder<UnitSpan>();
            ((Margin)oBorderMargins).getInsets(oTHolder, oRHolder, oBHolder, oLHolder);
            this.m_oBorderMargins = new Margins((UnitSpan)oLHolder.value, (UnitSpan)oTHolder.value, (UnitSpan)oRHolder.value, (UnitSpan)oBHolder.value);
        }
        if (oNode instanceof Field && (oUI = (UI)oNode.peekElement(XFA.UITAG, false, 0)) != null && (oCurrentUI = oUI.getUIElement(false)) != null && (oCurrentUI.isSameClass(XFA.CHECKBUTTONTAG) || oCurrentUI.isSameClass(XFA.CHOICELISTTAG) || oCurrentUI.isSameClass(XFA.DATETIMEEDITTAG) || oCurrentUI.isSameClass(XFA.NUMERICEDITTAG) || oCurrentUI.isSameClass(XFA.PASSWORDEDITTAG) || oCurrentUI.isSameClass(XFA.SIGNATURETAG) || oCurrentUI.isSameClass(XFA.TEXTEDITTAG)) && oCurrentUI.isPropertySpecified(XFA.BORDERTAG, true, 0)) {
            Element oBorder = oCurrentUI.peekElement(XFA.BORDERTAG, true, 0);
            Element oBorderMargins = oBorder.peekElement(XFA.MARGINTAG, true, 0);
            ObjectHolder<UnitSpan> oLHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oTHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oRHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oBHolder = new ObjectHolder<UnitSpan>();
            ((Margin)oBorderMargins).getInsets(oTHolder, oRHolder, oBHolder, oLHolder);
            this.m_oContentBorderMargins = new Margins((UnitSpan)oLHolder.value, (UnitSpan)oTHolder.value, (UnitSpan)oRHolder.value, (UnitSpan)oBHolder.value);
        }
    }

    public void initVisualExtent(Element oNode) {
        assert (oNode != null);
        this.m_oMaxEdgeThickness = UnitSpan.ZERO;
        if (oNode != null) {
            Element oValue;
            Content oContent;
            int oContentTag;
            Element oBorder;
            if (oNode.isPropertySpecified(XFA.BORDERTAG, true, 0) && (oBorder = oNode.peekElement(XFA.BORDERTAG, false, 0)).getEnum(XFA.HANDTAG) != 0x170001) {
                Element oEdge;
                for (int nNumEdges = 0; nNumEdges < 4 && (oEdge = oBorder.peekElement(XFA.EDGETAG, false, nNumEdges)) != null; ++nNumEdges) {
                    Measurement oThickness = new Measurement(oEdge.getAttribute(XFA.THICKNESSTAG));
                    if (!oThickness.getUnitSpan().gt(this.m_oMaxEdgeThickness)) continue;
                    this.m_oMaxEdgeThickness = oThickness.getUnitSpan();
                }
            }
            if (oNode instanceof Draw && ((oContentTag = (oContent = (Content)(oValue = oNode.peekElement(XFA.VALUETAG, true, 0)).getOneOfChild(true, true)).getClassTag()) == XFA.RECTANGLETAG || oContentTag == XFA.ARCTAG || oContentTag == XFA.LINETAG)) {
                int nTotalPossibleEdges = 1;
                if (oContentTag == XFA.RECTANGLETAG) {
                    nTotalPossibleEdges = 4;
                }
                for (int nNumEdges = 0; nNumEdges < nTotalPossibleEdges; ++nNumEdges) {
                    Measurement oThickness;
                    Element oEdge = oContent.peekElement(XFA.EDGETAG, false, nNumEdges);
                    if (oEdge == null) {
                        if (oContentTag != XFA.LINETAG) break;
                        oEdge = oContent.peekElement(XFA.EDGETAG, true, nNumEdges);
                    }
                    if (!(oThickness = new Measurement(oEdge.getAttribute(XFA.THICKNESSTAG))).getUnitSpan().gt(this.m_oMaxEdgeThickness)) continue;
                    this.m_oMaxEdgeThickness = oThickness.getUnitSpan();
                }
            }
        }
    }

    protected void initWidthHeight(Element oNode, boolean bSupportsGrowability) {
        Measurement oMeas;
        Measurement oMeasH;
        Measurement oMeasW;
        UnitSpan oW = UnitSpan.ZERO;
        UnitSpan oH = UnitSpan.ZERO;
        if (oNode.isPropertySpecified(XFA.WTAG, true, 0)) {
            oMeasW = new Measurement(oNode.getAttribute(XFA.WTAG));
            oW = oMeasW.getUnitSpan();
        } else if (oNode.isPropertySpecified(XFA.MINWTAG, true, 0)) {
            oMeasW = new Measurement(oNode.getAttribute(XFA.MINWTAG));
            oW = oMeasW.getUnitSpan();
        }
        if (oNode.isPropertySpecified(XFA.HTAG, true, 0)) {
            oMeasH = new Measurement(oNode.getAttribute(XFA.HTAG));
            oH = oMeasH.getUnitSpan();
        } else if (oNode.isPropertySpecified(XFA.MINHTAG, true, 0)) {
            oMeasH = new Measurement(oNode.getAttribute(XFA.MINHTAG));
            oH = oMeasH.getUnitSpan();
        }
        if (0 > oW.value()) {
            oW = UnitSpan.ZERO;
        }
        if (0 > oH.value()) {
            oH = UnitSpan.ZERO;
        }
        this.m_oNE = this.m_oNE.changeUnits(3);
        this.m_oNE = this.m_oNE.width(oW, false);
        this.m_oNE = this.m_oNE.height(oH, false);
        this.m_bGrowableH = false;
        this.m_bGrowableW = false;
        this.m_bInfiniteMaxH = false;
        this.m_bInfiniteMaxW = false;
        if (bSupportsGrowability) {
            assert (oNode instanceof Container);
            if (oNode instanceof Container) {
                Container oContainer = (Container)oNode;
                this.m_bGrowableW = oContainer.isWidthGrowable();
                this.m_bGrowableH = oContainer.isHeightGrowable();
            }
        }
        if (!this.m_bGrowableW) {
            this.m_oMinW = this.m_oMaxW = this.m_oNE.width();
        } else {
            this.m_oMinW = UnitSpan.ZERO;
            if (oNode.isPropertySpecified(XFA.MINWTAG, true, 0)) {
                oMeas = new Measurement(oNode.getAttribute(XFA.MINWTAG));
                this.m_oMinW = oMeas.getUnitSpan();
            }
            oMeas = new Measurement(oNode.getAttribute(XFA.MAXWTAG));
            this.m_oMaxW = oMeas.getUnitSpan();
            boolean bl = this.m_bInfiniteMaxW = !oNode.isPropertySpecified(XFA.MAXWTAG, true, 0);
            if (!this.m_bInfiniteMaxW && this.m_oMaxW.equals(UnitSpan.ZERO)) {
                this.m_bInfiniteMaxW = true;
            }
        }
        if (!this.m_bGrowableH) {
            this.m_oMinH = this.m_oMaxH = this.m_oNE.height();
        } else {
            this.m_oMinH = UnitSpan.ZERO;
            if (oNode.isPropertySpecified(XFA.MINHTAG, true, 0)) {
                oMeas = new Measurement(oNode.getAttribute(XFA.MINHTAG));
                this.m_oMinH = oMeas.getUnitSpan();
            }
            oMeas = new Measurement(oNode.getAttribute(XFA.MAXHTAG));
            this.m_oMaxH = oMeas.getUnitSpan();
            boolean bl = this.m_bInfiniteMaxH = !oNode.isPropertySpecified(XFA.MAXHTAG, true, 0);
            if (!this.m_bInfiniteMaxH && this.m_oMaxH.equals(UnitSpan.ZERO)) {
                this.m_bInfiniteMaxH = true;
            }
        }
        assert (UnitSpan.ZERO.lte(this.m_oMinW));
        assert (UnitSpan.ZERO.lte(this.m_oMinH));
        assert (UnitSpan.ZERO.lte(this.m_oMaxH));
        assert (UnitSpan.ZERO.lte(this.m_oMaxW));
        assert (this.m_bInfiniteMaxW || BoxModelLayout.UNITS_GTE(this.m_oMaxW, this.m_oMinW));
        assert (this.m_bInfiniteMaxH || BoxModelLayout.UNITS_GTE(this.m_oMaxH, this.m_oMinH));
        if (UnitSpan.ZERO.gt(this.m_oMinW)) {
            this.m_oMinW = UnitSpan.ZERO;
        }
        if (UnitSpan.ZERO.gt(this.m_oMinH)) {
            this.m_oMinH = UnitSpan.ZERO;
        }
        if (UnitSpan.ZERO.gt(this.m_oMaxH)) {
            this.m_oMaxH = UnitSpan.ZERO;
        }
        if (UnitSpan.ZERO.gt(this.m_oMaxW)) {
            this.m_oMaxW = UnitSpan.ZERO;
        }
        this.m_oMinH = new UnitSpan(3, this.m_oMinH.value());
        this.m_oMinW = new UnitSpan(3, this.m_oMinW.value());
        this.m_oMaxH = new UnitSpan(3, this.m_oMaxH.value());
        this.m_oMaxW = new UnitSpan(3, this.m_oMaxW.value());
    }

    protected void initMargins(Element oNode) {
        if (oNode.isPropertySpecified(XFA.MARGINTAG, true, 0)) {
            Element oMargins = oNode.peekElement(XFA.MARGINTAG, true, 0);
            ObjectHolder<UnitSpan> oLHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oTHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oRHolder = new ObjectHolder<UnitSpan>();
            ObjectHolder<UnitSpan> oBHolder = new ObjectHolder<UnitSpan>();
            ((Margin)oMargins).getInsets(oTHolder, oRHolder, oBHolder, oLHolder);
            UnitSpan oL = ((UnitSpan)oLHolder.value).changeUnits(3);
            UnitSpan oR = ((UnitSpan)oRHolder.value).changeUnits(3);
            UnitSpan oT = ((UnitSpan)oTHolder.value).changeUnits(3);
            UnitSpan oB = ((UnitSpan)oBHolder.value).changeUnits(3);
            this.m_oNEMargins = new Margins(oL, oT, oR, oB);
        }
        if (oNode instanceof Field || oNode instanceof Draw) {
            Element oNonConstMutableNode = oNode;
            oNonConstMutableNode.mute();
            Element oUI = (Element)oNode.getProperty(XFA.UITAG, 0);
            oUI.mute();
            Element oCurrentUI = (Element)oUI.getOneOfChild();
            oUI.unMute();
            int oCurrentUITag = oCurrentUI.getClassTag();
            if (oCurrentUITag == XFA.TEXTEDITTAG || oCurrentUITag == XFA.NUMERICEDITTAG || oCurrentUITag == XFA.CHECKBUTTONTAG || oCurrentUITag == XFA.DATETIMEEDITTAG || oCurrentUITag == XFA.SIGNATURETAG || oCurrentUITag == XFA.PASSWORDEDITTAG || oCurrentUITag == XFA.IMAGEEDITTAG || oCurrentUITag == XFA.CHOICELISTTAG) {
                oCurrentUI.mute();
                Element oMargins = (Element)oCurrentUI.getProperty(XFA.MARGINTAG, 0);
                oCurrentUI.unMute();
                ObjectHolder<UnitSpan> oLHolder = new ObjectHolder<UnitSpan>();
                ObjectHolder<UnitSpan> oTHolder = new ObjectHolder<UnitSpan>();
                ObjectHolder<UnitSpan> oRHolder = new ObjectHolder<UnitSpan>();
                ObjectHolder<UnitSpan> oBHolder = new ObjectHolder<UnitSpan>();
                ((Margin)oMargins).getInsets(oTHolder, oRHolder, oBHolder, oLHolder);
                UnitSpan oL = ((UnitSpan)oLHolder.value).changeUnits(3);
                UnitSpan oR = ((UnitSpan)oRHolder.value).changeUnits(3);
                UnitSpan oT = ((UnitSpan)oTHolder.value).changeUnits(3);
                UnitSpan oB = ((UnitSpan)oBHolder.value).changeUnits(3);
                this.m_oContMargins = new Margins(oL, oT, oR, oB);
            }
            if (oNode.isPropertySpecified(XFA.CAPTIONTAG, true, 0)) {
                Element oCaption = (Element)oNode.getProperty(XFA.CAPTIONTAG, 0);
                oCaption.mute();
                Element oMargins = (Element)oCaption.getProperty(XFA.MARGINTAG, 0);
                oCaption.unMute();
                ObjectHolder<UnitSpan> oLHolder = new ObjectHolder<UnitSpan>();
                ObjectHolder<UnitSpan> oTHolder = new ObjectHolder<UnitSpan>();
                ObjectHolder<UnitSpan> oRHolder = new ObjectHolder<UnitSpan>();
                ObjectHolder<UnitSpan> oBHolder = new ObjectHolder<UnitSpan>();
                ((Margin)oMargins).getInsets(oTHolder, oRHolder, oBHolder, oLHolder);
                UnitSpan oL = ((UnitSpan)oLHolder.value).changeUnits(3);
                UnitSpan oR = ((UnitSpan)oRHolder.value).changeUnits(3);
                UnitSpan oT = ((UnitSpan)oTHolder.value).changeUnits(3);
                UnitSpan oB = ((UnitSpan)oBHolder.value).changeUnits(3);
                this.m_oCapMargins = new Margins(oL, oT, oR, oB);
            }
            oNonConstMutableNode.unMute();
        }
    }

    protected void initRotatedContentTopLeft() {
        this.m_oRotatedContentTopLeft = this.getContentExtent().topLeft();
    }

    protected boolean isBoxModelCompatible(Element oNode) {
        boolean bCompatible = false;
        if (oNode != null) {
            bCompatible = oNode instanceof Draw || oNode instanceof Field || oNode instanceof Subform || oNode instanceof AreaContainer || oNode instanceof ContentArea || oNode instanceof PageArea || oNode instanceof ExclGroup;
        }
        return bCompatible;
    }

    protected void respectRotation(Element oNode) {
        this.m_bWasRotated = false;
        this.m_oRotationAngle = Angle.ZERO;
        if (oNode instanceof Draw || oNode instanceof Field) {
            this.m_oRotatedContentTopLeft = this.getContentExtent().topLeft();
            if (oNode.isPropertySpecified(XFA.ROTATETAG, true, 0)) {
                Rotate oRotate = new Rotate("rotate", oNode.getAttribute(XFA.ROTATETAG).toString());
                Angle oAngle = oRotate.getAngle();
                int lAngle = oAngle.degrees();
                if (0 > (lAngle %= 360)) {
                    lAngle += 360;
                }
                this.m_oRotationAngle = oAngle = new Angle(lAngle);
                Margins oPrevMargins = this.m_oNEMargins;
                Margins oPrevBorderMargins = this.m_oBorderMargins;
                Margins oPrevWidgetBorderMargins = this.m_oContentBorderMargins;
                Margins oPrevWidgetContentMargins = this.m_oContMargins;
                Margins oPrevWidgetCaptionMargins = this.m_oCapMargins;
                CoordPair oPrevContentExtentTL = this.getContentExtent().topLeft();
                Rect rcPrevNE = this.getNominalExtent();
                CoordPair oNewTL = CoordPair.ZERO_ZERO;
                CoordPair oNewTR = CoordPair.ZERO_ZERO;
                CoordPair oNewBR = CoordPair.ZERO_ZERO;
                CoordPair oPrevTL = rcPrevNE.topLeft();
                CoordPair oPrevTR = rcPrevNE.topRight();
                CoordPair oPrevBL = rcPrevNE.bottomLeft();
                CoordPair oPrevBR = rcPrevNE.bottomRight();
                switch (lAngle) {
                    case 0: {
                        return;
                    }
                    case 270: {
                        oNewTR = oPrevTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        oNewBR = oPrevTR.rotatePoint(this.m_oAnchorPoint, oAngle);
                        oNewTL = oPrevBL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        this.m_oNEMargins = new Margins(oPrevMargins);
                        this.m_oNEMargins = new Margins(oPrevMargins.marginBottom(), oPrevMargins.marginLeft(), oPrevMargins.marginTop(), oPrevMargins.marginRight());
                        this.m_oBorderMargins = new Margins(oPrevBorderMargins.marginBottom(), oPrevBorderMargins.marginLeft(), oPrevBorderMargins.marginTop(), oPrevBorderMargins.marginRight());
                        this.m_oContentBorderMargins = new Margins(oPrevWidgetBorderMargins.marginBottom(), oPrevWidgetBorderMargins.marginLeft(), oPrevWidgetBorderMargins.marginTop(), oPrevWidgetBorderMargins.marginRight());
                        this.m_oContMargins = new Margins(oPrevWidgetContentMargins.marginBottom(), oPrevWidgetContentMargins.marginLeft(), oPrevWidgetContentMargins.marginTop(), oPrevWidgetContentMargins.marginRight());
                        this.m_oCapMargins = new Margins(oPrevWidgetCaptionMargins.marginBottom(), oPrevWidgetCaptionMargins.marginLeft(), oPrevWidgetCaptionMargins.marginTop(), oPrevWidgetCaptionMargins.marginRight());
                        this.m_oRotatedContentTopLeft = oPrevContentExtentTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        break;
                    }
                    case 180: {
                        oNewBR = oPrevTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        oNewTL = oPrevBR.rotatePoint(this.m_oAnchorPoint, oAngle);
                        oNewTR = oPrevBL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        this.m_oNEMargins = new Margins(oPrevMargins.marginRight(), oPrevMargins.marginBottom(), oPrevMargins.marginLeft(), oPrevMargins.marginTop());
                        this.m_oBorderMargins = new Margins(oPrevBorderMargins.marginRight(), oPrevBorderMargins.marginBottom(), oPrevBorderMargins.marginLeft(), oPrevBorderMargins.marginTop());
                        this.m_oContentBorderMargins = new Margins(oPrevWidgetBorderMargins.marginRight(), oPrevWidgetBorderMargins.marginBottom(), oPrevWidgetBorderMargins.marginLeft(), oPrevWidgetBorderMargins.marginTop());
                        this.m_oContMargins = new Margins(oPrevWidgetContentMargins.marginRight(), oPrevWidgetContentMargins.marginBottom(), oPrevWidgetContentMargins.marginLeft(), oPrevWidgetContentMargins.marginTop());
                        this.m_oCapMargins = new Margins(oPrevWidgetCaptionMargins.marginRight(), oPrevWidgetCaptionMargins.marginBottom(), oPrevWidgetCaptionMargins.marginLeft(), oPrevWidgetCaptionMargins.marginTop());
                        this.m_oRotatedContentTopLeft = oPrevContentExtentTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        break;
                    }
                    case 90: {
                        oNewTL = oPrevTR.rotatePoint(this.m_oAnchorPoint, oAngle);
                        oNewTR = oPrevBR.rotatePoint(this.m_oAnchorPoint, oAngle);
                        oNewBR = oPrevBL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        this.m_oNEMargins = new Margins(oPrevMargins.marginTop(), oPrevMargins.marginRight(), oPrevMargins.marginBottom(), oPrevMargins.marginLeft());
                        this.m_oBorderMargins = new Margins(oPrevBorderMargins.marginTop(), oPrevBorderMargins.marginRight(), oPrevBorderMargins.marginBottom(), oPrevBorderMargins.marginLeft());
                        this.m_oContentBorderMargins = new Margins(oPrevWidgetBorderMargins.marginTop(), oPrevWidgetBorderMargins.marginRight(), oPrevWidgetBorderMargins.marginBottom(), oPrevWidgetBorderMargins.marginLeft());
                        this.m_oContMargins = new Margins(oPrevWidgetContentMargins.marginTop(), oPrevWidgetContentMargins.marginRight(), oPrevWidgetContentMargins.marginBottom(), oPrevWidgetContentMargins.marginLeft());
                        this.m_oCapMargins = new Margins(oPrevWidgetCaptionMargins.marginTop(), oPrevWidgetCaptionMargins.marginRight(), oPrevWidgetCaptionMargins.marginBottom(), oPrevWidgetCaptionMargins.marginLeft());
                        this.m_oRotatedContentTopLeft = oPrevContentExtentTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.m_bWasRotated = 0 != lAngle;
                this.m_oAnchorType = 131072;
                this.m_oAnchorPoint = oNewTL;
                UnitSpan oNewWidth = oNewTR.x().subtract(oNewTL.x());
                UnitSpan oNewHeight = oNewBR.y().subtract(oNewTR.y());
                if (oNewWidth.value() < 0) {
                    oNewWidth = oNewWidth.multiply(-1.0);
                }
                if (oNewHeight.value() < 0) {
                    oNewHeight = oNewHeight.multiply(-1.0);
                }
                assert (oNewWidth.gte(UnitSpan.ZERO));
                assert (oNewHeight.gte(UnitSpan.ZERO));
                this.m_oNE = this.m_oNE.width(oNewWidth, false);
                this.m_oNE = this.m_oNE.height(oNewHeight, false);
            }
        }
    }

    protected void setGrowableH(UnitSpan oMinH, UnitSpan oMaxH) {
        assert (oMinH.lte(oMaxH) || oMaxH.equals(new UnitSpan(3, -1)));
        assert (oMinH.gte(UnitSpan.ZERO));
        this.m_bInfiniteMaxH = oMaxH.equals(new UnitSpan(3, -1));
        if (oMinH.lt(oMaxH) || this.m_bInfiniteMaxH) {
            this.m_bGrowableH = true;
            this.m_oMinH = oMinH;
            this.m_oMaxH = oMaxH;
        } else {
            this.m_bGrowableH = false;
            this.m_bInfiniteMaxH = false;
            this.m_oMinH = oMinH;
            this.m_oMaxH = oMinH;
        }
    }

    protected void setGrowableW(UnitSpan oMinW, UnitSpan oMaxW) {
        assert (oMinW.lte(oMaxW) || oMaxW.equals(new UnitSpan(3, -1)));
        assert (oMinW.gte(UnitSpan.ZERO));
        this.m_bInfiniteMaxW = oMaxW.equals(new UnitSpan(3, -1));
        if (oMinW.lt(oMaxW) || this.m_bInfiniteMaxW) {
            this.m_bGrowableW = true;
            this.m_oMinW = oMinW;
            this.m_oMaxW = oMaxW;
        } else {
            this.m_bGrowableW = false;
            this.m_bInfiniteMaxW = false;
            this.m_oMinW = oMinW;
            this.m_oMaxW = oMinW;
        }
    }

    public boolean hasOverflowingContentText() {
        return false;
    }

    public boolean hasOverflowingCaptionText() {
        return false;
    }
}

