/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.gfx.GFXAttr;
import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.ut.UnitSpan;

public class GFXLineAttr
extends GFXAttr {
    public static final UnitSpan DEFAULT_LINEWIDTH = new UnitSpan(3, 720);
    public static final GFXLineAttr BLACK_LINE = new GFXLineAttr(DEFAULT_LINEWIDTH, 2, 100, GFXColour.BLACK, GFXColour.WHITE);
    public static final GFXLineAttr WHITE_LINE = new GFXLineAttr(DEFAULT_LINEWIDTH, 2, 100, GFXColour.WHITE, GFXColour.WHITE);
    public static final GFXLineAttr LIGHTGRAY_LINE = new GFXLineAttr(DEFAULT_LINEWIDTH, 2, 100, GFXColour.LIGHTGRAY, GFXColour.WHITE);
    public static final GFXLineAttr GRAY_LINE = new GFXLineAttr(DEFAULT_LINEWIDTH, 2, 100, GFXColour.GRAY, GFXColour.WHITE);
    public static final GFXLineAttr DARKGRAY_LINE = new GFXLineAttr(DEFAULT_LINEWIDTH, 2, 100, GFXColour.DARKGRAY, GFXColour.WHITE);
    public static final int HAND_LEFT = 0;
    public static final int HAND_RIGHT = 1;
    public static final int HAND_EVEN = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private UnitSpan moWidth;
    private int moHand;
    private int moCap;

    public GFXLineAttr() {
        this.moWidth = DEFAULT_LINEWIDTH;
        this.moHand = 2;
        this.moCap = 2;
    }

    public GFXLineAttr(GFXLineAttr oSource) {
        this.copyFrom(oSource);
    }

    public GFXLineAttr(UnitSpan oNewWidth, int nNewStyle, int lNewShade, GFXColour oNewColour, GFXColour oNewColourBg) {
        super(nNewStyle, lNewShade, oNewColour, oNewColourBg);
        this.moWidth = oNewWidth;
        this.moHand = 2;
        this.moCap = 2;
    }

    public GFXLineAttr defaultLine() {
        return BLACK_LINE;
    }

    public GFXLineAttr blackLine() {
        return BLACK_LINE;
    }

    public GFXLineAttr whiteLine() {
        return WHITE_LINE;
    }

    public GFXLineAttr lightGrayLine() {
        return LIGHTGRAY_LINE;
    }

    public GFXLineAttr grayLine() {
        return GRAY_LINE;
    }

    public GFXLineAttr darkGrayLine() {
        return DARKGRAY_LINE;
    }

    public UnitSpan width() {
        return this.moWidth;
    }

    public void width(UnitSpan oNewWidth) {
        this.moWidth = oNewWidth;
    }

    public int hand() {
        return this.moHand;
    }

    public void hand(int oNewCode) {
        this.moHand = oNewCode;
    }

    public int cap() {
        return this.moCap;
    }

    public void cap(int oNewCode) {
        this.moCap = oNewCode;
    }

    public boolean equivalent(GFXLineAttr oCompare) {
        return super.equivalent(oCompare) && this.moWidth == oCompare.moWidth && this.moHand == oCompare.moHand && this.moCap == oCompare.moCap;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.equivalent((GFXLineAttr)object);
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 31 ^ super.hashCode();
        hash = hash * 31 ^ this.moWidth.hashCode();
        hash = hash * 31 ^ this.moHand;
        hash = hash * 31 ^ this.moCap;
        return hash;
    }

    public void copyFrom(GFXLineAttr oSource) {
        if (this != oSource) {
            super.copyFrom(oSource);
            this.moWidth = oSource.moWidth;
            this.moHand = oSource.moHand;
            this.moCap = oSource.moCap;
        }
    }
}

