/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.ProtocolHost;
import com.adobe.xfa.ut.ExFull;

final class BuiltinUrl {
    private BuiltinUrl() {
    }

    static void Get(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block8: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String sUrl = oParser.getString(oArgSym[0]);
                String sRes = null;
                ProtocolHost oProtocolHost = oParser.moProtocolHost;
                if (oProtocolHost != null) {
                    CalcSymbol oSym = null;
                    try {
                        oSym = oProtocolHost.getUrl(sUrl);
                        sRes = oParser.getString(oSym);
                        CalcSymbol.delete(oSym, oParser);
                    }
                    catch (ExFull oException) {
                        String sErr = oException.toString();
                        if (sErr != null) {
                            throw new CalcException(sErr);
                        }
                        throw new CalcException();
                    }
                    catch (CalcException e) {
                        if (oSym != null) {
                            CalcSymbol.delete(oSym, oParser);
                        }
                        throw e;
                    }
                }
                oRetSym = new CalcSymbol(sRes);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block8;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Put(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block8: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String sUrl = oParser.getString(oArgSym[0]);
                String sData = oParser.getString(oArgSym[1]);
                String sEnc = nArgs > 2 ? oParser.getString(oArgSym[2]) : "UTF-8";
                String sRes = null;
                ProtocolHost oProtocolHost = oParser.moProtocolHost;
                if (oProtocolHost != null) {
                    CalcSymbol oSym = null;
                    try {
                        oSym = oProtocolHost.putUrl(sUrl, sData, sEnc);
                        sRes = oParser.getString(oSym);
                        CalcSymbol.delete(oSym, oParser);
                    }
                    catch (ExFull oException) {
                        String sErr = oException.toString();
                        if (sErr != null) {
                            throw new CalcException(sErr);
                        }
                        throw new CalcException();
                    }
                    catch (CalcException e) {
                        if (oSym != null) {
                            CalcSymbol.delete(oSym, oParser);
                        }
                        throw e;
                    }
                }
                oRetSym = new CalcSymbol(sRes);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block8;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Post(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block8: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 5);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String sUrl = oParser.getString(oArgSym[0]);
                String sData = oParser.getString(oArgSym[1]);
                String sContent = nArgs > 2 ? oParser.getString(oArgSym[2]) : "application/octet-stream";
                String sEnc = nArgs > 3 ? oParser.getString(oArgSym[3]) : "UTF-8";
                String sHead = nArgs > 4 ? oParser.getString(oArgSym[4]) : "";
                String sRes = null;
                ProtocolHost oProtocolHost = oParser.moProtocolHost;
                if (oProtocolHost != null) {
                    CalcSymbol oSym = null;
                    try {
                        oSym = oProtocolHost.postUrl(sUrl, sHead, sData, sContent, sEnc);
                        sRes = oParser.getString(oSym);
                        CalcSymbol.delete(oSym, oParser);
                    }
                    catch (ExFull oException) {
                        String sErr = oException.toString();
                        if (sErr != null) {
                            throw new CalcException(sErr);
                        }
                        throw new CalcException();
                    }
                    catch (CalcException e) {
                        if (oSym != null) {
                            CalcSymbol.delete(oSym, oParser);
                        }
                        throw e;
                    }
                }
                oRetSym = new CalcSymbol(sRes);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block8;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }
}

