/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

public final class SchemaPairs {
    private int mCount;
    private int[] meTags;
    private Object[] mSchemaObj;

    public SchemaPairs(SchemaPairs other) {
        this.mCount = other.mCount;
        this.meTags = new int[this.mCount];
        System.arraycopy(other.meTags, 0, this.meTags, 0, this.mCount);
        this.mSchemaObj = new Object[this.mCount];
        System.arraycopy(other.mSchemaObj, 0, this.mSchemaObj, 0, this.mCount);
    }

    public SchemaPairs() {
    }

    public Object get(int eTag) {
        for (int i = 0; i < this.mCount; ++i) {
            int tag = this.meTags[i];
            if (tag == eTag) {
                return this.mSchemaObj[i];
            }
            if (eTag >= tag) continue;
            return null;
        }
        return null;
    }

    public int key(int index) {
        return this.meTags[index];
    }

    public void put(int eTag, Object schema) {
        int index;
        for (index = 0; index < this.mCount; ++index) {
            int tag = this.meTags[index];
            if (tag == eTag) {
                this.mSchemaObj[index] = schema;
                return;
            }
            if (eTag < tag) break;
        }
        if (this.meTags == null) {
            this.meTags = new int[4];
            this.mSchemaObj = new Object[4];
        } else if (this.mCount == this.meTags.length) {
            int newSize = this.mCount * 2;
            int[] newTags = new int[newSize];
            System.arraycopy(this.meTags, 0, newTags, 0, this.mCount);
            Object[] newObj = new Object[newSize];
            System.arraycopy(this.mSchemaObj, 0, newObj, 0, this.mCount);
            this.meTags = newTags;
            this.mSchemaObj = newObj;
        }
        int elementsToShift = this.mCount - index;
        if (elementsToShift != 0) {
            System.arraycopy(this.meTags, index, this.meTags, index + 1, elementsToShift);
            System.arraycopy(this.mSchemaObj, index, this.mSchemaObj, index + 1, elementsToShift);
        }
        this.meTags[index] = eTag;
        this.mSchemaObj[index] = schema;
        ++this.mCount;
    }

    public int size() {
        return this.mCount;
    }

    public Object value(int index) {
        return this.mSchemaObj[index];
    }
}

