/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.ByteSequence;
import java.io.Serializable;

public class ByteString
implements ByteSequence,
Comparable,
Serializable {
    private static final long serialVersionUID = -7911865041315030524L;
    private byte[] value;
    private int offset;
    private int length;
    private int hash = 0;

    public ByteString() {
        this.value = new byte[0];
    }

    public ByteString(ByteString original) {
        this.length = original.length;
        if (original.value.length > this.length) {
            this.value = new byte[this.length];
            System.arraycopy(original.value, original.offset, this.value, 0, this.length);
        } else {
            this.value = original.value;
        }
    }

    public ByteString(byte[] value) {
        this.length = value.length;
        this.value = new byte[this.length];
        System.arraycopy(value, 0, this.value, 0, this.length);
    }

    public ByteString(byte[] value, int offset, int length) {
        ByteString.checkBounds(value, offset, length);
        this.value = new byte[length];
        this.length = length;
        System.arraycopy(value, offset, this.value, 0, this.length);
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (int i = 0; i < this.length; ++i) {
                this.hash = 31 * this.hash + this.value[this.offset + i];
            }
        }
        return this.hash;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index + this.offset];
    }

    public int length() {
        return this.length;
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        try {
            System.arraycopy(this.value, this.offset + srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
        catch (IndexOutOfBoundsException e) {
            StringIndexOutOfBoundsException newException = new StringIndexOutOfBoundsException();
            newException.initCause(e);
            throw newException;
        }
    }

    public byte[] getBytes() {
        byte[] array = new byte[this.length];
        System.arraycopy(this.value, this.offset, array, 0, this.length);
        return array;
    }

    public ByteSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public ByteString substring(int begin, int end) {
        if (begin < 0) {
            throw new StringIndexOutOfBoundsException(begin);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (begin > end) {
            throw new StringIndexOutOfBoundsException(end - begin);
        }
        return begin == 0 && end == this.length ? this : new ByteString(this.value, this.offset + begin, end - begin);
    }

    public ByteString concat(ByteString byteString) {
        int otherLen = byteString.length();
        if (otherLen == 0) {
            return this;
        }
        byte[] buf = new byte[this.length + otherLen];
        this.getBytes(0, this.length, buf, 0);
        byteString.getBytes(0, otherLen, buf, this.length);
        return new ByteString(buf);
    }

    public int compareTo(Object otherObject) {
        return this.compareTo((ByteString)otherObject);
    }

    public int compareTo(ByteString otherByteString) {
        int count = Math.min(this.length, otherByteString.length);
        for (int i = 0; i < count; ++i) {
            byte b1 = this.value[this.offset + i];
            byte b2 = otherByteString.value[otherByteString.offset + i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return this.length - otherByteString.length;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject instanceof ByteString) {
            return this.compareTo((ByteString)otherObject) == 0;
        }
        return false;
    }

    private static void checkBounds(byte[] bytes, int offset, int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (offset > bytes.length - length) {
            throw new StringIndexOutOfBoundsException(offset + length);
        }
    }

    public String toString() {
        return new String(this.value, this.offset, this.length);
    }
}

