/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosNumberParseRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRun;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Word {
    private String str;
    private int pageNumber;
    private List<ASQuad> quads;
    private List<PDFCharacter> uarray;
    private Double sortYCoordinate;

    public Word(ArrayList<PDFCharacter> chars, String str, int pageNumber) {
        this.str = str;
        this.pageNumber = pageNumber;
        this.uarray = chars;
    }

    public Word(ArrayList<PDFCharacter> chars, int pageNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(chars, PDFCharacter.createUnicodeString(chars), pageNumber);
    }

    Word(Word word) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.uarray = word.uarray;
        this.str = word.str;
        this.quads = new ArrayList<ASQuad>(word.getBoundingQuads());
    }

    public String toString() {
        return this.str;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public List<ASQuad> getBoundingQuads() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block3: {
            if (this.quads == null && this.uarray != null && this.uarray.size() > 0) {
                try {
                    this.quads = PDFCharacter.createBoundingQuads(this.uarray);
                }
                catch (PDFCosNumberParseRuntimeException e) {
                    if (this.uarray.get(0).getTextRun().ignoreErrors()) break block3;
                    throw e;
                }
            }
        }
        return this.quads;
    }

    public List<ASQuad> getBoundingQuadsForPartialWords(String partialWord, boolean ignoreCase) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<ASQuad> tempQuad;
        block5: {
            tempQuad = new ArrayList<ASQuad>();
            try {
                String completeWord = null;
                completeWord = ignoreCase ? this.toString().toLowerCase() : this.toString();
                int startIndex = 0;
                int endIndex = 0;
                List<ASQuad> quadOfPrevChar = null;
                List<ASQuad> quadToModify = null;
                List<ASQuad> quadOfNextChar = null;
                while ((startIndex = completeWord.indexOf(partialWord, endIndex)) != -1) {
                    endIndex = startIndex + partialWord.length();
                    if (startIndex != 0) {
                        quadOfPrevChar = PDFCharacter.createBoundingQuads(this.uarray.subList(startIndex - 1, startIndex));
                    }
                    quadToModify = PDFCharacter.createBoundingQuads(this.uarray.subList(startIndex, endIndex));
                    if (endIndex != completeWord.length()) {
                        quadOfNextChar = PDFCharacter.createBoundingQuads(this.uarray.subList(endIndex, endIndex + 1));
                    }
                    tempQuad.add(this.modifyBoundingBoxOfPartialWords(quadToModify, quadOfPrevChar, quadOfNextChar));
                    quadOfPrevChar = null;
                    quadOfNextChar = null;
                }
            }
            catch (PDFCosNumberParseRuntimeException e) {
                if (this.uarray.get(0).getTextRun().ignoreErrors()) break block5;
                throw e;
            }
        }
        return tempQuad;
    }

    private ASQuad modifyBoundingBoxOfPartialWords(List<ASQuad> quadToModify, List<ASQuad> quadOfPrevChar, List<ASQuad> quadOfNextChar) {
        double maxXOfPrevChar = 0.0;
        double minXOfNextChar = 0.0;
        if (quadOfPrevChar != null) {
            maxXOfPrevChar = quadOfPrevChar.get(0).p3().x();
        }
        if (quadOfNextChar != null) {
            minXOfNextChar = quadOfNextChar.get(0).p1().x();
        }
        ASQuad tempQuad = quadToModify.get(0);
        double minXtempQuad = tempQuad.p1().x();
        double maxXtempQuad = tempQuad.p3().x();
        if (maxXOfPrevChar != 0.0 && minXtempQuad < maxXOfPrevChar) {
            minXtempQuad = maxXOfPrevChar;
        }
        if (minXOfNextChar != 0.0 && maxXtempQuad > minXOfNextChar) {
            maxXtempQuad = minXOfNextChar;
        }
        ASCoordinate newP1 = new ASCoordinate(minXtempQuad, tempQuad.p1().y());
        ASCoordinate newP2 = new ASCoordinate(maxXtempQuad, tempQuad.p2().y());
        ASCoordinate newP3 = new ASCoordinate(maxXtempQuad, tempQuad.p3().y());
        ASCoordinate newP4 = new ASCoordinate(minXtempQuad, tempQuad.p4().y());
        return new ASQuad(newP1, newP2, newP3, newP4);
    }

    public List<PDFCharacter> getUarray() {
        return this.uarray;
    }

    protected double fontWidth() {
        PDFCharacter ch = this.getUarray().get(0);
        double chw = ch.getHorizontalFontSize();
        return chw;
    }

    protected double spaceWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCharacter ch = this.getUarray().get(0);
        double chw = ch.getSpaceCharWidth();
        return chw;
    }

    public ASCoordinate topLeft() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<ASQuad> quads = this.getBoundingQuads();
        if (quads != null && !quads.isEmpty()) {
            return quads.get(0).p4();
        }
        return null;
    }

    public ASCoordinate bottomRight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<ASQuad> quads = this.getBoundingQuads();
        if (quads != null && !quads.isEmpty()) {
            return quads.get(0).p2();
        }
        return null;
    }

    public double avgWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.fontWidth() + this.spaceWidth()) / 3.3;
    }

    public double charHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate topLeft = this.topLeft();
        ASCoordinate bottomRight = this.bottomRight();
        return Math.abs(bottomRight.y() - topLeft.y());
    }

    public double charWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate topLeft = this.topLeft();
        ASCoordinate bottomRight = this.bottomRight();
        return Math.abs(bottomRight.x() - topLeft.x()) / (double)this.toString().length();
    }

    public boolean isRTL() {
        if (this.str != null) {
            for (int i = 0; i < this.str.length(); ++i) {
                char ch = this.str.charAt(i);
                int[] unicodes = new int[]{ch};
                boolean rtl = TextRun.isCharacterRTL(unicodes);
                if (!rtl) continue;
                return true;
            }
        }
        return false;
    }

    public void setSortYCoordinate(Double sortYCoordinate) {
        this.sortYCoordinate = sortYCoordinate;
    }

    public Double getSortYCoordinate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.sortYCoordinate == null) {
            return this.topLeft().y();
        }
        return this.sortYCoordinate;
    }

    public boolean isNeutralWord() {
        List<PDFCharacter> charsInWord = this.getUarray();
        for (PDFCharacter pdfCharacter : charsInWord) {
            if (!Character.isLetter(pdfCharacter.toString().toCharArray()[0])) continue;
            return false;
        }
        return true;
    }

    public ASQuad getWordGlyphBounds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASQuad wordBoundsFromFont = this.getBoundingQuads().get(0);
        GeneralPath wordOutline = Word.getSublistGlyphOutline(this.uarray);
        if (wordOutline == null) {
            return wordBoundsFromFont;
        }
        Rectangle2D wordBounds = wordOutline.getBounds2D();
        return this.getQuadsIntersection(wordBoundsFromFont, wordBounds);
    }

    private ASQuad getQuadsIntersection(ASQuad wordBoundsFromFont, Rectangle2D wordBoundsFromGlyphOutlines) {
        double p1X = wordBoundsFromFont.p1().x();
        double p1Y = wordBoundsFromFont.p1().y();
        double p3X = wordBoundsFromFont.p3().x();
        double p3Y = wordBoundsFromFont.p3().y();
        double minX = wordBoundsFromFont.getMinX();
        double minY = wordBoundsFromFont.getMinY();
        if (minX == p1X && minY == p1Y || minX == p3X && minY == p3Y) {
            return new ASQuad(new ASCoordinate(wordBoundsFromFont.getMinX(), wordBoundsFromGlyphOutlines.getMinY()), new ASCoordinate(wordBoundsFromFont.getMaxX(), wordBoundsFromGlyphOutlines.getMinY()), new ASCoordinate(wordBoundsFromFont.getMaxX(), wordBoundsFromGlyphOutlines.getMaxY()), new ASCoordinate(wordBoundsFromFont.getMinX(), wordBoundsFromGlyphOutlines.getMaxY()));
        }
        return new ASQuad(new ASCoordinate(wordBoundsFromGlyphOutlines.getMinX(), wordBoundsFromFont.getMinY()), new ASCoordinate(wordBoundsFromGlyphOutlines.getMaxX(), wordBoundsFromFont.getMinY()), new ASCoordinate(wordBoundsFromGlyphOutlines.getMaxX(), wordBoundsFromFont.getMaxY()), new ASCoordinate(wordBoundsFromGlyphOutlines.getMinX(), wordBoundsFromFont.getMaxY()));
    }

    public List<ASQuad> getGlyphBoundsForPartialWords(String partialWord, boolean ignoreCase) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<ASQuad> quadsForPartialWordsFromFont = this.getBoundingQuadsForPartialWords(partialWord, ignoreCase);
        int listIndex = 0;
        ArrayList<ASQuad> quadsToReturn = new ArrayList<ASQuad>();
        String completeWord = null;
        completeWord = ignoreCase ? this.toString().toLowerCase() : this.toString();
        int startIndex = 0;
        int endIndex = 0;
        while ((startIndex = completeWord.indexOf(partialWord, endIndex)) != -1) {
            endIndex = startIndex + partialWord.length();
            List<PDFCharacter> partialWordCharsList = this.uarray.subList(startIndex, endIndex);
            GeneralPath partialWordOutline = Word.getSublistGlyphOutline(partialWordCharsList);
            if (partialWordOutline == null) {
                return quadsForPartialWordsFromFont;
            }
            Rectangle2D partialWordBounds = partialWordOutline.getBounds2D();
            ASQuad partialWordQuad = this.getQuadsIntersection(quadsForPartialWordsFromFont.get(listIndex), partialWordBounds);
            ++listIndex;
            quadsToReturn.add(partialWordQuad);
        }
        return quadsToReturn;
    }

    public static GeneralPath getSublistGlyphOutline(List<PDFCharacter> charSublist) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        GeneralPath sublistOutline = new GeneralPath();
        for (PDFCharacter pdfChar : charSublist) {
            if (pdfChar.getFont() instanceof PDFFontType3) {
                return null;
            }
            GeneralPath glyphOutline = pdfChar.getGlyphOutline();
            if (glyphOutline == null) {
                return null;
            }
            sublistOutline.append(glyphOutline, false);
        }
        return sublistOutline;
    }
}

