/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rcg;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;

public final class RCGTargetRegion {
    private double height;
    private double width;
    private RCGWrapOption wrap;
    private RCGAlignment vert_alignment;
    private RCGOverflowMode overflow;
    private double paddingLeft;
    private double paddingRight;
    private double paddingTop;
    private double paddingBottom;
    private double adjustmentBelowBaselineFactor;
    private int XFAVersion;

    RCGTargetRegion(double width, double height, RCGWrapOption wrap, RCGOverflowMode overflow, RCGAlignment verticalAlignment, double padding) throws PDFInvalidParameterException {
        this.height = height;
        this.width = width;
        this.wrap = wrap;
        this.overflow = overflow;
        this.vert_alignment = verticalAlignment;
        this.setPaddingLeft(padding);
        this.setPaddingRight(padding);
        this.setPaddingTop(padding);
        this.setPaddingBottom(padding);
        this.adjustmentBelowBaselineFactor = 1.0;
    }

    public RCGTargetRegion(double width, double height) {
        this.height = height;
        this.width = width;
        this.wrap = RCGWrapOption.Emergency;
        this.overflow = RCGOverflowMode.ShrinkToFit;
        this.vert_alignment = RCGAlignment.Middle;
        this.paddingBottom = 0.5;
        this.paddingTop = 0.5;
        this.paddingRight = 0.5;
        this.paddingLeft = 0.5;
        this.adjustmentBelowBaselineFactor = 1.0;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWrap(RCGWrapOption wrap) {
        this.wrap = wrap;
    }

    public void setOverflow(RCGOverflowMode overflow) {
        this.overflow = overflow;
    }

    public void setVerticalAlignment(RCGAlignment alignment) {
        this.vert_alignment = alignment;
    }

    public void setPaddingAll(double padding) throws PDFInvalidParameterException {
        if (padding < 0.0) {
            throw new PDFInvalidParameterException("Cannot set 0 padding.");
        }
        this.paddingTop = this.paddingBottom = padding;
        this.paddingRight = this.paddingBottom;
        this.paddingLeft = this.paddingBottom;
    }

    public void setPaddingLeft(double padding) throws PDFInvalidParameterException {
        if (padding < 0.0) {
            throw new PDFInvalidParameterException("Cannot set 0 padding.");
        }
        this.paddingLeft = padding;
    }

    public void setPaddingRight(double padding) throws PDFInvalidParameterException {
        if (padding < 0.0) {
            throw new PDFInvalidParameterException("Cannot set 0 padding.");
        }
        this.paddingRight = padding;
    }

    public void setPaddingTop(double padding) throws PDFInvalidParameterException {
        if (padding < 0.0) {
            throw new PDFInvalidParameterException("Cannot set 0 padding.");
        }
        this.paddingTop = padding;
    }

    public void setPaddingBottom(double padding) throws PDFInvalidParameterException {
        if (padding < 0.0) {
            throw new PDFInvalidParameterException("Cannot set 0 padding.");
        }
        this.paddingBottom = padding;
    }

    public RCGOverflowMode getOverflow() {
        return this.overflow;
    }

    public double getPaddingBottom() {
        return this.paddingBottom;
    }

    public double getPaddingLeft() {
        return this.paddingLeft;
    }

    public double getPaddingRight() {
        return this.paddingRight;
    }

    public double getPaddingTop() {
        return this.paddingTop;
    }

    public RCGAlignment getVert_alignment() {
        return this.vert_alignment;
    }

    RCGWrapOption getWrapOption() {
        return this.wrap;
    }

    public double getAdjustmentBelowBaselineFactor() {
        return this.adjustmentBelowBaselineFactor;
    }

    public void setAdjustmentBelowBaselineFactor(double verticalLineOverflow) {
        this.adjustmentBelowBaselineFactor = verticalLineOverflow;
    }

    public int getXFAVersion() {
        return this.XFAVersion;
    }

    public void setXFAVersion(int XFAVersion) {
        this.XFAVersion = XFAVersion;
    }

    public String toString() {
        String wrapOption = this.wrap.toString();
        String targetRegion = "height:" + this.height + "pt;width:" + this.width + "pt;wrap-option:" + wrapOption + ";overflow:" + this.overflow.toString() + ";writing-mode:lr-tb;reference-orientation:0;text-valign:" + this.vert_alignment.toString() + ";padding-top:" + this.paddingTop + "pt;padding-right:" + this.paddingRight + "pt;padding-bottom:" + this.paddingBottom + "pt;padding-left:" + this.paddingLeft + "pt;below-baseline-adjustment-factor:" + this.adjustmentBelowBaselineFactor + "; xfaVersion:" + this.XFAVersion;
        return targetRegion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.adjustmentBelowBaselineFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.overflow == null ? 0 : this.overflow.hashCode());
        temp = Double.doubleToLongBits(this.paddingBottom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.paddingLeft);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.paddingRight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.paddingTop);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.vert_alignment == null ? 0 : this.vert_alignment.hashCode());
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.wrap == null ? 0 : this.wrap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RCGTargetRegion)) {
            return false;
        }
        RCGTargetRegion other = (RCGTargetRegion)obj;
        if (Double.doubleToLongBits(this.adjustmentBelowBaselineFactor) != Double.doubleToLongBits(other.adjustmentBelowBaselineFactor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        if (this.overflow == null ? other.overflow != null : !this.overflow.equals(other.overflow)) {
            return false;
        }
        if (Double.doubleToLongBits(this.paddingBottom) != Double.doubleToLongBits(other.paddingBottom)) {
            return false;
        }
        if (Double.doubleToLongBits(this.paddingLeft) != Double.doubleToLongBits(other.paddingLeft)) {
            return false;
        }
        if (Double.doubleToLongBits(this.paddingRight) != Double.doubleToLongBits(other.paddingRight)) {
            return false;
        }
        if (Double.doubleToLongBits(this.paddingTop) != Double.doubleToLongBits(other.paddingTop)) {
            return false;
        }
        if (this.vert_alignment == null ? other.vert_alignment != null : !this.vert_alignment.equals(other.vert_alignment)) {
            return false;
        }
        if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
            return false;
        }
        return !(this.wrap == null ? other.wrap != null : !this.wrap.equals(other.wrap));
    }
}

