/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontDataCorrupt;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontNotEmbedded;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorIncompleteCharSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorLenghtMismatch;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedWidthsInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMissingOrIncompleteWidthsArray;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTextNotMappedToUnicode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFontDescriptor;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFontDescriptor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.TrueTypeFontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.UnembeddedFontInfo;
import java.io.IOException;
import java.util.HashSet;

class Type1FontProcessor {
    Type1FontProcessor() {
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> processType1FontErrors(PDFFont font, PDFA2ConversionHandler conversionHandler, HashSet<Integer> referencedCharCodes, PDFA2ConformanceLevel conformanceLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        PDFFontDescriptor fDesc;
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        if (font == null) {
            return errorCodes;
        }
        if (!font.getSubtype().equals(ASName.k_Type1)) {
            return errorCodes;
        }
        int objectNumber = font.getCosObject().getObjNum();
        int genNumber = font.getCosObject().getObjGen();
        CosObject fontTypeCosObj = font.getCosDictionary().get(ASName.k_Type);
        String fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
        FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFont(fontType, objectNumber, genNumber), new PDFA2FontErrorTypeAbsentInFont(objectNumber, genNumber));
        PDFFontSimple type1Font = (PDFFontSimple)font;
        if (PDFFontUtils.isSubsetFont(font) && (fDesc = type1Font.getFontDescriptor()) != null) {
            ASString charSet;
            PDFCosFontDescriptor desc = fDesc.getPDFCosDescriptor();
            if (desc != null) {
                Type1FontProcessor.validateFontFile(desc, errorCodes, objectNumber, genNumber);
                fontTypeCosObj = desc.getCosDictionary().get(ASName.k_Type);
                fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
                FontProcessor.setTypeErrorCodes(desc.getCosDictionary(), ASName.k_FontDescriptor, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFontDescriptor(fontType, desc.getCosDictionary().getObjNum(), desc.getCosDictionary().getObjGen()), new PDFA2FontErrorTypeAbsentInFontDescriptor(desc.getCosDictionary().getObjNum(), desc.getCosDictionary().getObjGen()));
            }
            if ((charSet = fDesc.getCharSet()) != null) {
                try {
                    Font afeFont = type1Font.getAFEFont();
                    if (afeFont == null) {
                        return errorCodes;
                    }
                    PDFFontDescription fontDesc = afeFont.getPDFFontDescription();
                    if (fontDesc == null) {
                        return errorCodes;
                    }
                    String charSetStr = charSet.asString();
                    int numGlyphsInFont = fontDesc.getNumGlyphs();
                    String[] charSetNames = charSetStr.split("/");
                    for (int i = 0; i <= numGlyphsInFont - 1; ++i) {
                        String glyphName = fontDesc.getGlyphName(i);
                        if (".notdef".equals(glyphName)) continue;
                        boolean found = false;
                        for (int j = 0; j < charSetNames.length; ++j) {
                            if (!charSetNames[j].equals(glyphName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        errorCodes.addErrorCode(new PDFA2FontErrorIncompleteCharSet(objectNumber, genNumber));
                        break;
                    }
                }
                catch (FontEngineException e3) {
                    errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
                }
            }
        }
        if (conversionHandler != null && errorCodes.errorCodeSet(PDFA2FontErrorIncompleteCharSet.class)) {
            boolean charsetEmbedSuccess = false;
            try {
                charsetEmbedSuccess = FontProcessorUtils.embedCharSet(type1Font, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!charsetEmbedSuccess) {
                type1Font.getFontDescriptor().setCharSet(null);
            }
            errorCodes.unSetErrorCode(PDFA2FontErrorIncompleteCharSet.class);
            if (!conversionHandler.charSetUpdatedInType1Font(font)) {
                return null;
            }
        }
        FontProcessorUtils.processToUnicodeRequirement(conversionHandler, referencedCharCodes, errorCodes, type1Font, conformanceLevel);
        return errorCodes;
    }

    private static void validateFontFile(PDFCosFontDescriptor desc, PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes, int objectNumber, int genNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontFile fontFile = desc.getFontFile();
        int QUESTION_MARK = 37;
        int EXCLAMETION_MARK = 33;
        if (fontFile != null) {
            long len1 = fontFile.getLength1();
            long len2 = fontFile.getLength2();
            long len3 = fontFile.getLength3();
            long len = 0L;
            try {
                InputByteStream stream = fontFile.getStream();
                int streamLen = 0;
                int streamData1 = stream.read();
                int streamData2 = stream.read();
                while (streamData1 != QUESTION_MARK || streamData2 != EXCLAMETION_MARK) {
                    streamData1 = streamData2;
                    streamData2 = stream.read();
                    ++streamLen;
                }
                len = fontFile.getStream().length();
                len -= (long)streamLen;
            }
            catch (IOException stream) {
                // empty catch block
            }
            long sumLen = len1 + len2 + len3;
            if (Math.abs(sumLen - len) > 2L) {
                errorCodes.addErrorCode(new PDFA2FontErrorLenghtMismatch(objectNumber, genNumber));
            }
        }
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> embedType1Font(PDFFontSimple font, UnembeddedFontInfo ufInfo, PDFA2ConversionHandler conversionHandler, FontContext fontContext, PDFA2ConformanceLevel conformance) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        boolean success;
        if (ufInfo == null) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = ufInfo.getError();
        if (font == null) {
            return errorCodes;
        }
        if (font.getSubtype() == ASName.k_TrueType) {
            errorCodes.mergeErrorSet(TrueTypeFontProcessor.processTrueTypeFontErrors(font, conversionHandler, null, conformance));
        }
        if (!(success = FontProcessorUtils.embedType1Font(font, ufInfo))) {
            return errorCodes;
        }
        if (success) {
            if (errorCodes.errorCodeSet(PDFA2FontErrorFontNotEmbedded.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorFontNotEmbedded.class);
                if (!conversionHandler.fontEmbedded(font)) {
                    return null;
                }
            }
            boolean charsetEmbedSuccess = false;
            try {
                charsetEmbedSuccess = FontProcessorUtils.embedCharSet(font, ufInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!charsetEmbedSuccess) {
                font.getFontDescriptor().setCharSet(null);
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorIncompleteCharSet.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorIncompleteCharSet.class);
                if (!conversionHandler.charSetUpdatedInType1Font(font)) {
                    return null;
                }
            }
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorTextNotMappedToUnicode.class)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorTextNotMappedToUnicode.class);
            FontProcessorUtils.processToUnicodeRequirement(conversionHandler, ufInfo.getCharCodes(), errorCodes, font, conformance);
        }
        FontProcessorUtils.embedWidthsArray(font, ufInfo, fontContext, null);
        if (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedWidthsInfo.class) || errorCodes.errorCodeSet(PDFA2FontErrorMissingOrIncompleteWidthsArray.class)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedWidthsInfo.class);
            errorCodes.unSetErrorCode(PDFA2FontErrorMissingOrIncompleteWidthsArray.class);
            if (!conversionHandler.widthsMetricsUpdated(font)) {
                return null;
            }
        }
        return errorCodes;
    }
}

