/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFABookmarkErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetBookmark
extends PDFAErrorSet {
    public PDFAErrorSetBookmark() {
        super(PDFABookmarkErrorCode.class);
    }

    public PDFAErrorSetBookmark(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean actionNotAllowed() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionNotAllowed);
    }

    public boolean actionLaunchPresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionLaunchNotAllowed);
    }

    public boolean actionSoundPresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionSoundNotAllowed);
    }

    public boolean actionMoviePresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionMovieNotAllowed);
    }

    public boolean actionResetFormNotPresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionResetFormNotAllowed);
    }

    public boolean actionImportDataPresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionImportDataNotAllowed);
    }

    public boolean actionJavaScriptPresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionJavaScriptNotAllowed);
    }

    public boolean actionSetStatePresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionSetStateNotAllowed);
    }

    public boolean actionNoOpPresent() {
        return this.errorCodeSet(PDFABookmarkErrorCode.actionNoOpNotAllowed);
    }

    public boolean nullPageAsDestination() {
        return this.errorCodeSet(PDFABookmarkErrorCode.nullPageAsDestination);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFABookmarkErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.actionNotAllowed()) {
            violations.add("action not allowed");
        }
        if (this.actionLaunchPresent()) {
            violations.add("action launch not allowed");
        }
        if (this.actionSoundPresent()) {
            violations.add("action sound not allowed");
        }
        if (this.actionMoviePresent()) {
            violations.add("action movie not allowed");
        }
        if (this.actionResetFormNotPresent()) {
            violations.add("action resetform not allowed");
        }
        if (this.actionImportDataPresent()) {
            violations.add("action import data not allowed");
        }
        if (this.actionJavaScriptPresent()) {
            violations.add("action javascript not allowed");
        }
        if (this.actionSetStatePresent()) {
            violations.add("action set state not allowed");
        }
        if (this.actionNoOpPresent()) {
            violations.add("action no-op not allowed");
        }
        if (this.nullPageAsDestination()) {
            violations.add("destination for action specifies invalid page");
        }
        return super.toString() + " " + violations;
    }
}

