/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.StatefulOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetails;
import java.util.List;
import java.util.Map;

class FontDetailsCollectionOperatorHandler
extends StatefulOperatorHandler {
    private Map<PDFFont, EmbeddedFontDetails> fontDetailsMap;

    protected FontDetailsCollectionOperatorHandler(PDFPage page, Map<PDFFont, EmbeddedFontDetails> fontDetailsMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(page);
        this.fontDetailsMap = fontDetailsMap;
    }

    @Override
    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.processXObject(name, instruction, null);
    }

    @Override
    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.Tj(string, instruction);
        this.handleASString(string);
    }

    @Override
    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.SingleQuote(string, instruction);
        this.handleASString(string);
    }

    @Override
    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.DoubleQuote(wordSpacing, charSpacing, string, instruction);
        this.handleASString(string);
    }

    @Override
    public void TJ(ASArray array, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.TJ(array, instruction);
        for (ASObject o : array) {
            if (o instanceof ASNumber || !(o instanceof ASString)) continue;
            this.handleASString((ASString)o);
        }
    }

    private void handleASString(ASString asString) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextState tstate = ((GState)this.gStateStack.peek()).getTextState();
        if (tstate != null) {
            PDFFont pdfFont = tstate.getFont();
            if (pdfFont instanceof PDFFontType3) {
                return;
            }
            if (pdfFont != null && PDFFontUtils.isFontEmbedded(pdfFont)) {
                EmbeddedFontDetails embeddedFontDetails = this.fontDetailsMap.get(pdfFont);
                if (embeddedFontDetails == null) {
                    embeddedFontDetails = new EmbeddedFontDetails(pdfFont);
                    this.fontDetailsMap.put(pdfFont, embeddedFontDetails);
                }
                List charCodes = pdfFont.getCharCodes(asString.getBytes(), true);
                int count = charCodes.size();
                for (int j = 0; j < count; ++j) {
                    byte[] charCodeBytes = (byte[])((List)charCodes.get(j)).get(0);
                    int[] unicodes = (int[])((List)charCodes.get(j)).get(1);
                    int charCodeInt = (int)PDFCMapUtils.getCharCode(charCodeBytes);
                    try {
                        embeddedFontDetails.addGlyphIdentifiers(charCodeBytes, unicodes, pdfFont.charCode2gid(charCodeInt));
                        continue;
                    }
                    catch (PDFFontException e) {
                        throw new PDFInvalidDocumentException("Exception occured while getting glyphId for " + pdfFont, e);
                    }
                }
            }
        }
    }
}

