/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureClassMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentFactory;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentIterator;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentScalar;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureIDTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCR;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureParentTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.interchange.structure.StructureUtil;
import com.adobe.internal.pdftoolkit.services.manipulations.MaxMcid;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.LimittedAllocationMap;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PDFPageWrapperSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PMMStructure {
    private static final char PERIOD = '.';
    private static final ASName[] specialElementKeys = new ASName[]{ASName.k_S, ASName.k_P, ASName.k_Pg, ASName.k_K, ASName.k_C};
    private static final ASName[] specialContentKeys = new ASName[]{ASName.k_Pg, ASName.k_Stm, ASName.k_StmOwn, ASName.k_Obj, ASName.k_MCID};
    private PDFDocument inDoc;
    private CosCloneMgr cloneHandler;
    private PDFStructureRoot structRoot;
    private PDFStructureParentTree parentTree;
    private PDFStructureIDTree idTree;

    PMMStructure(PDFDocument doc, CosCloneMgr clonehandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.inDoc = doc;
        this.cloneHandler = clonehandler;
        this.structRoot = this.inDoc.requireCatalog().getStructureRoot();
        if (this.structRoot != null) {
            this.parentTree = this.structRoot.getParentTree();
            this.idTree = this.structRoot.getIdTree();
        }
    }

    void deleteStructure(ArrayList<PDFPage> pages, PDFPageWrapperSet pageWrapperSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pages == null || this.structRoot == null) {
            return;
        }
        ArrayList<PDFStructureContentInterface> deletedElements = new ArrayList<PDFStructureContentInterface>();
        DeleteElement deleteAction = new DeleteElement(pageWrapperSet, deletedElements);
        PDFStructureContentInterface rootContent = this.structRoot.getContent();
        if (rootContent == null) {
            return;
        }
        PDFStructureContentIterator contentIterator = rootContent.contentIterator();
        while (contentIterator.hasNext()) {
            try {
                this.walkStructureElementsTree(this.structRoot, contentIterator.next(), deleteAction);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid structure", e);
            }
        }
        if (deletedElements.isEmpty()) {
            return;
        }
        this.deleteParents(pages);
        int elemInd = 0;
        while (elemInd < deletedElements.size()) {
            PDFStructureElement deletedElem = (PDFStructureElement)deletedElements.get(elemInd++);
            this.deleteIDs(deletedElem);
            this.deleteElement(deletedElem);
        }
    }

    Map appendStructure(PMMStructure srcStruct, Map<PDFPage, PDFPage> allPages, Map<PDFAnnotation, PDFAnnotation> allAnnots, Map<PDFFieldNode, PDFFieldNode> allFields, Map<PDFXObject, PDFXObject> allXObjects, Map<PDFBookmarkNode, PDFBookmarkNode> allBookmarks, int addMCID, MaxMcid m) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (srcStruct.getRootNode() == null) {
            return null;
        }
        boolean hadStructure = this.structRoot != null;
        Map<ASName, ASName> roleMapping = this.appendRoleMap(srcStruct);
        Map<ASName, ASName> classMapping = this.appendClassMap(srcStruct);
        AppendStructure appendElement = new AppendStructure(allPages, allAnnots, allFields, allXObjects, roleMapping, classMapping, addMCID, m);
        PDFStructureContentInterface rootKids = srcStruct.getRootNode().getContent();
        if (rootKids == null) {
            return null;
        }
        PDFStructureContentIterator srcIterator = rootKids.contentIterator();
        while (srcIterator.hasNext()) {
            try {
                this.walkStructureElementsTree(this.structRoot, srcIterator.next(), appendElement);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid structure", e);
            }
        }
        LimittedAllocationMap allElements = appendElement.getElementsMapping();
        if (allElements.isEmpty() && !hadStructure) {
            this.structRoot = null;
            this.inDoc.requireCatalog().setStructureRoot(this.structRoot);
        } else {
            this.fixStructParents(srcStruct, allPages, allXObjects, allAnnots, allElements, allBookmarks);
        }
        return classMapping;
    }

    void extractStructure(PMMStructure srcStruct, Map<PDFPage, PDFPage> allPages, Map<PDFFieldNode, PDFFieldNode> allFields, Map<PDFAnnotation, PDFAnnotation> allAnnots, Map<PDFXObject, PDFXObject> allXObjects, Map<PDFBookmarkNode, PDFBookmarkNode> allBookmarks) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (srcStruct.getRootNode() == null) {
            return;
        }
        ExtractStructure extractElements = new ExtractStructure(allPages, allAnnots, allFields, allXObjects);
        PDFStructureContentInterface rootKids = srcStruct.getRootNode().getContent();
        if (rootKids == null) {
            return;
        }
        PDFStructureContentIterator srcIterator = rootKids.contentIterator();
        while (srcIterator.hasNext()) {
            try {
                this.walkStructureElementsTree(this.structRoot, srcIterator.next(), extractElements);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid structure", e);
            }
        }
        LimittedAllocationMap allElements = extractElements.getElementsMapping();
        if (this.structRoot != null && !allElements.containsKey(srcStruct.getRootNode())) {
            allElements.put(srcStruct.getRootNode(), this.structRoot);
        }
        if (!allElements.isEmpty()) {
            this.appendRoleMap(srcStruct);
            this.appendClassMap(srcStruct);
            this.fixStructParents(srcStruct, allPages, allXObjects, allAnnots, allElements, allBookmarks);
        }
    }

    Map<ASName, ASName> appendRoleMap(PMMStructure srcStruct) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureRoleMap srcRoleMap = srcStruct.getRootNode().getRoleMap();
        Map<ASName, ASName> roleMapping = null;
        if (srcRoleMap != null) {
            if (this.structRoot == null) {
                this.structRoot = PDFStructureRoot.newInstance(this.inDoc);
            }
            PDFStructureRoleMap curRoleMap = this.getRootNode().getRoleMap();
            roleMapping = this.reconcileRoleMaps(srcStruct);
            if (curRoleMap == null) {
                curRoleMap = PDFStructureRoleMap.newInstance(this.inDoc);
                this.getRootNode().setRoleMap(curRoleMap);
            }
            Iterator<ASName> roleIterator = srcRoleMap.getCosDictionary().keyIterator();
            while (roleIterator.hasNext()) {
                ASName keyName = roleIterator.next();
                ASName valueName = srcRoleMap.getDictionaryNameValue(keyName);
                if (roleMapping != null) {
                    if (roleMapping.containsKey(keyName)) {
                        keyName = roleMapping.get(keyName);
                    }
                    if (roleMapping.containsKey(valueName)) {
                        valueName = roleMapping.get(valueName);
                    }
                }
                if (curRoleMap.dictionaryContains(keyName)) continue;
                curRoleMap.addRole(keyName, valueName);
            }
        }
        return roleMapping;
    }

    Map<ASName, ASName> appendClassMap(PMMStructure srcStruct) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureClassMap srcClassMap = srcStruct.getRootNode().getClassMap();
        Map<ASName, ASName> classMapping = null;
        if (srcClassMap != null) {
            if (this.structRoot == null) {
                this.structRoot = PDFStructureRoot.newInstance(this.inDoc);
            }
            PDFStructureClassMap curClassMap = this.getRootNode().getClassMap();
            classMapping = this.reconcileClassMaps(srcStruct);
            if (curClassMap == null) {
                curClassMap = PDFStructureClassMap.newInstance(this.inDoc);
                this.getRootNode().setClassMap(curClassMap);
            }
            PMMStructure.cloneClassMap(this.cloneHandler, srcClassMap, curClassMap, classMapping);
        }
        return classMapping;
    }

    static void cloneClassMap(CosCloneMgr cloneHandler, PDFStructureClassMap srcClassMap, PDFStructureClassMap targetClassMap, Map<ASName, ASName> classMapping) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary srcClassMapObj = srcClassMap.getCosDictionary();
        List<ASName> srcKeys = srcClassMapObj.getKeys();
        for (ASName keyName : srcKeys) {
            CosObject attrClass = srcClassMapObj.get(keyName);
            if (classMapping != null && classMapping.containsKey(keyName)) {
                ASName classKeyName = classMapping.get(keyName);
                if (keyName == classKeyName) continue;
                targetClassMap.addAttrClass(classKeyName, cloneHandler.clone(attrClass));
                continue;
            }
            targetClassMap.addAttrClass(keyName, cloneHandler.clone(attrClass));
        }
    }

    Map<ASName, ASName> reconcileRoleMaps(PMMStructure srcStruct) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap<ASName, ASName> mapRoles = new HashMap<ASName, ASName>();
        PDFStructureRoleMap curRoleMap = this.getRootNode().getRoleMap();
        if (curRoleMap == null) {
            return null;
        }
        String suffix = this.getNameSuffix(curRoleMap.collectRoles());
        PDFStructureRoleMap srcRoleMap = srcStruct.getRootNode().getRoleMap();
        Iterator<ASName> rolesIterator = curRoleMap.getCosDictionary().keyIterator();
        while (rolesIterator.hasNext()) {
            ASName srcValue;
            ASName curRole = rolesIterator.next();
            if (srcRoleMap.dictionaryContains(curRole) && !srcRoleMap.getDictionaryNameValue(curRole).equals(curRoleMap.getDictionaryNameValue(curRole))) {
                mapRoles.put(curRole, this.appendNameSuffix(curRole, suffix));
            }
            if ((srcValue = srcRoleMap.getDictionaryNameValue(curRole)) == null) continue;
            srcValue.hashCode();
        }
        return mapRoles;
    }

    Map<ASName, ASName> reconcileClassMaps(PMMStructure srcStruct) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap<ASName, ASName> mapAttrClasses = new HashMap<ASName, ASName>();
        PDFStructureClassMap curClassMap = this.getRootNode().getClassMap();
        if (curClassMap == null) {
            return null;
        }
        LinkedHashSet curAttrClasses = curClassMap.collectAttributeClasses();
        if (curAttrClasses == null) {
            return null;
        }
        String suffix = this.getNameSuffix(curAttrClasses);
        PDFStructureClassMap srcClassMap = srcStruct.getRootNode().getClassMap();
        LinkedHashSet srcAttrClasses = srcClassMap.collectAttributeClasses();
        if (srcAttrClasses != null) {
            for (ASName curAttrClass : curAttrClasses) {
                CosObject curAttrClassValue = curClassMap.getDictionaryValue(curAttrClass);
                if (!srcAttrClasses.contains(curAttrClass)) continue;
                if (curAttrClassValue != null && curAttrClassValue.equals(srcClassMap.getDictionaryValue(curAttrClass))) {
                    mapAttrClasses.put(curAttrClass, curAttrClass);
                    continue;
                }
                mapAttrClasses.put(curAttrClass, this.appendNameSuffix(curAttrClass, suffix));
            }
        }
        return mapAttrClasses;
    }

    PDFStructureRoot getRootNode() {
        return this.structRoot;
    }

    void replaceMCIDs(PDFXObjectForm xObject, int addMCID, HashSet seenObjects, MaxMcid maxMcid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xObject == null) {
            return;
        }
        if (seenObjects.contains(xObject)) {
            return;
        }
        seenObjects.add(xObject);
        Content oldContent = Content.newInstance(xObject);
        Content newContent = this.replaceMCIDs(oldContent, addMCID, seenObjects, maxMcid);
        xObject.setStream(newContent.getContentStream());
    }

    private Content replaceMCIDs(Content content, int addMCID, HashSet seenObjects, MaxMcid maxMcid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (addMCID == 0 || content == null) {
            return content;
        }
        PDFContents oldContents = content.getContents();
        if (oldContents == null) {
            return null;
        }
        if (seenObjects.contains(oldContents)) {
            return content;
        }
        seenObjects.add(oldContents);
        ModifiableContent newContent = ModifiableContent.newInstance(oldContents.getPDFDocument());
        StructureUtil.updateMCID(content, newContent, addMCID);
        PDFResources resources = content.getResources();
        PDFXObjectMap xObjects = resources.getXObjectMap();
        if (xObjects != null) {
            for (ASName key : xObjects.keySet()) {
                PDFXObject curXObject = xObjects.get(key);
                if (!(curXObject instanceof PDFXObjectForm)) continue;
                this.replaceMCIDs((PDFXObjectForm)curXObject, addMCID, seenObjects, maxMcid);
            }
        }
        return newContent;
    }

    private String getNameSuffix(Set<ASName> names) {
        int suffix = -1;
        if (names != null) {
            Iterator<ASName> namesIterator = names.iterator();
            while (namesIterator.hasNext()) {
                String curName = namesIterator.next().asString(true);
                int periodPos = curName.lastIndexOf(46);
                if (periodPos == -1) continue;
                try {
                    String suffixStr = curName.substring(periodPos + 1);
                    if (suffixStr == null) continue;
                    suffix = Math.max(suffix, Integer.parseInt(suffixStr));
                }
                catch (Exception exception) {}
            }
        }
        StringBuilder suffixBuf = new StringBuilder();
        suffixBuf.append('.');
        suffixBuf.append(Integer.toString(suffix + 1));
        return suffixBuf.toString();
    }

    private ASName appendNameSuffix(ASName name, String suffix) {
        StringBuilder nameStr = new StringBuilder(name.asString(true));
        nameStr.append(suffix);
        return ASName.create(nameStr.toString());
    }

    private void deleteParents(ArrayList pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (int pagesInd = 0; pagesInd < pages.size(); ++pagesInd) {
            PDFPage curPage = (PDFPage)pages.get(pagesInd);
            PDFAnnotationList annotations = curPage.getAnnotationList();
            if (annotations != null) {
                for (int annotInd = 0; annotInd < annotations.size(); ++annotInd) {
                    PDFAnnotation pdfAnnot = annotations.get(annotInd);
                    if (pdfAnnot == null) continue;
                    this.removeParentEntry(this.getStructParents(pdfAnnot.getCosDictionary()));
                }
            }
            this.removeParentEntry(this.getStructParents(curPage.getCosDictionary()));
        }
    }

    CosNumeric getStructParents(CosDictionary item) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (item == null) {
            return null;
        }
        CosNumeric parent = (CosNumeric)item.get(ASName.k_StructParent);
        if (parent == null) {
            parent = (CosNumeric)item.get(ASName.k_StructParents);
        }
        return parent;
    }

    PDFStructureContentInterface removeParentEntry(CosNumeric parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureContentInterface parentElement = null;
        if (parent != null && this.parentTree != null) {
            parentElement = (PDFStructureContentInterface)this.parentTree.getEntry(parent.intValue());
            this.parentTree.removeEntry(parent.intValue());
            if (this.parentTree.isEmpty()) {
                this.structRoot.removeParentTree();
                this.parentTree = null;
            }
        }
        return parentElement;
    }

    private void deleteIDs(PDFStructureElement deleteElem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString id;
        if (this.structRoot != null && this.idTree != null && (id = deleteElem.getID()) != null) {
            this.idTree.removeEntry(id);
        }
    }

    void deleteElement(PDFStructureElement deleteElem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.structRoot != null && deleteElem != null) {
            PDFStructureNode parent = deleteElem.getParent();
            PDFStructureContentInterface parentContent = parent.getContent();
            if (parentContent == null) {
                return;
            }
            if (parentContent.getStructureType().equals(PDFStructureType.Array)) {
                ((PDFStructureContentArray)parentContent).remove(deleteElem);
                if (((PDFStructureContentArray)parentContent).size() == 0) {
                    parent.removeKids();
                }
            } else if (PDFUtil.isPDFCosObjectRefEqual(parentContent.getPDFCosObject(), deleteElem.getPDFCosObject())) {
                parent.removeKids();
            }
        }
    }

    private void fixStructParents(PMMStructure srcStruct, Map<PDFPage, PDFPage> pagesMapping, Map<PDFXObject, PDFXObject> xObjectMapping, Map<PDFAnnotation, PDFAnnotation> allAnnots, LimittedAllocationMap mapElements, Map<PDFBookmarkNode, PDFBookmarkNode> allBookmarks) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFStructureParentTree srcParentTree = srcStruct.getRootNode().getParentTree();
        if (srcParentTree == null) {
            return;
        }
        for (Map.Entry<PDFPage, PDFPage> entry : pagesMapping.entrySet()) {
            int key;
            PDFStructureContentInterface clonedParent;
            PDFPage srcPage = entry.getKey();
            if (!srcPage.dictionaryContains(ASName.k_StructParents) || (clonedParent = this.cloneParentRef(srcPage, srcParentTree, mapElements)) == null) continue;
            try {
                key = this.getRootNode().addParentTree(clonedParent) - 1;
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid structure", e);
            }
            PDFStructureUtils.setStructParents(key, (PDFCosDictionary)entry.getValue());
        }
        if (allAnnots != null) {
            for (Map.Entry<PDFAnnotation, PDFAnnotation> entry : allAnnots.entrySet()) {
                int key;
                PDFStructureContentInterface clonedParent;
                PDFAnnotation srcAnnot = entry.getKey();
                if (!srcAnnot.dictionaryContains(ASName.k_StructParent) || (clonedParent = this.cloneParentRef(srcAnnot, srcParentTree, mapElements)) == null) continue;
                try {
                    key = this.getRootNode().addParentTree(clonedParent) - 1;
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException("Invalid structure", e);
                }
                PDFAnnotation clonedAnnot = entry.getValue();
                clonedAnnot.setDictionaryIntValue(ASName.k_StructParent, key);
            }
        }
        this.fixIDTree(srcStruct, mapElements);
        if (xObjectMapping != null) {
            for (PDFXObject srcXObj : xObjectMapping.keySet()) {
                int key;
                PDFStructureContentInterface clonedParent;
                if (!(srcXObj instanceof PDFXObjectForm)) continue;
                PDFXObjectForm srcForm = (PDFXObjectForm)srcXObj;
                PDFXObjectForm clonedForm = (PDFXObjectForm)xObjectMapping.get(srcForm);
                if (srcForm.dictionaryContains(ASName.k_StructParent)) {
                    clonedParent = this.cloneParentRef(srcForm, srcParentTree, mapElements);
                    if (clonedParent == null) continue;
                    try {
                        key = this.getRootNode().addParentTree(clonedParent) - 1;
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new PDFInvalidDocumentException("Invalid structure", e);
                    }
                    clonedForm.setDictionaryIntValue(ASName.k_StructParent, key);
                    continue;
                }
                if (!srcForm.dictionaryContains(ASName.k_StructParents) || (clonedParent = this.cloneParentRef(srcForm, srcParentTree, mapElements)) == null) continue;
                try {
                    key = this.getRootNode().addParentTree(clonedParent) - 1;
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException("Invalid structure", e);
                }
                clonedForm.setDictionaryIntValue(ASName.k_StructParents, key);
            }
        }
        if (allBookmarks != null) {
            for (PDFBookmarkNode srcMark : allBookmarks.keySet()) {
                if (!(srcMark instanceof PDFBookmark) || !((PDFBookmark)srcMark).hasStructureElement()) continue;
                PDFStructureElement refElement = (PDFStructureElement)mapElements.get(((PDFBookmark)srcMark).getStructureElement());
                PDFBookmark clonedBookmark = (PDFBookmark)allBookmarks.get(srcMark);
                clonedBookmark.setStructureElement(refElement);
            }
        }
    }

    private void fixIDTree(PMMStructure srcStruct, LimittedAllocationMap mapElements) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        boolean newIDTree = false;
        ArrayList<Object> clonedElemsList = new ArrayList<Object>();
        int elemsInd = 0;
        PDFStructureIDTree srcIDTree = srcStruct.getRootNode().getIdTree();
        if (srcIDTree == null) {
            return;
        }
        ASString suffix = null;
        Iterator<PDFTree.Entry> idIterator = srcIDTree.iterator();
        while (idIterator.hasNext()) {
            PDFTree.Entry srcID = idIterator.next();
            ASString key = (ASString)srcID.getKey();
            if (this.idTree == null) {
                this.idTree = PDFStructureIDTree.newInstance(this.inDoc);
                newIDTree = true;
            }
            key = StructureUtil.checkID(key, suffix, this.idTree);
            PDFStructureElement srcElem = (PDFStructureElement)srcID.getValue();
            PDFStructureElement clonedElem = (PDFStructureElement)mapElements.get(srcElem);
            if (clonedElem == null) continue;
            clonedElem.setID(key);
            clonedElemsList.add(elemsInd++, key);
            clonedElemsList.add(elemsInd++, clonedElem);
        }
        if (!clonedElemsList.isEmpty()) {
            Iterator elemsIter = clonedElemsList.iterator();
            while (elemsIter.hasNext()) {
                ASString elemKey = (ASString)elemsIter.next();
                PDFStructureElement elem = (PDFStructureElement)elemsIter.next();
                this.idTree.addEntry(elemKey, elem);
            }
            if (newIDTree) {
                this.structRoot.setIDTree(this.idTree);
            }
        }
    }

    private PDFStructureContentInterface cloneParentRef(PDFCosDictionary dict, PDFStructureParentTree srcParentTree, LimittedAllocationMap allElements) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int key = -1;
        key = dict.dictionaryContains(ASName.k_StructParent) ? dict.getDictionaryIntValue(ASName.k_StructParent).intValue() : dict.getDictionaryIntValue(ASName.k_StructParents).intValue();
        if (key == -1) {
            return null;
        }
        PDFStructureContentInterface parentStructureEntry = (PDFStructureContentInterface)srcParentTree.getEntry(key);
        if (parentStructureEntry == null) {
            return null;
        }
        CosObject parent = parentStructureEntry.getCosObject();
        if (parent == null) {
            return null;
        }
        if (parent.getType() == 5) {
            PDFStructureContentArray clonedParent = PDFStructureContentArray.getInstance(this.inDoc.getCosDocument().createCosArray());
            for (int arrayInd = 0; arrayInd < ((CosArray)parent).size(); ++arrayInd) {
                PDFStructureElement clonedElement;
                CosObject page;
                PDFStructureElement srcElement = PDFStructureElement.getInstance(((CosArray)parent).get(arrayInd));
                if (dict instanceof PDFPage && srcElement != null && (page = ((CosDictionary)srcElement.getCosObject()).get(ASName.k_Pg)) != null && page.getObjNum() != dict.getCosObject().getObjNum()) {
                    boolean flag = false;
                    CosObject kArr = ((CosDictionary)srcElement.getCosObject()).get(ASName.k_K);
                    if (!(kArr instanceof CosArray)) continue;
                    if (((CosArray)kArr).size() > 1) {
                        Iterator<CosObject> itr = ((CosArray)kArr).iterator();
                        while (itr.hasNext()) {
                            CosObject page2;
                            CosObject obj = itr.next();
                            if (!(obj instanceof CosDictionary) || (page2 = ((CosDictionary)obj).get(ASName.k_Pg)) == null || page2.getObjNum() != dict.getCosObject().getObjNum()) continue;
                            flag = true;
                            break;
                        }
                        if (!flag) continue;
                    }
                }
                if ((clonedElement = (PDFStructureElement)allElements.get(srcElement != null ? srcElement.getPDFCosObject() : null)) != null) {
                    clonedParent.addContent(clonedElement);
                    continue;
                }
                clonedParent.getCosArray().add(this.inDoc.getCosDocument().createCosNull());
            }
            if (clonedParent.isEmpty()) {
                return null;
            }
            return clonedParent;
        }
        return (PDFStructureElement)allElements.get(PDFStructureElement.getInstance(parent));
    }

    private PDFStructureContentInterface walkStructureElementsTree(PDFStructureNode parent, PDFStructureContentInterface startElem, ElementOperation action) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (startElem == null) {
            return null;
        }
        if (!action.conditionAction(startElem)) {
            action.setMark(false);
            return null;
        }
        PDFStructureContentInterface cloned = action.firstAction(parent, startElem);
        if (cloned == null) {
            return null;
        }
        if (!startElem.getStructureType().equals(PDFStructureType.Element)) {
            return startElem;
        }
        PDFStructureElement curElem = (PDFStructureElement)startElem;
        PDFStructureContentInterface content = curElem.getContent();
        if (content == null) {
            return action.lastAction(parent, curElem);
        }
        PDFStructureContentIterator iter = content.contentIterator();
        PDFStructureElement found = curElem;
        while (iter.hasNext()) {
            PDFStructureContentInterface childContent = null;
            PDFStructureContentInterface curContent = iter.next();
            childContent = this.walkStructureElementsTree((PDFStructureElement)cloned, curContent, action);
            if (childContent == null) {
                found = null;
                continue;
            }
            if (childContent.getStructureType() != PDFStructureType.Element) continue;
            action.lastAction(parent, childContent);
        }
        return found;
    }

    private class AppendStructure
    implements ElementOperation {
        protected Map<CosObject, CosObject> cloneMapping;
        protected Map<ASName, ASName> mRoleMapping;
        protected Map<ASName, ASName> mClassMapping;
        protected LimittedAllocationMap mClonedElements;
        protected Map<PDFPage, PDFPage> mPagesMapping;
        protected Map<PDFXObject, PDFXObject> mXObjectsMapping;
        protected Map<PDFAnnotation, PDFAnnotation> mAnnotationsMapping;
        protected Map<PDFFieldNode, PDFFieldNode> mFieldsMapping;
        protected boolean marked;
        protected PDFDocument mTargetDoc;
        protected int mAddMCID;
        private MaxMcid maxMcid;
        private static final float MAP_LOAD_FACTOR = 0.75f;

        AppendStructure(Map<PDFPage, PDFPage> mapPages, Map<PDFAnnotation, PDFAnnotation> mapAnnots, Map<PDFFieldNode, PDFFieldNode> mapFields, Map<PDFXObject, PDFXObject> mapXObjects, Map<ASName, ASName> mapRoles, Map<ASName, ASName> mapClasses, int addMCID, MaxMcid maxMcid) {
            this.mTargetDoc = PMMStructure.this.inDoc;
            int cloneSize = mapPages == null ? 0 : mapPages.size();
            cloneSize += mapAnnots == null ? 0 : mapAnnots.size();
            cloneSize += mapFields == null ? 0 : mapFields.size();
            cloneSize += mapXObjects == null ? 0 : mapXObjects.size();
            cloneSize = (int)((double)cloneSize / 0.75 + 1.0);
            this.cloneMapping = new HashMap<CosObject, CosObject>(cloneSize, 0.75f);
            this.insertCosObjects(this.cloneMapping, mapPages);
            this.insertCosObjects(this.cloneMapping, mapFields);
            this.insertCosObjects(this.cloneMapping, mapAnnots);
            this.insertCosObjects(this.cloneMapping, mapXObjects);
            this.mPagesMapping = mapPages;
            this.mXObjectsMapping = mapXObjects;
            if (this.mXObjectsMapping == null) {
                this.mXObjectsMapping = new HashMap<PDFXObject, PDFXObject>();
            }
            this.mAnnotationsMapping = mapAnnots;
            if (this.mAnnotationsMapping == null) {
                this.mAnnotationsMapping = new HashMap<PDFAnnotation, PDFAnnotation>();
            }
            this.mFieldsMapping = mapFields;
            if (this.mFieldsMapping == null) {
                this.mFieldsMapping = new HashMap<PDFFieldNode, PDFFieldNode>();
            }
            this.mClonedElements = new LimittedAllocationMap();
            this.mRoleMapping = mapRoles;
            this.mClassMapping = mapClasses;
            this.mAddMCID = addMCID;
            this.maxMcid = maxMcid;
        }

        private final <A extends PDFCosObject, B extends PDFCosObject> void insertCosObjects(Map<CosObject, CosObject> cosMap, Map<A, B> pdfMap) {
            if (cosMap == null || pdfMap == null) {
                return;
            }
            for (Map.Entry<A, B> e : pdfMap.entrySet()) {
                cosMap.put(((PDFCosObject)e.getKey()).getCosObject(), ((PDFCosObject)e.getValue()).getCosObject());
            }
        }

        @Override
        public boolean conditionAction(PDFStructureContentInterface element) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFPage curPage = element.getPage();
            if (curPage == null) {
                return true;
            }
            if (this.mPagesMapping.containsKey(curPage)) {
                this.setMark(true);
                return true;
            }
            return false;
        }

        @Override
        public PDFStructureContentInterface firstAction(PDFStructureNode parent, PDFStructureContentInterface element) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
            if (this.marked && PDFStructureType.PageContent.contains(element.getStructureType())) {
                PDFStructureElement clonedParent = this.cloneElement((PDFStructureElement)parent);
                PDFStructureContentInterface clonedContent = this.cloneScalarContent(element);
                if (clonedContent != null) {
                    clonedParent.addContent(clonedContent);
                }
            }
            return element;
        }

        @Override
        public PDFStructureContentInterface lastAction(PDFStructureNode parent, PDFStructureContentInterface element) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
            if (this.marked) {
                this.cloneElement((PDFStructureElement)element);
            }
            return element;
        }

        @Override
        public boolean setMark(boolean mark) {
            boolean oldMark = this.marked;
            this.marked = mark;
            return oldMark;
        }

        protected LimittedAllocationMap getElementsMapping() {
            return this.mClonedElements;
        }

        private PDFStructureElement cloneElement(PDFStructureElement element) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
            CosObject attrClass;
            PDFPage page;
            if (this.mClonedElements.containsKey(element)) {
                return (PDFStructureElement)this.mClonedElements.get(element);
            }
            CosDictionary srcElem = (CosDictionary)element.getCosObject();
            CosDictionary cloned = CosUtils.cloneOrdinaryKeys(this.mTargetDoc.getCosDocument(), PMMStructure.this.cloneHandler, srcElem, specialElementKeys);
            PDFStructureElement clonedElement = PDFStructureElement.getInstance(cloned);
            ASName type = srcElem.getName(ASName.k_S);
            if (type != null) {
                if (this.mRoleMapping != null && this.mRoleMapping.containsKey(type)) {
                    type = this.mRoleMapping.get(type);
                }
                cloned.put(ASName.k_S, type);
            }
            PDFStructureNode clonedParent = null;
            PDFStructureNode parent = null;
            CosDictionary parentDictionary = srcElem.getCosDictionary(ASName.k_P);
            if (parentDictionary != null) {
                parent = PDFStructureUtils.getNode(parentDictionary);
            }
            if (parent != null) {
                boolean newRoot = false;
                clonedParent = (PDFStructureNode)this.mClonedElements.get(parent);
                if (clonedParent == null) {
                    if (parent.getStructureType().equals(PDFStructureType.Root)) {
                        if (PMMStructure.this.structRoot == null) {
                            PMMStructure.this.structRoot = PDFStructureRoot.newInstance(this.mTargetDoc, clonedElement);
                            this.mClonedElements.put(parent, PMMStructure.this.structRoot);
                            newRoot = true;
                        }
                        clonedParent = PMMStructure.this.structRoot;
                    } else if (parent.getStructureType() == PDFStructureType.Element) {
                        clonedParent = this.cloneElement((PDFStructureElement)parent);
                        this.mClonedElements.put(parent, clonedParent);
                    }
                }
                if (clonedParent == null) {
                    throw new PDFInvalidDocumentException("Invalid structure");
                }
                cloned.put(ASName.k_P, clonedParent.getCosObject());
                if (!newRoot) {
                    clonedParent.addContent(clonedElement);
                }
            }
            if ((page = PDFPage.getInstance(srcElem.get(ASName.k_Pg))) != null) {
                if (this.mPagesMapping.containsKey(page)) {
                    page = this.mPagesMapping.get(page);
                }
                cloned.put(ASName.k_Pg, page.getCosObject());
            }
            if ((attrClass = srcElem.get(ASName.k_C)) != null) {
                switch (attrClass.getType()) {
                    case 5: {
                        CosArray arrayAttr = (CosArray)attrClass;
                        CosArray clonedArray = this.mTargetDoc.getCosDocument().createCosArray();
                        for (int arrayInd = 0; arrayInd < arrayAttr.size(); ++arrayInd) {
                            type = arrayAttr.getName(arrayInd);
                            if (this.mClassMapping != null && this.mClassMapping.containsKey(type)) {
                                type = this.mClassMapping.get(type);
                            }
                            clonedArray.add(arrayInd, this.mTargetDoc.getCosDocument().createCosName(type));
                        }
                        attrClass = clonedArray;
                        break;
                    }
                    case 3: {
                        type = attrClass.nameValue();
                        if (this.mClassMapping != null && this.mClassMapping.containsKey(type)) {
                            type = this.mClassMapping.get(type);
                        }
                        attrClass = this.mTargetDoc.getCosDocument().createCosName(type);
                        break;
                    }
                    default: {
                        throw new PDFInvalidDocumentException("Invalid Structure: invalid class name");
                    }
                }
                cloned.put(ASName.k_C, attrClass);
            }
            this.mClonedElements.put(element, clonedElement);
            return clonedElement;
        }

        private PDFStructureContentInterface cloneScalarContent(PDFStructureContentInterface oldContent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            Integer oldMCID;
            CosObject srcRef;
            CosStream oldStream;
            CosObject cosOwner;
            CosObject cosStm;
            if (oldContent.getStructureType() == PDFStructureType.MCID) {
                Integer oldMCID2 = ((PDFStructureMCID)oldContent).getMCID();
                int mcid = (oldMCID2 == null ? 0 : oldMCID2) + this.mAddMCID;
                this.maxMcid.updateMaxMcid(mcid);
                return PDFStructureMCID.newInstance(this.mTargetDoc, mcid);
            }
            CosDictionary clonedDict = CosUtils.cloneOrdinaryKeys(this.mTargetDoc.getCosDocument(), PMMStructure.this.cloneHandler, (CosDictionary)((PDFCosObject)((Object)oldContent)).getCosObject(), specialContentKeys);
            PDFPage srcPage = PDFPage.getInstance(((PDFStructureContentScalar)oldContent).getDictionaryCosObjectValue(ASName.k_Pg));
            if (srcPage != null) {
                PDFPage clonedPage = this.mPagesMapping.get(srcPage);
                if (clonedPage != null) {
                    clonedDict.put(ASName.k_Pg, clonedPage.getCosObject());
                } else {
                    throw new PDFInvalidDocumentException("Invalid structure: referenced page cannot be cloned.");
                }
            }
            if ((cosStm = ((CosDictionary)((PDFCosObject)((Object)oldContent)).getCosObject()).get(ASName.k_StmOwn)) != null) {
                cosOwner = this.getClonedPDFObject(cosStm);
                if (cosOwner == null) {
                    cosOwner = PMMStructure.this.cloneHandler.clone(cosStm);
                }
                if (cosOwner != null) {
                    clonedDict.put(ASName.k_StmOwn, cosOwner);
                }
            }
            if ((oldStream = (CosStream)((PDFStructureContentScalar)oldContent).getDictionaryCosObjectValue(ASName.k_Stm)) != null) {
                CosStream clonedStream;
                PDFXObjectForm oldXObject = PDFXObjectForm.getInstance(oldStream);
                CosStream cosStream = clonedStream = this.mXObjectsMapping.containsKey(oldXObject) ? this.mXObjectsMapping.get(oldXObject).getCosStream() : (CosStream)PMMStructure.this.cloneHandler.clone(oldStream);
                if (clonedStream != null) {
                    clonedDict.put(ASName.k_Stm, clonedStream);
                }
            }
            if ((srcRef = ((PDFStructureContentScalar)oldContent).getDictionaryCosObjectValue(ASName.k_Obj)) != null) {
                cosOwner = this.cloneOBJR(this.mTargetDoc, srcRef);
                if (cosOwner == null) {
                    return null;
                }
                clonedDict.put(ASName.k_Obj, cosOwner);
            }
            if (oldContent.getStructureType() == PDFStructureType.MCR && (oldMCID = ((PDFStructureMCR)oldContent).getMCID()) != null) {
                int mcid = oldMCID + this.mAddMCID;
                this.maxMcid.updateMaxMcid(mcid);
                clonedDict.put(ASName.k_MCID, mcid);
            }
            return PDFStructureContentFactory.getInstance(clonedDict);
        }

        private CosObject cloneOBJR(PDFDocument pdfDoc, CosObject cosOBJR) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
            CosObject clonedOBJR = this.getClonedPDFObject(cosOBJR);
            if (clonedOBJR != null) {
                return clonedOBJR;
            }
            if (!this.isObjectOfClonedType(pdfDoc, cosOBJR)) {
                if (cosOBJR instanceof CosScalar) {
                    clonedOBJR = PMMStructure.this.cloneHandler.clone(cosOBJR);
                } else if (cosOBJR.getType() == 5) {
                    clonedOBJR = this.cloneOBJRArray(pdfDoc, (CosArray)cosOBJR);
                } else if (cosOBJR.getType() == 6) {
                    clonedOBJR = this.cloneOBJRDict(pdfDoc, (CosDictionary)cosOBJR);
                }
            }
            return clonedOBJR;
        }

        private CosDictionary cloneOBJRDict(PDFDocument pdfDoc, CosDictionary dictOBJR) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
            CosDictionary clonedDict = null;
            Iterator<ASName> keyIter = dictOBJR.keyIterator();
            while (keyIter.hasNext()) {
                ASName curKey = keyIter.next();
                if (curKey.toString().equals("/Parent")) {
                    return clonedDict;
                }
                CosObject curObj = dictOBJR.get(curKey);
                CosObject clonedObj = null;
                if (curObj instanceof CosScalar) {
                    clonedObj = PMMStructure.this.cloneHandler.clone(curObj);
                } else if (curObj.getType() == 5) {
                    clonedObj = this.cloneOBJRArray(pdfDoc, (CosArray)curObj);
                } else if (curObj.getType() == 6 && (clonedObj = this.getClonedPDFObject(curObj)) == null && !this.isObjectOfClonedType(pdfDoc, curObj)) {
                    clonedObj = this.cloneOBJRDict(pdfDoc, (CosDictionary)curObj);
                }
                if (clonedObj == null) continue;
                if (clonedDict == null) {
                    clonedDict = pdfDoc.getCosDocument().createCosDictionary();
                }
                clonedDict.put(curKey, clonedObj);
            }
            return clonedDict;
        }

        private CosArray cloneOBJRArray(PDFDocument pdfDoc, CosArray arrayOBJR) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
            CosArray clonedArray = null;
            for (int arrayInd = 0; arrayInd < arrayOBJR.size(); ++arrayInd) {
                CosObject clonedObj = null;
                CosObject curObj = arrayOBJR.get(arrayInd);
                if (curObj instanceof CosScalar) {
                    clonedObj = PMMStructure.this.cloneHandler.clone(curObj);
                } else if (curObj.getType() == 5) {
                    clonedObj = this.cloneOBJRArray(pdfDoc, (CosArray)curObj);
                } else if (curObj.getType() == 6) {
                    clonedObj = this.cloneOBJRDict(pdfDoc, (CosDictionary)curObj);
                }
                if (clonedObj == null) continue;
                if (clonedArray == null) {
                    clonedArray = pdfDoc.getCosDocument().createCosArray();
                }
                clonedArray.add(arrayInd, clonedObj);
            }
            return clonedArray;
        }

        private CosObject getClonedPDFObject(CosObject cosObj) {
            if (cosObj == null) {
                return null;
            }
            return this.cloneMapping.get(cosObj);
        }

        private boolean isObjectOfClonedType(PDFDocument srcDoc, CosObject srcObj) {
            try {
                if (srcObj.getType() != 6) {
                    return false;
                }
                ASName type = ((CosDictionary)srcObj).getName(ASName.k_Type);
                if (type != null) {
                    return type.equals(ASName.k_Page) || type.equals(ASName.k_Annot) || type.equals(ASName.k_XObject);
                }
                if (srcObj.getType() == 7 && (type = ((CosDictionary)srcObj).getName(ASName.k_Subtype)) != null) {
                    return type.equals(ASName.k_Image) || type.equals(ASName.k_Form);
                }
                return PDFFieldUtils.isFieldNode(srcDoc, (CosDictionary)srcObj);
            }
            catch (PDFException excp) {
                return false;
            }
        }
    }

    private class ExtractStructure
    extends AppendStructure {
        ExtractStructure(Map<PDFPage, PDFPage> mapPages, Map<PDFAnnotation, PDFAnnotation> mapAnnots, Map<PDFFieldNode, PDFFieldNode> mapFields, Map<PDFXObject, PDFXObject> mapXObjects) {
            super(mapPages, mapAnnots, mapFields, mapXObjects, null, null, 0, new MaxMcid());
        }
    }

    private static class DeleteElement
    implements ElementOperation {
        PDFPageWrapperSet deletedPagesSet;
        List<PDFStructureContentInterface> elements;
        boolean marked;

        DeleteElement(PDFPageWrapperSet deletedPagesSet, List<PDFStructureContentInterface> deletedElements) {
            this.elements = deletedElements;
            this.marked = false;
            this.deletedPagesSet = deletedPagesSet;
        }

        @Override
        public boolean conditionAction(PDFStructureContentInterface element) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFPage curPage = element.getPage();
            if (curPage == null) {
                return true;
            }
            if (this.deletedPagesSet.contains(curPage)) {
                this.setMark(true);
                return true;
            }
            return false;
        }

        @Override
        public PDFStructureContentInterface firstAction(PDFStructureNode parent, PDFStructureContentInterface element) {
            return element;
        }

        @Override
        public PDFStructureContentInterface lastAction(PDFStructureNode parent, PDFStructureContentInterface element) {
            if (this.marked) {
                this.elements.add(element);
            }
            return element;
        }

        @Override
        public boolean setMark(boolean newMark) {
            boolean oldMark = this.marked;
            this.marked = newMark;
            return oldMark;
        }
    }

    private static interface ElementOperation {
        public PDFStructureContentInterface firstAction(PDFStructureNode var1, PDFStructureContentInterface var2) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException;

        public PDFStructureContentInterface lastAction(PDFStructureNode var1, PDFStructureContentInterface var2) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException;

        public boolean conditionAction(PDFStructureContentInterface var1) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException;

        public boolean setMark(boolean var1);
    }
}

