/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.DispatchItem;
import com.adobe.internal.pdftoolkit.core.traverser.Dispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.Traverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.StatefulOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StatefulContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalBaseDispatch;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalBaseWarning;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class LegalWarningDispatch
extends LegalBaseDispatch
implements Dispatcher {
    private boolean nonEmbeddedFontWarningPerefence;
    private boolean trueTypeFontWarningPreference;
    private static final ASName PresSteps = ASName.create("PresSteps");
    private static final ASName PS = ASName.create("PS");
    private static final ASName Subtype2 = ASName.create("Subtype2");
    private static final ASName Interpolate = ASName.create("Interpolate");

    private boolean getNonEmbeddedFontWarning() {
        return this.nonEmbeddedFontWarningPerefence;
    }

    private boolean getTrueTypeFontWarning() {
        return this.trueTypeFontWarningPreference;
    }

    private void setNonEmbeddedFontWarning(boolean preference) {
        this.nonEmbeddedFontWarningPerefence = preference;
    }

    private void setTrueTypeFontWarning(boolean preference) {
        this.trueTypeFontWarningPreference = preference;
    }

    public LegalWarningDispatch(Map<LegalBaseWarning, Integer> legalWarnings, boolean nonEmbeddedFontWarning, boolean trueTypeFontWarning) {
        super(legalWarnings);
        this.setNonEmbeddedFontWarning(nonEmbeddedFontWarning);
        this.setTrueTypeFontWarning(trueTypeFontWarning);
        this.dispatchKeyMap.put(ASName.k_FT, new DispatchFieldType());
        this.dispatchKeyMap.put(ASName.k_AcroForm, new DispatchAcroForm());
        this.dispatchKeyMap.put(Interpolate, new DispatchInterpolate());
        this.dispatchKeyMap.put(ASName.k_ExtGState, new DispatchExtGStatePDF17());
        this.dispatchKeyMap.put(ASName.k_Annots, new DispatchAnnotArrayPDF17());
        this.dispatchKeyMap.put(ASName.k_Ref, new DispatchReferenceXObjectPDF17());
        this.dispatchKeyMap.put(ASName.k_F, new DispatchExternalStreamPDF17());
        this.dispatchKeyMap.put(ASName.k_FFilter, new DispatchExternalStreamPDF17());
        this.dispatchKeyMap.put(ASName.k_FDecodeParms, new DispatchExternalStreamPDF17());
        this.dispatchKeyMap.put(ASName.k_Crypt, new DispatchCryptFilterDecodeParms());
        if (this.getNonEmbeddedFontWarning() || this.getTrueTypeFontWarning()) {
            this.dispatchValueMap.put(ASName.k_Font, new DispatchFont());
        }
        this.dispatchValueMap.put(ASName.k_Catalog, new DispatchCatalog());
        this.dispatchValueMap.put(ASName.k_Page, new DispatchPage());
        this.dispatchValueMap.put(PS, new DispatchPSXObject());
        this.dispatchValueMap.put(ASName.k_Movie, new LegalBaseDispatch.DispatchMovieAction());
        this.dispatchValueMap.put(ASName.k_Sound, new LegalBaseDispatch.DispatchSoundAction());
        this.dispatchValueMap.put(ASName.k_ImportData, new DispatchImportDataAction());
        this.dispatchValueMap.put(ASName.create("SetState"), new DispatchSetStateAction());
        this.dispatchValueMap.put(ASName.k_SetOCGState, new DispatchSetOCGStateAction());
        this.dispatchValueMap.put(ASName.create("GoTo3DView"), new DispatchGoTo3DViewAction());
        this.dispatchValueMap.put(ASName.k_GoToE, new DispatchGoToEAction());
        this.dispatchValueMap.put(ASName.k_Named, new DispatchNamedAction());
    }

    class DispatchFont
    implements DispatchItem {
        DispatchFont() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return objKey == ASName.k_Type;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            ASName fontType;
            CosContainer fontObj = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (fontObj != null && ((fontType = LegalWarningDispatch.this.safeGetName((CosDictionary)fontObj, ASName.k_Subtype)) == ASName.k_MMType1 || fontType == ASName.k_Type1 || fontType == ASName.k_CIDFontType0 || fontType == ASName.k_CIDFontType2 || fontType == ASName.k_TrueType)) {
                boolean embeddedFont = false;
                CosDictionary fdDictionary = LegalWarningDispatch.this.safeGetDict((CosDictionary)fontObj, ASName.k_FontDescriptor);
                if (fdDictionary != null && (fdDictionary.containsKey(ASName.k_FontFile) || fdDictionary.containsKey(ASName.k_FontFile2) || fdDictionary.containsKey(ASName.k_FontFile3))) {
                    embeddedFont = true;
                }
                if (!embeddedFont && LegalWarningDispatch.this.getNonEmbeddedFontWarning()) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_NonEmbeddedFonts);
                }
                if (fontType == ASName.k_TrueType && LegalWarningDispatch.this.getTrueTypeFontWarning()) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_TrueTypeFonts);
                }
            }
            return true;
        }
    }

    class DispatchCryptFilterDecodeParms
    implements DispatchItem {
        DispatchCryptFilterDecodeParms() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer streamOrFilterArray = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (streamOrFilterArray instanceof CosStream) {
                ASName cryptFilterName;
                CosDictionary decodeParams = LegalWarningDispatch.this.safeGetDict((CosDictionary)streamOrFilterArray, ASName.k_DecodeParms);
                if (decodeParams != null && (cryptFilterName = LegalWarningDispatch.this.safeGetName(decodeParams, ASName.k_Name)) != null && cryptFilterName != LegalBaseDispatch.k_identityKey) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_ExternalStreams);
                }
            } else if (streamOrFilterArray instanceof CosArray) {
                ASName cryptFilterName;
                CosDictionary cryptFilterDecodeParms;
                CosArray decodeParams;
                CosContainer stream = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 2)).getContainer();
                int cryptFilterIndex = ((CosArray)streamOrFilterArray).findName(ASName.k_Crypt);
                if (stream instanceof CosStream && (decodeParams = LegalWarningDispatch.this.safeGetArray((CosDictionary)stream, ASName.k_DecodeParms)) != null && (cryptFilterDecodeParms = decodeParams.getCosDictionary(cryptFilterIndex)) != null && (cryptFilterName = LegalWarningDispatch.this.safeGetName(cryptFilterDecodeParms, ASName.k_Name)) != null && cryptFilterName != LegalBaseDispatch.k_identityKey) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DocHasCryptFilter);
                }
            }
            return true;
        }
    }

    class DispatchExternalStreamPDF17
    implements DispatchItem {
        DispatchExternalStreamPDF17() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer() instanceof CosStream;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_ExternalStreams);
            return true;
        }
    }

    class DispatchReferenceXObjectPDF17
    implements DispatchItem {
        DispatchReferenceXObjectPDF17() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer objContainer = null;
            ASName pdfSubType = null;
            if (!curStack.isEmpty()) {
                objContainer = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
                pdfSubType = LegalWarningDispatch.this.safeGetName((CosDictionary)objContainer, ASName.k_Subtype);
            }
            return pdfSubType == ASName.k_Form;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            LegalWarningDispatch.this.incrementCounter(LegalWarning.k_RefXobjects);
            return true;
        }
    }

    private class DispatchAnnotArrayPDF17
    extends LegalBaseDispatch.DispatchAnnotArray
    implements DispatchItem {
        private DispatchAnnotArrayPDF17() {
        }

        @Override
        boolean visitAnnotation(PDFAnnotation annot, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (annot.getSubtype() != ASName.k_Widget) {
                LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_Annotations);
            } else {
                PDFAnnotationWidget widget = (PDFAnnotationWidget)annot;
                PDFField field = widget.getField();
                if (field != null && field.getFieldType() == PDFFieldType.Signature) {
                    return this.visitSignature(widget);
                }
            }
            return true;
        }

        private boolean visitSignature(PDFAnnotationWidget widget) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFXObjectMap frmXObjsMap;
            PDFResources frmResources;
            PDFXObject frmXObj;
            PDFXObjectMap xobjsMap;
            PDFResources resources;
            PDFXObjectForm normalAppearance;
            PDFAppearance appearance;
            if (widget.getAction() != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_SigFieldHasAction);
            }
            if (widget.getField().getInheritableValueFieldNode(ASName.k_AA) != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_SigFieldHasAA);
            }
            if ((appearance = widget.getAppearance()) != null && (normalAppearance = appearance.getNormalAppearance()) != null && (resources = normalAppearance.getResources()) != null && (xobjsMap = resources.getXObjectMap()) != null && (frmXObj = xobjsMap.get(ASName.create("FRM"))) instanceof PDFXObjectForm && (frmResources = ((PDFXObjectForm)frmXObj).getResources()) != null && (frmXObjsMap = frmResources.getXObjectMap()) != null && (frmXObjsMap.get(ASName.create("n1")) != null || frmXObjsMap.get(ASName.create("n3")) != null || frmXObjsMap.get(ASName.create("n4")) != null)) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DynamicSigAP);
            }
            return true;
        }
    }

    private class DispatchExtGStatePDF17
    extends LegalBaseDispatch.DispatchExtGState
    implements DispatchItem {
        private DispatchExtGStatePDF17() {
        }

        @Override
        boolean visitExtGState(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (obj instanceof CosDictionary) {
                CosDictionary gsDict = (CosDictionary)obj;
                if (gsDict.containsKey(ASName.k_TR)) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_DevDepGS_TR);
                }
                if (gsDict.containsKey(ASName.k_TR2) && LegalWarningDispatch.this.safeGetName(gsDict, ASName.k_TR2) != LegalBaseDispatch.k_defaultKey) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_DevDepGS_TR);
                }
                if (gsDict.containsKey(ASName.k_FL)) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_DevDepGS_FL);
                }
                if (gsDict.containsKey(ASName.k_SMask) && LegalWarningDispatch.this.safeGetName(gsDict, ASName.k_SMask) != LegalBaseDispatch.k_NoneKey) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DevDepGS_SMask);
                }
            }
            return true;
        }
    }

    private class DispatchInterpolate
    implements DispatchItem {
        private DispatchInterpolate() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer xobjImage = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            ASName xobjSubtype = LegalWarningDispatch.this.safeGetName((CosDictionary)xobjImage, ASName.k_Subtype);
            return xobjSubtype == ASName.k_Image;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (obj.getType() == 2 && obj.booleanValue()) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_XObjHasInterpolate);
            }
            return true;
        }
    }

    private static class DispatchPSXObject
    implements DispatchItem {
        private DispatchPSXObject() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return objKey == ASName.k_Subtype || objKey == Subtype2;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return true;
        }
    }

    class DispatchNamedAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchNamedAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            ASName actionName;
            CosContainer namedAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (namedAction != null && (actionName = LegalWarningDispatch.this.safeGetName((CosDictionary)namedAction, ASName.k_N)) != null && actionName != ASName.create("NextPage") && actionName != ASName.create("PrevPage") && actionName != ASName.create("FirstPage") && actionName != ASName.create("LastPage")) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_NamedAction);
            }
            return true;
        }
    }

    class DispatchGoToEAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchGoToEAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer goToEAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (goToEAction != null && ((CosDictionary)goToEAction).containsKey(ASName.k_F)) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_GoToEAction);
            }
            return true;
        }
    }

    class DispatchGoTo3DViewAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchGoTo3DViewAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer goTo3DViewAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (goTo3DViewAction != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_GoTo3DViewAction);
            }
            return true;
        }
    }

    class DispatchSetOCGStateAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchSetOCGStateAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer setOCGStateAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (setOCGStateAction != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_SetOCGStateActions);
            }
            return true;
        }
    }

    class DispatchSetStateAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchSetStateAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer setStateAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (setStateAction != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_SetStateActions);
            }
            return true;
        }
    }

    class DispatchImportDataAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchImportDataAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer importDataAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (importDataAction != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_ImportDataActions);
            }
            return true;
        }
    }

    private class DispatchAcroForm
    implements DispatchItem {
        private DispatchAcroForm() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (LegalWarningDispatch.this.safeGetArray((CosDictionary)obj, ASName.k_XFA) != null || LegalWarningDispatch.this.safeGetStream((CosDictionary)obj, ASName.k_XFA) != null) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DocHasXFA);
            }
            return true;
        }
    }

    private class DispatchFieldType
    implements DispatchItem {
        private DispatchFieldType() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (obj.getType() == 3 && (obj.nameValue() == ASName.k_Btn || obj.nameValue() == ASName.k_Tx || obj.nameValue() == ASName.k_Ch)) {
                LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DocHasNonSigField);
            }
            return true;
        }
    }

    private class DispatchPage
    implements DispatchItem {
        private DispatchPage() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return objKey == ASName.k_Type;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
            CosContainer page = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (page != null) {
                if (LegalWarningDispatch.this.safeGetDict((CosDictionary)page, ASName.k_AA) != null) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_PageHasAA);
                }
                if (LegalWarningDispatch.this.safeGetDict((CosDictionary)page, PresSteps) != null) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DocHasPresentation);
                }
                PDFPage pdfPage = PDFPage.getInstance(page);
                StatefulOperatorHandler sch = new StatefulOperatorHandler(pdfPage){

                    @Override
                    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                        this.processXObject(name, instruction, null);
                    }
                };
                try {
                    StatefulContentStreamProcessor streamProcessor = new StatefulContentStreamProcessor(sch);
                    streamProcessor.process(pdfPage);
                }
                catch (PDFInvalidDocumentException e) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_MalformedContentStm);
                }
                catch (PDFIOException e) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_MalformedContentStm);
                }
            }
            return true;
        }
    }

    private class DispatchCatalog
    implements DispatchItem {
        private DispatchCatalog() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return objKey == ASName.k_Type;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer catalog = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (catalog != null) {
                CosDictionary defaultOCG;
                CosArray ocgs;
                CosDictionary ocProperties;
                CosArray requirementsArray;
                ASName version;
                if (LegalWarningDispatch.this.safeGetDict((CosDictionary)catalog, ASName.k_AA) != null) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_CatalogHasAA);
                }
                if (LegalWarningDispatch.this.safeGetDict((CosDictionary)catalog, ASName.k_OpenAction) != null || LegalWarningDispatch.this.safeGetArray((CosDictionary)catalog, ASName.k_OpenAction) != null) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_CatalogHasOpenAction);
                }
                if ((version = LegalWarningDispatch.this.safeGetName((CosDictionary)catalog, ASName.k_Version)) != null && version != ASName.create("1.0") && version != ASName.create("1.1") && version != ASName.create("1.2") && version != ASName.create("1.3") && version != ASName.create("1.4") && version != ASName.create("1.5") && version != ASName.create("1.6")) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_FuturePDFVersion);
                }
                if ((requirementsArray = LegalWarningDispatch.this.safeGetArray((CosDictionary)catalog, ASName.create("Requirements"))) != null) {
                    Iterator<CosObject> requirementsIterator = requirementsArray.iterator();
                    while (requirementsIterator.hasNext()) {
                        CosDictionary requirementDict = (CosDictionary)requirementsIterator.next();
                        CosArray requirementHandlersArray = LegalWarningDispatch.this.safeGetArray(requirementDict, ASName.create("RH"));
                        Iterator<CosObject> requirementHandlersIterator = requirementHandlersArray.iterator();
                        while (requirementHandlersIterator.hasNext()) {
                            CosDictionary requirementHandler = (CosDictionary)requirementHandlersIterator.next();
                            if (LegalWarningDispatch.this.safeGetName(requirementHandler, ASName.k_S) == ASName.create("NoOp")) continue;
                            LegalWarningDispatch.this.incrementCounter(LegalWarning.k_DocHasRequirementHandler);
                        }
                    }
                }
                if ((ocProperties = LegalWarningDispatch.this.safeGetDict((CosDictionary)catalog, ASName.k_OCProperties)) != null && (ocgs = LegalWarningDispatch.this.safeGetArray(ocProperties, ASName.k_OCGs)) != null && ocgs.size() != 0 && (defaultOCG = LegalWarningDispatch.this.safeGetDict(ocProperties, ASName.k_D)) != null && defaultOCG.containsKey(ASName.k_AS)) {
                    LegalWarningDispatch.this.incrementCounter(LegalBaseWarning.k_OptionalContent);
                }
                if (catalog.getDocument().getHeaderTrashCount() != 0) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_InvalidFileHeader);
                }
                if (catalog.getDocument().getTrailerTrashCount() != 0) {
                    LegalWarningDispatch.this.incrementCounter(LegalWarning.k_InvalidEOF);
                }
            }
            return true;
        }
    }
}

