/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStack;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStackItem;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFFormSupport;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFACanonicalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class DocModUtils {
    static final double PERMISSIBLE_ERROR = 1.0E-4;

    public static CosArray safeGetArray(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosArray) {
            return (CosArray)obj;
        }
        return null;
    }

    public static CosDictionary safeGetDict(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosDictionary) {
            return (CosDictionary)obj;
        }
        return null;
    }

    public static ASName safeGetName(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosName) {
            return ((CosName)obj).nameValue();
        }
        return null;
    }

    public static ASString safeGetString(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosString) {
            return ((CosString)obj).stringValue();
        }
        return null;
    }

    public static int safeGetInt(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosNumeric) {
            return ((CosNumeric)obj).intValue();
        }
        return 0;
    }

    public static String getFullName(CosDictionary field) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ArrayList<CosDictionary> fieldStack = new ArrayList<CosDictionary>();
        while (field != null) {
            fieldStack.add(field);
            field = DocModUtils.safeGetDict(field, ASName.k_Parent);
        }
        int depth = fieldStack.size();
        StringBuilder buf = new StringBuilder();
        for (int i = depth - 1; i >= 0; --i) {
            field = (CosDictionary)fieldStack.get(i);
            ASString localString = DocModUtils.safeGetString(field, ASName.k_T);
            if (localString == null) continue;
            if (buf.length() != 0) {
                buf.append('.');
            }
            buf.append(localString.asString());
        }
        return buf.toString();
    }

    public static String getPartialName(CosDictionary field) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASString localString = null;
        while (field != null && localString == null) {
            localString = DocModUtils.safeGetString(field, ASName.k_T);
            field = DocModUtils.safeGetDict(field, ASName.k_Parent);
        }
        if (localString != null) {
            return localString.asString();
        }
        return "";
    }

    public static Map<ASString, CosObject> nameTreeToMap(CosDictionary nameTree) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        HashMap<ASString, CosObject> nameMap = new HashMap<ASString, CosObject>();
        DocModUtils.nameTreeToMapRecur(nameTree, nameMap);
        return nameMap;
    }

    public static CosObject getInheritedValue(CosDictionary node, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        while (node != null) {
            CosObject value = node.get(key);
            if (value != null) {
                return value;
            }
            node = (CosDictionary)node.get(ASName.k_Parent);
        }
        return null;
    }

    public static void nameTreeToMapRecur(CosDictionary nameTree, Map<ASString, CosObject> nameMap) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray names;
        if (nameTree == null) {
            return;
        }
        CosArray kids = DocModUtils.safeGetArray(nameTree, ASName.k_Kids);
        if (kids != null) {
            Iterator<CosObject> iter = kids.iterator();
            while (iter.hasNext()) {
                CosObject kid = iter.next();
                if (!(kid instanceof CosDictionary)) continue;
                DocModUtils.nameTreeToMapRecur((CosDictionary)kid, nameMap);
            }
        }
        if ((names = DocModUtils.safeGetArray(nameTree, ASName.k_Names)) == null || names.size() % 2 != 0) {
            return;
        }
        Iterator<CosObject> iter = names.iterator();
        while (iter.hasNext()) {
            CosObject name = iter.next();
            CosObject value = iter.next();
            if (!(name instanceof CosString) || !(value instanceof CosObject)) continue;
            nameMap.put(((CosString)name).stringValue(), value);
        }
    }

    public static int getNumPages(CosDocument cosDoc) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary catalog = cosDoc.getRoot();
        CosObject pages = catalog.get(ASName.k_Pages);
        if (!(pages instanceof CosDictionary)) {
            return 0;
        }
        CosObject count = ((CosDictionary)pages).get(ASName.k_Count);
        if (!(count instanceof CosNumeric)) {
            return 0;
        }
        return ((CosNumeric)count).intValue();
    }

    public static CosDictionary getPage(CosDocument cosDoc, int pageNum) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary catalog = cosDoc.getRoot();
        CosObject node = catalog.get(ASName.k_Pages);
        if (!(node instanceof CosDictionary)) {
            return null;
        }
        CosObject count = ((CosDictionary)node).get(ASName.k_Count);
        if (!(count instanceof CosNumeric)) {
            return null;
        }
        if (pageNum >= ((CosNumeric)count).intValue()) {
            return null;
        }
        CosObject kids = ((CosDictionary)node).get(ASName.k_Kids);
        if (!(kids instanceof CosArray)) {
            return null;
        }
        int curPageNum = 0;
        Iterator<CosObject> iter = ((CosArray)kids).iterator();
        while (iter.hasNext()) {
            node = iter.next();
            if (!(node instanceof CosDictionary)) {
                return null;
            }
            count = ((CosDictionary)node).get(ASName.k_Count);
            if (count instanceof CosNumeric) {
                int curCount = ((CosNumeric)count).intValue();
                if (curPageNum + curCount > pageNum) {
                    kids = ((CosDictionary)node).get(ASName.k_Kids);
                    if (!(kids instanceof CosArray)) {
                        return null;
                    }
                    iter = ((CosArray)kids).iterator();
                    continue;
                }
                curPageNum += curCount;
                continue;
            }
            if (curPageNum == pageNum) {
                return (CosDictionary)node;
            }
            ++curPageNum;
        }
        return null;
    }

    public static CosDictionary getContainerItem(CosObject obj, DocModStack curStack, CosList itemList) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (itemList.containsIndex(obj.getObjNum())) {
            return (CosDictionary)obj;
        }
        int count = curStack.size();
        for (int i = count - 1; i >= 0; --i) {
            DocModStackItem item = curStack.get(i);
            CosContainer stackObj = item.getContainer();
            if (!itemList.containsIndex(stackObj.getObjNum())) continue;
            return (CosDictionary)stackObj;
        }
        return null;
    }

    public static boolean isPagesNode(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        for (int i = curStack.size() - 1; i >= 0; --i) {
            DocModStackItem item = curStack.get(i);
            ASName containerKey = item.getContainerKey();
            if (containerKey == ASName.k_Pages && obj instanceof CosDictionary && DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Type) == ASName.k_Pages) {
                return true;
            }
            if (!(containerKey == ASName.k_Kids && obj instanceof CosArray || containerKey == null && obj instanceof CosDictionary && DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Type) == ASName.k_Pages)) {
                return false;
            }
            obj = item.getContainer();
        }
        return false;
    }

    public static boolean isFontRelatedObject(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean fontKeySeen = false;
        for (int i = curStack.size() - 1; i >= 0; --i) {
            DocModStackItem item = curStack.get(i);
            ASName containerKey = item.getContainerKey();
            if (containerKey == ASName.k_Font) {
                fontKeySeen = true;
                continue;
            }
            if (fontKeySeen && containerKey == ASName.k_Resources) {
                return true;
            }
            fontKeySeen = false;
        }
        return false;
    }

    public static boolean buttonOff(CosObject obj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (obj == null || obj instanceof CosNull) {
            return true;
        }
        if (obj instanceof CosName) {
            return ((CosName)obj).nameValue() == ASName.create("Off");
        }
        if (obj instanceof CosString) {
            String valStr = ((CosString)obj).asString();
            if (valStr.length() == 0) {
                return true;
            }
            return "0".equals(valStr);
        }
        return false;
    }

    public static boolean compareScalars(CosObject obj1, CosObject obj2) throws PDFSecurityException {
        if (obj1.getClass() != obj2.getClass()) {
            return false;
        }
        if (!(obj1 instanceof CosScalar)) {
            return false;
        }
        if (obj1 instanceof CosBoolean) {
            return obj1.booleanValue() == obj2.booleanValue();
        }
        if (obj1 instanceof CosName) {
            return obj1.nameValue() == obj2.nameValue();
        }
        if (obj1 instanceof CosNull) {
            return true;
        }
        if (obj1 instanceof CosNumeric) {
            return Math.abs(obj1.doubleValue() - obj2.doubleValue()) <= 1.0E-4;
        }
        if (obj1 instanceof CosString) {
            byte[] val2;
            byte[] val1 = ((CosString)obj1).byteArrayValue();
            if (val1.length != (val2 = ((CosString)obj2).byteArrayValue()).length) {
                return false;
            }
            for (int i = 0; i < val1.length; ++i) {
                if (val1[i] == val2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isDocDynamic(CosDocument cosDoc) throws PDFCosParseException, PDFSecurityException, PDFInvalidParameterException, PDFIOException {
        CosDictionary acroFormDict = DocModUtils.safeGetDict(cosDoc.getRoot(), ASName.k_AcroForm);
        if (acroFormDict == null) {
            return false;
        }
        CosObject xfaObj = acroFormDict.get(ASName.k_XFA);
        if (xfaObj == null) {
            return false;
        }
        InputByteStream xfaStream = PDFFormSupport.getStream(xfaObj);
        if (xfaStream == null) {
            return false;
        }
        try {
            boolean bl = XFACanonicalizer.isDocDynamic(xfaStream);
            return bl;
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException("Invalid XML exception encountered while parsing XFA data", e);
        }
        finally {
            try {
                xfaStream.close();
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }
}

