/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CloudUtils {
    private static final double RADIUS_PER_INTENSITY_UNIT = 4.0;
    private static final double SPACING_PER_RADIUS = 1.6666666666666667;

    private CloudUtils() {
    }

    private static List<AnnotationAppearanceGenerator.Arc> layOutCloudArcsOnLineSegment(double radius, double spacing, ASCoordinate v1, ASCoordinate v2) {
        ArrayList<AnnotationAppearanceGenerator.Arc> vArcOut = new ArrayList<AnnotationAppearanceGenerator.Arc>();
        double segmentLength = v1.distanceTo(v2);
        if (segmentLength > 0.0) {
            int nSpacings = (int)Math.floor(segmentLength / spacing);
            double xSpacing = (v2.x() - v1.x()) * spacing / segmentLength;
            double ySpacing = (v2.y() - v1.y()) * spacing / segmentLength;
            AnnotationAppearanceGenerator.Arc arc = new AnnotationAppearanceGenerator.Arc(0.0, 0.0, v1, radius);
            AnnotationAppearanceGenerator.Arc scratchArc = new AnnotationAppearanceGenerator.Arc(0.0, 0.0, new ASCoordinate(v1.x() - xSpacing, v1.y() - ySpacing), radius);
            Double[] t1 = new Double[]{arc.t1, null, null, null};
            CloudUtils.intersectCircles(arc, scratchArc, t1);
            arc.t1 = t1[0];
            scratchArc.m_center = new ASCoordinate(v1.x() + xSpacing, v1.y() + ySpacing);
            Double[] t2 = new Double[]{null, arc.t2, null, null};
            CloudUtils.intersectCircles(arc, scratchArc, t2);
            arc.t2 = t2[1];
            for (int i = 0; i <= nSpacings; ++i) {
                vArcOut.add(arc);
                arc = new AnnotationAppearanceGenerator.Arc(arc.t1, arc.t2, arc.m_center, arc.m_radius);
                if (i >= nSpacings) continue;
                arc.m_center = arc.m_center.translate(xSpacing, ySpacing);
            }
        }
        return vArcOut;
    }

    static List<AnnotationAppearanceGenerator.Arc> cloudifyPolyLine(double cloudIntensity, double strokeWidth, List<ASCoordinate> vVertexIn) {
        List<ASCoordinate> vVertex;
        ArrayList<AnnotationAppearanceGenerator.Arc> vArcOut = new ArrayList<AnnotationAppearanceGenerator.Arc>();
        if (cloudIntensity <= 0.0) {
            throw new PDFRuntimeException("Cloud indensity is negative.");
        }
        if (strokeWidth <= 0.0) {
            throw new PDFRuntimeException("Stroke width is negative.");
        }
        double radius = 4.0 * cloudIntensity + strokeWidth / 2.0;
        double spacing = 1.6666666666666667 * radius;
        int nVertexIn = vVertexIn.size();
        if (nVertexIn < 2) {
            throw new PDFRuntimeException("Number os verices is less than 2.");
        }
        ASCoordinate first = vVertexIn.get(0);
        ASCoordinate last = vVertexIn.get(nVertexIn - 1);
        boolean bIsClosedShape = first.x() == last.x() && first.y() == last.y();
        double area = 0.0;
        ArrayList<ASCoordinate> vVertexForAreaCalculation = new ArrayList<ASCoordinate>(vVertexIn);
        if (nVertexIn > 2) {
            if (!bIsClosedShape) {
                vVertexForAreaCalculation.add(vVertexIn.get(0));
            }
            area = CloudUtils.calculatePolygonArea(vVertexForAreaCalculation);
        }
        if (area <= 0.0) {
            vVertex = vVertexIn;
        } else {
            vVertex = new ArrayList<ASCoordinate>();
            vVertex.addAll(vVertexIn);
        }
        int nVertex = vVertex.size();
        ArrayList<List<AnnotationAppearanceGenerator.Arc>> vvSegmentArc = new ArrayList<List<AnnotationAppearanceGenerator.Arc>>();
        for (int iVertex = 0; iVertex < nVertex - 1; ++iVertex) {
            List<AnnotationAppearanceGenerator.Arc> vArc = CloudUtils.layOutCloudArcsOnLineSegment(radius, spacing, vVertex.get(iVertex), vVertex.get(iVertex + 1));
            vvSegmentArc.add(vArc);
        }
        int nSegments = vvSegmentArc.size();
        for (int iSegment = 0; iSegment < nSegments; ++iSegment) {
            List vArcThisSegment = (List)vvSegmentArc.get(iSegment);
            int nArcThisSegment = vArcThisSegment.size();
            if (nArcThisSegment <= 0) continue;
            if (iSegment == 0) {
                List vArcLastSegment;
                int nArcLastSegment;
                AnnotationAppearanceGenerator.Arc arcFirstSegmentBegin = (AnnotationAppearanceGenerator.Arc)vArcThisSegment.get(0);
                if (bIsClosedShape && (nArcLastSegment = (vArcLastSegment = (List)vvSegmentArc.get(nSegments - 1)).size()) > 0) {
                    AnnotationAppearanceGenerator.Arc arcLastSegmentEnd = (AnnotationAppearanceGenerator.Arc)vArcLastSegment.get(nArcLastSegment - 1);
                    Double[] t1 = new Double[]{arcFirstSegmentBegin.t1, null, null, null};
                    CloudUtils.intersectCircles(arcFirstSegmentBegin, arcLastSegmentEnd, t1);
                    arcFirstSegmentBegin.t1 = t1[0];
                }
            }
            AnnotationAppearanceGenerator.Arc arcThisSegmentEnd = (AnnotationAppearanceGenerator.Arc)vArcThisSegment.get(nArcThisSegment - 1);
            if (iSegment == nSegments - 1) {
                List vArcFirstSegment;
                int nArcFirstSegment;
                if (bIsClosedShape && (nArcFirstSegment = (vArcFirstSegment = (List)vvSegmentArc.get(0)).size()) > 0) {
                    AnnotationAppearanceGenerator.Arc arcFirstSegmentBegin = (AnnotationAppearanceGenerator.Arc)vArcFirstSegment.get(0);
                    Double[] t2 = new Double[]{null, arcThisSegmentEnd.t2, null, null};
                    CloudUtils.intersectCircles(arcThisSegmentEnd, arcFirstSegmentBegin, t2);
                    arcThisSegmentEnd.t2 = t2[1];
                }
            } else {
                List vArcNextSegment = (List)vvSegmentArc.get(iSegment + 1);
                int nArcNextSegment = vArcNextSegment.size();
                if (nArcNextSegment > 0) {
                    AnnotationAppearanceGenerator.Arc arcNextSegmentBegin = (AnnotationAppearanceGenerator.Arc)vArcNextSegment.get(0);
                    Double[] t = new Double[]{null, arcThisSegmentEnd.t2, null, null};
                    CloudUtils.intersectCircles(arcThisSegmentEnd, arcNextSegmentBegin, t);
                    arcThisSegmentEnd.t2 = t[1];
                    t = new Double[]{arcNextSegmentBegin.t1, null, null, null};
                    CloudUtils.intersectCircles(arcNextSegmentBegin, arcThisSegmentEnd, t);
                    arcNextSegmentBegin.t1 = t[0];
                }
            }
            vArcOut.addAll(vArcThisSegment);
        }
        return vArcOut;
    }

    private static double calculatePolygonArea(List<ASCoordinate> vVertex) {
        if (vVertex.size() < 3) {
            throw new PDFRuntimeException("Vertices of ploygon are less than 3.");
        }
        Iterator<ASCoordinate> itr = vVertex.iterator();
        double area = 0.0;
        ASCoordinate prevCoord = null;
        ASCoordinate coord = null;
        if (itr.hasNext()) {
            prevCoord = itr.next();
        }
        while (itr.hasNext()) {
            coord = itr.next();
            area += prevCoord.x() * coord.y() - coord.x() * prevCoord.y();
            prevCoord = coord;
        }
        return area;
    }

    static int calculateCloudsPerLength(double intensity, double length, double strokeWidth) {
        double cloudDiameter = 8.0 * intensity + strokeWidth;
        return (int)Math.ceil(length / cloudDiameter);
    }

    static List<AnnotationAppearanceGenerator.Arc> cloudify(double m_a, double m_b, int nPieces, double rConst) {
        List<Double> times = CloudUtils.divide(m_a, m_b, nPieces, 0.0, 1.0);
        List<ASCoordinate> vPoint = CloudUtils.evalV(m_a, m_b, times);
        vPoint = vPoint.subList(0, vPoint.size() - 1);
        return CloudUtils.cloudifyClosedShape(vPoint, rConst);
    }

    private static List<ASCoordinate> evalV(double m_a, double m_b, List<Double> v) {
        ArrayList<ASCoordinate> vPoint = new ArrayList<ASCoordinate>();
        Iterator<Double> itr = v.iterator();
        while (itr.hasNext()) {
            vPoint.add(CloudUtils.eval(m_a, m_b, itr.next()));
        }
        return vPoint;
    }

    private static List<AnnotationAppearanceGenerator.Arc> cloudifyClosedShape(List<ASCoordinate> v, double rConst) {
        int i;
        int nSize = v.size();
        ArrayList<AnnotationAppearanceGenerator.Arc> vArc = new ArrayList<AnnotationAppearanceGenerator.Arc>();
        for (i = 0; i < nSize; ++i) {
            ASCoordinate p = v.get(i);
            AnnotationAppearanceGenerator.Arc arc = new AnnotationAppearanceGenerator.Arc(0.0, Math.PI, p, Math.max(p.distanceTo(v.get((i + nSize - 1) % nSize)), p.distanceTo(v.get((i + 1) % nSize))) * rConst);
            vArc.add(arc);
        }
        for (i = 0; i < nSize; ++i) {
            AnnotationAppearanceGenerator.Arc arc = (AnnotationAppearanceGenerator.Arc)vArc.get(i);
            AnnotationAppearanceGenerator.Arc arcp1 = (AnnotationAppearanceGenerator.Arc)vArc.get((i + 1) % nSize);
            AnnotationAppearanceGenerator.Arc arcm1 = (AnnotationAppearanceGenerator.Arc)vArc.get((i + nSize - 1) % nSize);
            Double[] t1 = new Double[]{arc.t1, null, null, null};
            CloudUtils.intersectCircles(arc, arcm1, t1);
            arc.t1 = t1[0];
            Double[] t2 = new Double[]{null, arc.t2, null, null};
            CloudUtils.intersectCircles(arc, arcp1, t2);
            arc.t2 = t2[1];
        }
        return vArc;
    }

    private static void intersectCircles(AnnotationAppearanceGenerator.Arc c1, AnnotationAppearanceGenerator.Arc c2, Double[] t) {
        double tDelta;
        if (c1.m_radius <= 0.0 || c2.m_radius <= 0.0) {
            throw new PDFRuntimeException("Radius of circle can't be negative.");
        }
        double dCenters = c1.m_center.distanceTo(c2.m_center);
        if (dCenters <= 0.0) {
            throw new PDFRuntimeException("Distance between centers of circles can't be negative.");
        }
        if (dCenters > c1.m_radius + c2.m_radius) {
            throw new PDFRuntimeException("Distance between centers of circles is greater then sum of their radii.");
        }
        double dCentersSquared = dCenters * dCenters;
        double dCentersTimesTwo = 2.0 * dCenters;
        double r1Squared = c1.m_radius * c1.m_radius;
        double r2Squared = c2.m_radius * c2.m_radius;
        double d1 = (dCentersSquared + r1Squared - r2Squared) / dCentersTimesTwo;
        double d2 = dCenters - d1;
        double tCenters = Math.atan2(c2.m_center.y() - c1.m_center.y(), c2.m_center.x() - c1.m_center.x());
        if (t[0] != null || t[1] != null) {
            double d1ToR1Ratio = d1 / c1.m_radius;
            if (d1ToR1Ratio < -1.0 || d1ToR1Ratio > 1.0) {
                throw new PDFRuntimeException("First circle is completely inside second.");
            }
            tDelta = Math.acos(d1ToR1Ratio);
            if (t[0] != null) {
                t[0] = tCenters - tDelta;
            }
            if (t[1] != null) {
                t[1] = tCenters + tDelta;
            }
        }
        if (t[2] != null || t[3] != null) {
            double d2ToR2Ratio = d2 / c2.m_radius;
            if (d2ToR2Ratio < -1.0 || d2ToR2Ratio > 1.0) {
                throw new PDFRuntimeException("Second circle is completely inside first.");
            }
            tDelta = Math.acos(d2ToR2Ratio);
            if (t[2] != null) {
                t[2] = Math.PI - tCenters + tDelta;
            }
            if (t[3] != null) {
                t[3] = Math.PI + tCenters - tDelta;
            }
        }
    }

    private static List<Double> divide(double m_a, double m_b, int nPieces, double t1, double t2) {
        ArrayList<Double> v = new ArrayList<Double>();
        v.add(t1);
        double fnp = nPieces;
        for (int k = 1; k < nPieces; ++k) {
            v.add(CloudUtils.approxPortion(m_a, m_b, t1, t2, (double)k / fnp));
        }
        v.add(t2);
        return v;
    }

    private static ASCoordinate eval(double m_a, double m_b, double t) {
        double PI2 = Math.PI * 2;
        return new ASCoordinate(m_a * Math.cos(t * PI2), m_b * -Math.sin(t * PI2));
    }

    private static double approxDistance(double m_a, double m_b, double t1, double t2, int nSamples) {
        double d = 0.0;
        ASCoordinate fpLast = CloudUtils.eval(m_a, m_b, t1);
        if (nSamples < 0) {
            nSamples = 100;
        }
        for (int n = 1; n < nSamples; ++n) {
            double t = t1 + (t2 - t1) * (double)n / (double)nSamples;
            ASCoordinate fp = CloudUtils.eval(m_a, m_b, t);
            double dx = fpLast.x() - fp.x();
            double dy = fpLast.y() - fp.y();
            d += Math.sqrt(dx * dx + dy * dy);
            fpLast = fp;
        }
        return d;
    }

    private static double approxPortion(double m_a, double m_b, double t1, double t2, double p) {
        double d;
        double l;
        double h;
        double desired = CloudUtils.approxDistance(m_a, m_b, t1, t2, -1) * p;
        double t = -1.0;
        if (t1 > t2) {
            h = t1;
            l = t2;
        } else {
            h = t2;
            l = t1;
        }
        int n = 16;
        double tol = desired / 1000.0;
        while (n-- != 0 && !(Math.abs(desired - (d = CloudUtils.approxDistance(m_a, m_b, t1, t = (h + l) / 2.0, -1))) < tol)) {
            if (d > desired) {
                h = t;
                continue;
            }
            l = t;
        }
        return t;
    }
}

