/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaCriteria;

public class PDFMustHonorRendition
extends PDFCosDictionary {
    private PDFMustHonorRendition(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMustHonorRendition newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMustHonorRendition pdfObject = new PDFMustHonorRendition(cosObject);
        return pdfObject;
    }

    public static PDFMustHonorRendition getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMustHonorRendition pdfObject = (PDFMustHonorRendition)PDFCosObject.getCachedInstance(cosObject, PDFMustHonorRendition.class);
        if (pdfObject == null) {
            pdfObject = new PDFMustHonorRendition(cosObject);
        }
        return pdfObject;
    }

    public PDFMediaCriteria getC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaCriteria.getInstance(this.getDictionaryCosObjectValue(ASName.k_C));
    }

    public void setC(PDFMediaCriteria value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_C, value);
    }

    public PDFMediaCriteria procureC() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasC()) {
            return PDFMediaCriteria.newInstance(this.getPDFDocument());
        }
        return this.getC();
    }

    public boolean hasC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }
}

