/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;

public class PDF3DViewArray
extends PDFCosArrayList<PDF3DVDict> {
    private PDF3DViewArray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DViewArray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDF3DViewArray pdfObject = new PDF3DViewArray(cosObject);
        return pdfObject;
    }

    public static PDF3DViewArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DViewArray pdfObject = (PDF3DViewArray)PDFCosObject.getCachedInstance(cosObject, PDF3DViewArray.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DViewArray(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDF3DVDict itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVDict.getInstance(cosObject);
    }
}

