/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFWebCaptureCommandsArray;

public class PDFSpiderInfo
extends PDFCosDictionary {
    private PDFSpiderInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSpiderInfo newInstance(PDFDocument pdfDocument, double key_Version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSpiderInfo pdfObject = new PDFSpiderInfo(cosObject);
        pdfObject.setVersion(key_Version);
        return pdfObject;
    }

    public static PDFSpiderInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSpiderInfo pdfObject = (PDFSpiderInfo)PDFCosObject.getCachedInstance(cosObject, PDFSpiderInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFSpiderInfo(cosObject);
        }
        return pdfObject;
    }

    public double getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_V);
    }

    public void setVersion(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_V, value);
    }

    public double requireVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_V);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get Version.");
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public boolean hasVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_V);
    }

    public PDFWebCaptureCommandsArray getC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFWebCaptureCommandsArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_C));
    }

    public void setC(PDFWebCaptureCommandsArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            this.removeValue(ASName.k_C);
        } else {
            this.setDictionaryArrayValue(ASName.k_C, children.getCosArray());
        }
    }

    public boolean hasC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }
}

