/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFCollectionSplit
extends PDFCosDictionary {
    private PDFCollectionSplit(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionSplit getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionSplit pdfObject = (PDFCollectionSplit)PDFCosObject.getCachedInstance(cosObject, PDFCollectionSplit.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionSplit(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionSplit newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCollectionSplit pdfObject = new PDFCollectionSplit(cosObject);
        return pdfObject;
    }

    public ASName getDirection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_Direction)) {
            return this.getDictionaryNameValue(ASName.k_Direction);
        }
        return null;
    }

    public void setDirection(ASName direction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (direction == null) {
            this.removeValue(ASName.k_Direction);
            return;
        }
        if (!(direction.equals(ASName.k_H) || direction.equals(ASName.k_V) || direction.equals(ASName.k_N))) {
            throw new PDFInvalidParameterException("direction needs to be \"H\",  \"V\"  or  \"N\"");
        }
        this.setDictionaryValue(ASName.k_Direction, PDFCosObject.newCosName(this.getPDFDocument(), direction));
    }

    public boolean hasDirection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Direction);
    }

    public Double getPostion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_Position)) {
            return new Double(this.getDictionaryDoubleValue(ASName.k_Position));
        }
        return null;
    }

    public void setPosition(Double position) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (position == null) {
            this.removeValue(ASName.k_Position);
            return;
        }
        double pos = position;
        if (pos < 0.0 || pos > 100.0) {
            throw new PDFInvalidParameterException("position needs to in the range 0 to 100");
        }
        this.setDictionaryValue(ASName.k_Position, PDFCosObject.newCosNumeric(this.getPDFDocument(), pos));
    }

    public boolean hasPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Position);
    }
}

