/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;

public class PDFMeasureGeo
extends PDFMeasure {
    private PDFMeasureGeo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMeasureGeo newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMeasureGeo pdfObject = new PDFMeasureGeo(cosObject);
        return pdfObject;
    }

    public static PDFMeasureGeo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMeasureGeo pdfObject = (PDFMeasureGeo)PDFCosObject.getCachedInstance(cosObject, PDFMeasureGeo.class);
        if (pdfObject == null) {
            pdfObject = new PDFMeasureGeo(cosObject);
        }
        return pdfObject;
    }

    public ASString getScaleRatio() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_R);
    }

    public void setScaleRatio(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_R, value);
    }

    public void setScaleRatio(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_R, value);
    }

    public boolean hasScaleRatio() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_R);
    }

    public CosArray getYAxis() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (CosArray)this.getDictionaryCosObjectValue(ASName.k_Y);
    }

    public void setYAxis(CosArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Y, children);
    }

    public boolean hasYAxis() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Y);
    }

    public CosArray getDistance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_D);
    }

    public void setDistance(CosArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_D, children);
    }

    public boolean hasDistance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public CosArray getOrigin() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_O);
    }

    public void setOrigin(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_O, value);
    }

    public boolean hasOrigin() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_O);
    }

    public CosArray getAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (CosArray)this.getDictionaryCosObjectValue(ASName.k_T);
    }

    public void setAngle(CosArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_T, children);
    }

    public boolean hasAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }

    public double getConvertYtoX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_CYX);
    }

    public void setConvertYtoX(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_CYX, value);
    }

    public boolean hasConvertYtoX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CYX);
    }

    public CosArray getSlope() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_S);
    }

    public void setSlope(CosArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_S, children);
    }

    public boolean hasSlope() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public CosArray getXAxis() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_X);
    }

    public void setXAxis(CosArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_X, children);
    }

    public boolean hasXAxis() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_X);
    }

    public CosArray getArea() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_A);
    }

    public void setArea(CosArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_A, children);
    }

    public boolean hasArea() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_A);
    }
}

