/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import java.util.Arrays;
import java.util.List;

public class PDFAnnotationScreen
extends PDFAnnotation {
    protected static final List requiredKeys = Arrays.asList("Subtype");
    protected static final List knownKeys = Arrays.asList("Subtype", "MK", "AA");

    private PDFAnnotationScreen(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationScreen newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationScreen(pdfDocument);
    }

    private PDFAnnotationScreen(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Screen);
    }

    public static PDFAnnotationScreen getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationScreen pdfObject = (PDFAnnotationScreen)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationScreen.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationScreen(cosObject);
        }
        return pdfObject;
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Subtype);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    @Override
    public PDFAdditionalActions getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAdditionalActionsAnnotation.getInstance(this.getDictionaryCosObjectValue(ASName.k_AA));
    }

    public void setAdditionalActions(PDFAdditionalActionsAnnotation value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_AA, value);
    }

    public PDFAdditionalActions procureAA() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasAdditionalActions()) {
            return PDFAdditionalActionsAnnotation.newInstance(this.getPDFDocument());
        }
        return this.getAdditionalActions();
    }

    public boolean hasAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AA);
    }

    public PDFAppearanceCharacteristics getMK() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAppearanceCharacteristics.getInstance(this.getDictionaryCosObjectValue(ASName.k_MK));
    }

    public void setMK(PDFAppearanceCharacteristics value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_MK, value);
    }

    public boolean hasMK() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MK);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int rotation = this.hasRotation() ? (int)Math.toDegrees((Math.toRadians(this.getRotation()) + rotationAngle) % Math.PI) : (int)Math.toDegrees(rotationAngle);
        this.setRotation(rotation);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

