/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFEmbeddedTarget;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;

public class PDFActionGoToEmbedded
extends PDFActionGoToRemote {
    private PDFActionGoToEmbedded(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionGoToEmbedded(PDFDocument pdfDocument, PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_GoToE);
        this.setDestination(pdfDestination);
    }

    public static PDFActionGoToEmbedded getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionGoToEmbedded pdfObject = (PDFActionGoToEmbedded)PDFCosObject.getCachedInstance(cosObject, PDFActionGoToEmbedded.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionGoToEmbedded(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionGoToEmbedded newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionGoTo = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionGoTo.put(ASName.k_Type, ASName.k_Action);
        cosActionGoTo.put(ASName.k_S, ASName.k_GoToE);
        return new PDFActionGoToEmbedded(cosActionGoTo);
    }

    public static PDFActionGoToEmbedded newInstance(PDFDocument pdfDocument, PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDestination == null) {
            throw new PDFInvalidDocumentException("Destination is a required key");
        }
        return new PDFActionGoToEmbedded(pdfDocument, pdfDestination);
    }

    public static PDFActionGoToEmbedded newInstance(PDFDocument pdfDocument, PDFEmbeddedTarget pdfEmbeddedTarget, PDFDestination pdfDestination, PDFFileSpecification pdfFileSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFActionGoToEmbedded instance = PDFActionGoToEmbedded.newInstance(pdfDocument, pdfDestination);
        if (pdfFileSpec != null) {
            instance.setFileSpecification(pdfFileSpec);
        }
        if (pdfEmbeddedTarget != null) {
            instance.setEmbeddedTarget(pdfEmbeddedTarget);
        } else if (pdfFileSpec == null) {
            throw new PDFInvalidParameterException("Target dictionary required if no File Spec is specified");
        }
        return instance;
    }

    public boolean hasEmbeddedTarget() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }

    public PDFEmbeddedTarget getEmbeddedTarget() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_T)) {
            return null;
        }
        return PDFEmbeddedTarget.getInstance(this.getDictionaryCosObjectValue(ASName.k_T));
    }

    public void setEmbeddedTarget(PDFEmbeddedTarget target) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_T, target);
    }
}

