/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;

public class PDFActionGoTo
extends PDFAction {
    private PDFActionGoTo(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFActionGoTo(PDFDocument pdfDocument, PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_GoTo);
        this.setDestination(pdfDestination);
    }

    public static PDFActionGoTo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionGoTo pdfObject = (PDFActionGoTo)PDFCosObject.getCachedInstance(cosObject, PDFActionGoTo.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionGoTo(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionGoTo newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionGoTo = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionGoTo.put(ASName.k_Type, ASName.k_Action);
        cosActionGoTo.put(ASName.k_S, ASName.k_GoTo);
        return PDFActionGoTo.getInstance(cosActionGoTo);
    }

    public static PDFActionGoTo newInstance(PDFDocument pdfDocument, PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDestination == null) {
            throw new PDFInvalidDocumentException("Destination can't be null, it's a required field.");
        }
        return new PDFActionGoTo(pdfDocument, pdfDestination);
    }

    public boolean hasDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public PDFDestination getDestination() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFDestination.getInstance(this.getDictionaryCosObjectValue(ASName.k_D));
    }

    public void setDestination(PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, pdfDestination);
    }
}

