/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCIEBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public class PDFColorSpaceCalRGB
extends PDFColorSpaceCIEBased {
    private PDFColorSpaceCalRGB(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceCalRGB getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceCalRGB pdfObject = (PDFColorSpaceCalRGB)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceCalRGB.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceCalRGB(cosObject);
        }
        return pdfObject;
    }

    public static PDFColorSpaceCalRGB newInstance(PDFDocument pdfDocument, double xw, double zw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFColorSpaceCalRGB pdfObject = new PDFColorSpaceCalRGB(cosObject);
        cosObject.addName(0, ASName.k_CalRGB);
        CosArray xyzSpaceObj = pdfObject.createCIEWhitePointArray(pdfDocument, xw, zw);
        CosDictionary csDict = pdfDocument.getCosDocument().createDirectCosDictionary();
        csDict.put(PDFColorSpace.k_WhitePoint, xyzSpaceObj);
        cosObject.add(1, csDict);
        return pdfObject;
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public ASName getName() {
        return ASName.k_CalRGB;
    }

    @Override
    public ColorSpace createColorSpace() {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public double[] getRange() {
        return PDFColorSpaceDeviceRGB.componentsRange;
    }

    @Override
    public double[] getWhitePoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return super.getWhitePoint();
    }

    @Override
    public void setWhitePoint(double[] whitePoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        super.setWhitePoint(whitePoint);
    }

    @Override
    public double[] getBlackPoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return super.getBlackPoint();
    }

    @Override
    public void setBlackPoint(double[] blackPoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        super.setBlackPoint(blackPoint);
    }

    public double[] getGamma() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray array = this.getDictionary().getDictionaryArrayValue(ASName.k_Gamma);
        if (array == null) {
            return new double[]{1.0, 1.0, 1.0};
        }
        return array.getArrayDouble();
    }

    public void setGamma(double[] gamma) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.getDictionary().setDictionaryArrayValue(ASName.k_Gamma, gamma);
    }

    public double[] getMatrix() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray array = this.getDictionary().getDictionaryArrayValue(ASName.k_Matrix);
        if (array == null) {
            return new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        }
        return array == null ? null : array.getArrayDouble();
    }

    public void setMatrix(double[] matrix) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.getDictionary().setDictionaryArrayValue(ASName.k_Matrix, matrix);
    }

    @Override
    public double[] toRGB(double[] calrgb) {
        calrgb = super.toRGB(calrgb);
        try {
            return ColorManager.calRGBToRGB(calrgb, this.getMatrix(), this.getGamma());
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] getDefaultColor() {
        return PDFColorSpaceDeviceRGB.defaultColor;
    }
}

